/*
 * Decompiled with CFR 0.152.
 */
package cassiokf.industrialrenewal.blocks;

import cassiokf.industrialrenewal.blocks.abstracts.BlockHorizontalFacing;
import cassiokf.industrialrenewal.tileentity.TileEntityEnergyLevel;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockEnergyLevel
extends BlockHorizontalFacing {
    public static final IProperty<EnumFacing> BASE = PropertyDirection.func_177714_a((String)"base");

    public BlockEnergyLevel(String name, CreativeTabs tab) {
        super(name, tab, Material.field_151573_f);
        this.func_149711_c(0.8f);
        this.func_180632_j(this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH));
    }

    @Nonnull
    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntityEnergyLevel te = (TileEntityEnergyLevel)world.func_175625_s(pos);
        if (te != null) {
            return state.func_177226_a(BASE, (Comparable)te.getBaseFacing());
        }
        return state;
    }

    @Override
    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, BASE});
    }

    @Nonnull
    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO()).func_177226_a(BASE, (Comparable)facing.func_176734_d());
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileEntity te = worldIn.func_175625_s(pos);
        EnumFacing facing = (EnumFacing)state.func_177229_b(BASE);
        if (te instanceof TileEntityEnergyLevel) {
            ((TileEntityEnergyLevel)te).setBaseFacing(facing);
        }
    }

    public void onNeighborChange(IBlockAccess world, BlockPos pos, BlockPos neighbor) {
        super.onNeighborChange(world, pos, neighbor);
        TileEntityEnergyLevel te = (TileEntityEnergyLevel)world.func_175625_s(pos);
        if (te != null) {
            te.forceCheck();
        }
    }

    public boolean rotateBlock(World world, BlockPos pos, EnumFacing axis) {
        boolean rotated = super.rotateBlock(world, pos, axis);
        TileEntityEnergyLevel te = (TileEntityEnergyLevel)world.func_175625_s(pos);
        if (te != null && world.field_72995_K) {
            te.forceIndicatorCheck();
        }
        return rotated;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    @Nonnull
    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nullable
    public TileEntityEnergyLevel createTileEntity(World world, IBlockState state) {
        return new TileEntityEnergyLevel();
    }
}

