/*
 * Decompiled with CFR 0.152.
 */
package cassiokf.industrialrenewal.blocks;

import cassiokf.industrialrenewal.blocks.BlockElectricGate;
import cassiokf.industrialrenewal.blocks.abstracts.BlockBasicElectricFence;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockElectricFence
extends BlockBasicElectricFence {
    public static final ImmutableList<IProperty<Boolean>> CONNECTED_PROPERTIES = ImmutableList.copyOf((Collection)Stream.of(EnumFacing.field_82609_l).map(facing -> PropertyBool.func_177716_a((String)facing.func_176610_l())).collect(Collectors.toList()));
    private static final float DOWNY1 = 0.0f;
    private static final float UPY2 = 1.5f;
    private static final float RUPY2 = 1.0f;
    private static float NORTHZ1 = 0.4375f;
    private static float SOUTHZ2 = 0.5625f;
    private static float WESTX1 = 0.4375f;
    private static float EASTX2 = 0.5625f;

    public BlockElectricFence(String name, CreativeTabs tab) {
        super(name, tab);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, (IProperty[])CONNECTED_PROPERTIES.toArray((Object[])new IProperty[CONNECTED_PROPERTIES.size()]));
    }

    @Deprecated
    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        IBlockState actualState = state.func_185899_b(world, pos);
        if (this.isConnected(actualState, EnumFacing.UP)) {
            return 7;
        }
        return 0;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P();
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    protected boolean isValidConnection(IBlockAccess world, BlockPos ownPos, EnumFacing neighbourDirection) {
        BlockPos neighbourPos = ownPos.func_177972_a(neighbourDirection);
        IBlockState neighbourState = world.func_180495_p(neighbourPos);
        Block nb = neighbourState.func_177230_c();
        if (neighbourDirection == EnumFacing.DOWN) {
            return false;
        }
        if (neighbourDirection == EnumFacing.UP) {
            int z = Math.abs(ownPos.func_177952_p());
            int x = Math.abs(ownPos.func_177958_n());
            int w = x - z;
            return nb.isAir(neighbourState, world, neighbourPos) && Math.abs(w) % 3 == 0;
        }
        return nb instanceof BlockElectricGate || neighbourState.func_185913_b() || nb instanceof BlockBasicElectricFence;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            state = state.func_177226_a((IProperty)CONNECTED_PROPERTIES.get(facing.func_176745_a()), (Comparable)Boolean.valueOf(this.isValidConnection(world, pos, facing)));
        }
        return state;
    }

    public final boolean isConnected(IBlockState state, EnumFacing facing) {
        return (Boolean)state.func_177229_b((IProperty)CONNECTED_PROPERTIES.get(facing.func_176745_a()));
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean isActualState) {
        if (!isActualState) {
            state = state.func_185899_b((IBlockAccess)worldIn, pos);
        }
        if (this.isConnected(state, EnumFacing.NORTH)) {
            NORTHZ1 = 0.0f;
        } else if (!this.isConnected(state, EnumFacing.NORTH)) {
            NORTHZ1 = 0.4375f;
        }
        if (this.isConnected(state, EnumFacing.SOUTH)) {
            SOUTHZ2 = 1.0f;
        } else if (!this.isConnected(state, EnumFacing.SOUTH)) {
            SOUTHZ2 = 0.5625f;
        }
        if (this.isConnected(state, EnumFacing.WEST)) {
            WESTX1 = 0.0f;
        } else if (!this.isConnected(state, EnumFacing.WEST)) {
            WESTX1 = 0.4375f;
        }
        if (this.isConnected(state, EnumFacing.EAST)) {
            EASTX2 = 1.0f;
        } else if (!this.isConnected(state, EnumFacing.EAST)) {
            EASTX2 = 0.5625f;
        }
        AxisAlignedBB AA_BB = new AxisAlignedBB((double)WESTX1, 0.0, (double)NORTHZ1, (double)EASTX2, 1.5, (double)SOUTHZ2);
        BlockElectricFence.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)AA_BB);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        IBlockState actualState = state.func_185899_b(source, pos);
        if (this.isConnected(actualState, EnumFacing.NORTH)) {
            NORTHZ1 = 0.0f;
        } else if (!this.isConnected(actualState, EnumFacing.NORTH)) {
            NORTHZ1 = 0.4375f;
        }
        if (this.isConnected(actualState, EnumFacing.SOUTH)) {
            SOUTHZ2 = 1.0f;
        } else if (!this.isConnected(actualState, EnumFacing.SOUTH)) {
            SOUTHZ2 = 0.5625f;
        }
        if (this.isConnected(actualState, EnumFacing.WEST)) {
            WESTX1 = 0.0f;
        } else if (!this.isConnected(actualState, EnumFacing.WEST)) {
            WESTX1 = 0.4375f;
        }
        if (this.isConnected(actualState, EnumFacing.EAST)) {
            EASTX2 = 1.0f;
        } else if (!this.isConnected(actualState, EnumFacing.EAST)) {
            EASTX2 = 0.5625f;
        }
        return new AxisAlignedBB((double)WESTX1, 0.0, (double)NORTHZ1, (double)EASTX2, 1.0, (double)SOUTHZ2);
    }
}

