/*
 * Decompiled with CFR 0.152.
 */
package mod.acgaming.universaltweaks.tweaks.performance.entityradiuscheck;

import com.google.common.collect.ImmutableSet;
import it.unimi.dsi.fastutil.objects.Reference2DoubleMap;
import it.unimi.dsi.fastutil.objects.Reference2DoubleMaps;
import it.unimi.dsi.fastutil.objects.Reference2DoubleOpenHashMap;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.Collections;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import mod.acgaming.universaltweaks.UniversalTweaks;
import mod.acgaming.universaltweaks.config.UTConfigTweaks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityItemFrame;
import net.minecraft.entity.item.EntityPainting;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.passive.AbstractHorse;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.registries.RegistryManager;

public class UTEntityRadiusCheck {
    public static Set<Class<? extends Entity>> searchTargets = Collections.emptySet();
    public static Reference2DoubleMap<Class<? extends Entity>> collisionTargets = Reference2DoubleMaps.emptyMap();

    public static void onLoadComplete() {
        if (UTConfigTweaks.PERFORMANCE.ENTITY_RADIUS_CHECK.utReduceSearchSizeToggle) {
            UTEntityRadiusCheck.initSearchTargets();
        }
        if (UTConfigTweaks.PERFORMANCE.ENTITY_RADIUS_CHECK.utLessCollisionsToggle) {
            UTEntityRadiusCheck.initCollisionTargets();
        }
    }

    public static void initSearchTargets() {
        ResourceLocation playerId = new ResourceLocation("player");
        ReferenceOpenHashSet out = new ReferenceOpenHashSet();
        for (String entityId : UTConfigTweaks.PERFORMANCE.ENTITY_RADIUS_CHECK.utReduceSearchSizeTargets) {
            Class<? extends Entity> entityClazz = UTEntityRadiusCheck.getEntityType(entityId, playerId, false);
            if (entityClazz == null) {
                UniversalTweaks.LOGGER.warn("UTEntityRadiusCheck ::: Invalid entity id " + entityId + "in \"[3] Reduce Search Size Targets\"! Skipping this entry.");
                continue;
            }
            out.add(entityClazz);
        }
        if (!out.isEmpty()) {
            searchTargets = out;
        }
    }

    public static void initCollisionTargets() {
        ResourceLocation ignored = new ResourceLocation("");
        collisionTargets = new Reference2DoubleOpenHashMap();
        Set vanillaEntities = (Set)RegistryManager.VANILLA.getRegistry(new ResourceLocation("entities")).getValuesCollection();
        Predicate<Class<? extends Entity>> vanillaPredicate = UTEntityRadiusCheck.buildVanillaPredicate();
        for (Object entry : vanillaEntities) {
            Class clazz = ((EntityEntry)entry).getEntityClass();
            if (!vanillaPredicate.test(clazz)) continue;
            collisionTargets.put((Object)clazz, 2.0);
        }
        for (String entry : UTConfigTweaks.PERFORMANCE.ENTITY_RADIUS_CHECK.utLessCollisionsExtraTargets) {
            double radius;
            int separator = entry.indexOf(";");
            if (separator == -1) {
                UniversalTweaks.LOGGER.warn("UTEntityRadiusCheck ::: Unexpected format " + entry + "in \"[5] Less Collisions Extra Targets\"! Skipping this entry.");
                continue;
            }
            String entityId = entry.substring(0, separator);
            try {
                radius = Double.parseDouble(entry.substring(separator + 1));
            }
            catch (NumberFormatException ex) {
                UniversalTweaks.LOGGER.warn("UTEntityRadiusCheck ::: Unexpected format " + entry + "in \"[5] Less Collisions Extra Targets\"! Skipping this entry.");
                continue;
            }
            Class<? extends Entity> entityClazz = UTEntityRadiusCheck.getEntityType(entityId, ignored, true);
            if (entityClazz == null) {
                UniversalTweaks.LOGGER.warn("UTEntityRadiusCheck ::: Invalid entity id " + entityId + "in \"[5] Less Collisions Extra Targets\"! Skipping this entry.");
                continue;
            }
            if (radius <= 0.0) {
                UniversalTweaks.LOGGER.warn("UTEntityRadiusCheck ::: Invalid radius " + radius + "in \"[5] Less Collisions Extra Targets\"! Skipping this entry.");
                continue;
            }
            collisionTargets.put(entityClazz, radius);
        }
    }

    @Nullable
    private static Class<? extends Entity> getEntityType(String entityId, ResourceLocation playerId, boolean nonVanillaOnly) {
        ResourceLocation entityLoc = new ResourceLocation(entityId);
        if (nonVanillaOnly && entityLoc.func_110624_b().equals("minecraft")) {
            return null;
        }
        if (entityId.equals(playerId.toString())) {
            return EntityPlayer.class;
        }
        return EntityList.getClass((ResourceLocation)entityLoc);
    }

    private static Predicate<Class<? extends Entity>> buildVanillaPredicate() {
        Predicate<Class<? extends Entity>> livingPredicate = new Predicate<Class<? extends Entity>>(){

            @Override
            public boolean test(Class<? extends Entity> entityClazz) {
                return EntityLivingBase.class.isAssignableFrom(entityClazz) && entityClazz != EntityWolf.class && !AbstractHorse.class.isAssignableFrom(entityClazz) && entityClazz != EntityPlayer.class && entityClazz != EntityDragon.class && entityClazz != EntityWither.class;
            }
        };
        Predicate<Class<? extends Entity>> miscPredicate = new Predicate<Class<? extends Entity>>(){

            @Override
            public boolean test(Class<? extends Entity> entityClazz) {
                ImmutableSet allowed = ImmutableSet.of(EntityItem.class, EntityItemFrame.class, EntityPainting.class, EntityXPOrb.class);
                return allowed.contains(entityClazz);
            }
        };
        return livingPredicate.or(miscPredicate);
    }
}

