/*
 * Decompiled with CFR 0.152.
 */
package mod.acgaming.universaltweaks.tweaks.misc.chat.mixin;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import mod.acgaming.universaltweaks.config.UTConfigTweaks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ChatLine;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiNewChat;
import net.minecraft.client.gui.GuiUtilRenderComponents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={GuiNewChat.class})
public abstract class UTCompactMessageMixin {
    @Unique
    private final Pattern universalTweaks$matchPattern = Pattern.compile("(?:\u00a77)?+\\s+\\(+\\d+\\)");
    @Shadow
    @Final
    private final List<ChatLine> field_146253_i = new ArrayList<ChatLine>();
    @Shadow
    @Final
    private final List<ChatLine> field_146252_h = new ArrayList<ChatLine>();
    @Shadow
    @Final
    private Minecraft field_146247_f;

    @Shadow
    public abstract float func_146244_h();

    @Shadow
    public abstract int func_146228_f();

    @Inject(method={"setChatLine"}, at={@At(value="HEAD")})
    public void utCompactMessage(ITextComponent chatComponent, int chatLineId, int updateCounter, boolean displayOnly, CallbackInfo ci) {
        if (!UTConfigTweaks.MISC.CHAT.utCompactMessagesToggle) {
            return;
        }
        int count = 1;
        int chatSize = MathHelper.func_76141_d((float)((float)this.func_146228_f() / this.func_146244_h()));
        List splittedText = GuiUtilRenderComponents.func_178908_a((ITextComponent)chatComponent, (int)chatSize, (FontRenderer)this.field_146247_f.field_71466_p, (boolean)false, (boolean)false);
        ITextComponent textComponent = (ITextComponent)splittedText.get(splittedText.size() - 1);
        for (int i = 0; i < this.field_146253_i.size(); ++i) {
            ChatLine chatLine = this.field_146253_i.get(i);
            if (!this.universalTweaks$isMessageEqual(chatLine.func_151461_a().func_150259_f(), textComponent.func_150259_f())) continue;
            if (!chatLine.func_151461_a().func_150253_a().isEmpty()) {
                for (ITextComponent sibling : chatLine.func_151461_a().func_150253_a()) {
                    if (!this.universalTweaks$matchPattern.matcher(sibling.func_150261_e()).matches()) continue;
                    count += Integer.parseInt(sibling.func_150261_e().replaceAll("(?:\u00a77)?\\D?", ""));
                    break;
                }
            }
            this.field_146253_i.removeIf(chatLine1 -> splittedText.contains(chatLine1.func_151461_a()) || chatLine1.equals(chatLine));
            this.field_146252_h.removeIf(chatLine1 -> chatLine1.func_151461_a().func_150261_e().equals(chatComponent.func_150261_e()));
            chatComponent.func_150257_a(new TextComponentString(" (" + count + ")").func_150255_a(new Style().func_150238_a(TextFormatting.GRAY)));
            break;
        }
    }

    @Unique
    private boolean universalTweaks$isMessageEqual(ITextComponent msg1, ITextComponent msg2) {
        boolean isEqual = false;
        if (msg1.equals(msg2) || msg1.func_150260_c().equals(msg2.func_150260_c())) {
            isEqual = true;
        } else if (!msg1.func_150253_a().isEmpty()) {
            for (int i = 0; i < msg1.func_150253_a().size(); ++i) {
                ITextComponent sibling = (ITextComponent)msg1.func_150253_a().get(i);
                if (!this.universalTweaks$matchPattern.matcher(sibling.func_150261_e()).matches()) continue;
                msg1.func_150253_a().remove(sibling);
            }
            if (msg1.equals(msg2) || msg1.func_150260_c().equals(msg2.func_150260_c())) {
                isEqual = true;
            }
        }
        return isEqual;
    }
}

