/*
 * Decompiled with CFR 0.152.
 */
package mod.acgaming.universaltweaks.mods.tconstruct.oredictcache;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import mod.acgaming.universaltweaks.UniversalTweaks;
import mod.acgaming.universaltweaks.mods.tconstruct.oredictcache.UTOreDictRecipesState;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraftforge.fml.common.Loader;

public class UTOreDictCache {
    public static final File cacheFile = new File("config" + File.separator + "tconstruct_oredictcache.dat");
    public static NBTTagCompound cacheNBT = new NBTTagCompound();

    public static void preInit() {
        NBTTagList modsNBT;
        UTOreDictRecipesState.setCurrentState(cacheFile.exists() ? UTOreDictRecipesState.READ : UTOreDictRecipesState.SCAN);
        if (UTOreDictRecipesState.getCurrentState().isRead()) {
            try {
                cacheNBT = Objects.requireNonNull(CompressedStreamTools.func_74797_a((File)cacheFile));
            }
            catch (IOException e) {
                UniversalTweaks.LOGGER.error("UTOreDictCache ::: Failed to read cache file! Rescanning all recipes...", (Throwable)e);
                UTOreDictRecipesState.setCurrentState(UTOreDictRecipesState.SCAN);
            }
            modsNBT = cacheNBT.func_150295_c("Mods", 8);
            if (!UTOreDictCache.hasSameElements(UTOreDictCache.getInstalledModIds(), StreamSupport.stream(modsNBT.spliterator(), false).map(nbt -> ((NBTTagString)nbt).func_150285_a_()).collect(Collectors.toList()))) {
                UniversalTweaks.LOGGER.info("UTOreDictCache ::: Detected installed mods are different from the last launch. Rescanning all recipes...");
                cacheNBT = new NBTTagCompound();
                UTOreDictRecipesState.setCurrentState(UTOreDictRecipesState.SCAN);
            }
        }
        if (UTOreDictRecipesState.getCurrentState().isScan()) {
            modsNBT = new NBTTagList();
            UTOreDictCache.getInstalledModIds().stream().map(NBTTagString::new).forEach(arg_0 -> ((NBTTagList)modsNBT).func_74742_a(arg_0));
            cacheNBT.func_74782_a("Mods", (NBTBase)modsNBT);
        }
    }

    public static void onLoadComplete() {
        cacheNBT = null;
    }

    public static Collection<String> getInstalledModIds() {
        return Loader.instance().getIndexedModList().keySet();
    }

    public static <T> boolean hasSameElements(Collection<T> first, Collection<T> second) {
        if (first.size() != second.size()) {
            return false;
        }
        HashSet<T> collection = new HashSet<T>(first);
        collection.addAll(second);
        return collection.size() == first.size();
    }
}

