/*
 * Decompiled with CFR 0.152.
 */
package mod.acgaming.universaltweaks.core;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import mod.acgaming.universaltweaks.config.UTConfigMods;
import mod.acgaming.universaltweaks.config.UTConfigTweaks;
import mod.acgaming.universaltweaks.core.UTLoadingPlugin;
import net.minecraftforge.fml.common.Loader;
import zone.rong.mixinbooter.ILateMixinLoader;

public class UTMixinLoader
implements ILateMixinLoader {
    private static final Map<String, Supplier<Boolean>> clientsideMixinConfigs = ImmutableMap.copyOf((Map)new HashMap<String, Supplier<Boolean>>(){
        {
            this.put("mixins.mods.bibliocraft.json", () -> UTMixinLoader.loaded("bibliocraft") && UTConfigMods.BIBLIOCRAFT.utDisableVersionCheckToggle);
            this.put("mixins.mods.cbmultipart.client.json", () -> UTMixinLoader.loaded("forgemultipartcbe") && UTConfigMods.CB_MULTIPART.utMemoryLeakFixToggle);
            this.put("mixins.mods.compactmachines.memory.json", () -> UTMixinLoader.loaded("compactmachines3") && UTConfigMods.COMPACT_MACHINES.utMemoryLeakFixToggle);
            this.put("mixins.mods.compactmachines.render.json", () -> UTMixinLoader.loaded("compactmachines3") && UTConfigMods.COMPACT_MACHINES.utCMRenderFixToggle);
            this.put("mixins.mods.crafttweaker.json", () -> UTMixinLoader.loaded("crafttweaker"));
            this.put("mixins.mods.enderio.json", () -> UTMixinLoader.loaded("enderio") && UTConfigMods.ENDER_IO.utReplaceItemRenderer);
            this.put("mixins.mods.hwyla.json", () -> UTMixinLoader.loaded("waila"));
            this.put("mixins.mods.ironchests.json", () -> UTMixinLoader.loaded("ironchest") && UTConfigMods.IRON_CHESTS.utReplaceItemRenderer);
            this.put("mixins.mods.modularrouters.json", () -> UTMixinLoader.loaded("modularrouters") && UTConfigMods.MODULAR_ROUTERS.utParticleThreadToggle);
            this.put("mixins.mods.roost.json", () -> UTMixinLoader.loaded("roost") && UTMixinLoader.loaded("contenttweaker"));
            this.put("mixins.mods.storagedrawers.client.json", () -> UTMixinLoader.loaded("storagedrawers"));
            this.put("mixins.mods.tconstruct.client.json", () -> UTMixinLoader.loaded("tconstruct") && UTConfigMods.TINKERS_CONSTRUCT.utParticleFixesToggle);
            this.put("mixins.mods.thaumcraft.entities.client.json", () -> UTMixinLoader.loaded("thaumcraft"));
        }
    });
    private static final Map<String, Supplier<Boolean>> commonMixinConfigs = ImmutableMap.copyOf((Map)new HashMap<String, Supplier<Boolean>>(){
        {
            this.put("mixins.mods.abyssalcraft.json", () -> UTMixinLoader.loaded("abyssalcraft"));
            this.put("mixins.mods.actuallyadditions.dupes.json", () -> UTMixinLoader.loaded("actuallyadditions") && UTConfigMods.ACTUALLY_ADDITIONS.utDuplicationFixesToggle);
            this.put("mixins.mods.actuallyadditions.itemparticle.json", () -> UTMixinLoader.loaded("actuallyadditions") && UTConfigMods.ACTUALLY_ADDITIONS.utItemLaserParticlesGraphics > -1);
            this.put("mixins.mods.actuallyadditions.relayupgrade.json", () -> UTMixinLoader.loaded("actuallyadditions") && UTConfigMods.ACTUALLY_ADDITIONS.utLaserUpgradeVoid);
            this.put("mixins.mods.aoa3.json", () -> UTMixinLoader.loaded("aoa3") && UTConfigMods.AOA.utImprovedPlayerTickToggle);
            this.put("mixins.mods.arcanearchives.dupes.json", () -> UTMixinLoader.loaded("arcanearchives") && UTConfigMods.ARCANE_ARCHIVES.utDuplicationFixesToggle);
            this.put("mixins.mods.astralsorcery.json", () -> UTMixinLoader.loaded("astralsorcery"));
            this.put("mixins.mods.biomesoplenty.json", () -> UTMixinLoader.loaded("biomesoplenty"));
            this.put("mixins.mods.biomesoplenty.sealevel.json", () -> UTMixinLoader.loaded("biomesoplenty") && UTConfigTweaks.WORLD.utSeaLevel != 63);
            this.put("mixins.mods.bloodmagic.dupes.json", () -> UTMixinLoader.loaded("bloodmagic") && UTConfigMods.BLOOD_MAGIC.utDuplicationFixesToggle);
            this.put("mixins.mods.bloodmagic.json", () -> UTMixinLoader.loaded("bloodmagic"));
            this.put("mixins.mods.botania.dupes.json", () -> UTMixinLoader.loaded("botania") && UTConfigMods.BOTANIA.utDuplicationFixesToggle);
            this.put("mixins.mods.botania.json", () -> UTMixinLoader.loaded("botania"));
            this.put("mixins.mods.cbmultipart.json", () -> UTMixinLoader.loaded("forgemultipartcbe") && UTConfigMods.CB_MULTIPART.utMemoryLeakFixToggle);
            this.put("mixins.mods.ceramics.json", () -> UTMixinLoader.loaded("ceramics"));
            this.put("mixins.mods.chisel.tcomplement.dupes.json", () -> UTMixinLoader.loaded("chisel") && UTMixinLoader.loaded("tcomplement") && UTConfigMods.CHISEL.utDuplicationFixesToggle);
            this.put("mixins.mods.codechickenlib.json", () -> UTMixinLoader.loaded("codechickenlib") && UTConfigMods.CCL.utPacketLeakFixToggle);
            this.put("mixins.mods.cofhcore.json", () -> UTMixinLoader.loaded("cofhcore"));
            this.put("mixins.mods.collective.json", () -> UTMixinLoader.loaded("collective"));
            this.put("mixins.mods.compactmachines.spawns.json", () -> UTMixinLoader.loaded("compactmachines3") && UTConfigMods.COMPACT_MACHINES.utAllowedSpawnsImprovementToggle);
            this.put("mixins.mods.cqrepoured.json", () -> UTMixinLoader.loaded("cqrepoured"));
            this.put("mixins.mods.effortlessbuilding.json", () -> UTMixinLoader.loaded("effortlessbuilding"));
            this.put("mixins.mods.elementarystaffs.json", () -> UTMixinLoader.loaded("element"));
            this.put("mixins.mods.elenaidodge2.json", () -> UTMixinLoader.loaded("elenaidodge2"));
            this.put("mixins.mods.enderstorage.json", () -> UTMixinLoader.loaded("enderstorage") && UTConfigMods.ENDER_STORAGE.utFrequencyTrackFixToggle);
            this.put("mixins.mods.epicsiegemod.json", () -> UTMixinLoader.loaded("epicsiegemod"));
            this.put("mixins.mods.erebus.cabbage.json", () -> UTMixinLoader.loaded("erebus") && UTConfigMods.EREBUS.utCabbageDrop);
            this.put("mixins.mods.erebus.json", () -> UTMixinLoader.loaded("erebus"));
            this.put("mixins.mods.erebus.quakehammer.json", () -> UTMixinLoader.loaded("erebus") && UTConfigMods.EREBUS.utFixQuakeHammerTexture);
            this.put("mixins.mods.extrautilities.breakcreativemill.json", () -> UTMixinLoader.loaded("extrautils2") && UTConfigMods.EXTRA_UTILITIES.utFixCreativeMillHarvestability);
            this.put("mixins.mods.extrautilities.deepdarkstats.json", () -> UTMixinLoader.loaded("extrautils2") && UTConfigMods.EXTRA_UTILITIES.utDeepDarkStats);
            this.put("mixins.mods.extrautilities.dupes.json", () -> UTMixinLoader.loaded("extrautils2") && UTConfigMods.EXTRA_UTILITIES.utDuplicationFixesToggle);
            this.put("mixins.mods.extrautilities.mutabledrops.json", () -> UTMixinLoader.loaded("extrautils2") && UTConfigMods.EXTRA_UTILITIES.utMutableBlockDrops);
            this.put("mixins.mods.extrautilities.potionlogging.json", () -> UTMixinLoader.loaded("extrautils2") && UTConfigMods.EXTRA_UTILITIES.utDowngradePotionLogging);
            this.put("mixins.mods.extrautilities.radar.json", () -> UTMixinLoader.loaded("extrautils2") && UTConfigMods.EXTRA_UTILITIES.utCatchRadarException);
            this.put("mixins.mods.forestry.cocoa.json", () -> UTMixinLoader.loaded("forestry") && UTConfigMods.FORESTRY.utFOCocoaBeansToggle);
            this.put("mixins.mods.forestry.dupes.json", () -> UTMixinLoader.loaded("forestry") && UTConfigMods.FORESTRY.utDuplicationFixesToggle);
            this.put("mixins.mods.forestry.extratrees.json", () -> UTMixinLoader.loaded("extratrees"));
            this.put("mixins.mods.forestry.json", () -> UTMixinLoader.loaded("forestry"));
            this.put("mixins.mods.incontrol.json", () -> UTMixinLoader.loaded("incontrol") && UTConfigMods.INCONTROL.utStatsFixToggle);
            this.put("mixins.mods.industrialcraft.dupes.json", () -> UTMixinLoader.loaded("ic2") && UTConfigMods.INDUSTRIALCRAFT.utDuplicationFixesToggle);
            this.put("mixins.mods.industrialforegoing.dupes.json", () -> UTMixinLoader.loaded("industrialforegoing") && UTConfigMods.INDUSTRIAL_FOREGOING.utDuplicationFixesToggle);
            this.put("mixins.mods.industrialforegoing.rangeaddon.json", () -> UTMixinLoader.loaded("industrialforegoing") && UTConfigMods.INDUSTRIAL_FOREGOING.utRangeAddonNumberFix);
            this.put("mixins.mods.infernalmobs.json", () -> UTMixinLoader.loaded("infernalmobs"));
            this.put("mixins.mods.ironbackpacks.dupes.json", () -> UTMixinLoader.loaded("ironbackpacks") && UTConfigMods.IRON_BACKPACKS.utDuplicationFixesToggle);
            this.put("mixins.mods.itemstages.json", () -> UTMixinLoader.loaded("itemstages"));
            this.put("mixins.mods.mekanism.dupes.json", () -> UTMixinLoader.loaded("mekanism") && UTConfigMods.MEKANISM.utDuplicationFixesToggle);
            this.put("mixins.mods.mobstages.json", () -> UTMixinLoader.loaded("mobstages"));
            this.put("mixins.mods.mrtjpcore.json", () -> UTMixinLoader.loaded("mrtjpcore") && UTConfigMods.MRTJPCORE.utMemoryLeakFixToggle);
            this.put("mixins.mods.netherchest.dupes.json", () -> UTMixinLoader.loaded("netherchest") && UTConfigMods.NETHER_CHEST.utDuplicationFixesToggle);
            this.put("mixins.mods.netherrocks.json", () -> UTMixinLoader.loaded("netherrocks"));
            this.put("mixins.mods.nuclearcraft.json", () -> UTMixinLoader.loaded("nuclearcraft"));
            this.put("mixins.mods.openblocks.json", () -> UTMixinLoader.loaded("openblocks") && UTConfigMods.OPEN_BLOCKS.utLastStandFixToggle);
            this.put("mixins.mods.opencomputers.json", () -> UTMixinLoader.loaded("opencomputers") && UTConfigMods.OPEN_COMPUTERS.utPacketLeakFixToggle);
            this.put("mixins.mods.quark.dupes.json", () -> UTMixinLoader.loaded("quark") && UTConfigMods.QUARK.utDuplicationFixesToggle);
            this.put("mixins.mods.randomthings.anvil.json", () -> UTMixinLoader.loaded("randomthings") && UTConfigMods.RANDOM_THINGS.utAnvilCraftFix);
            this.put("mixins.mods.requiousfrakto.json", () -> UTMixinLoader.loaded("requious") && UTConfigMods.REQUIOUS_FRAKTO.utParticleFixesToggle);
            this.put("mixins.mods.reskillable.json", () -> UTMixinLoader.loaded("reskillable"));
            this.put("mixins.mods.rftoolsdimensions.json", () -> UTMixinLoader.loaded("rftoolsdim"));
            this.put("mixins.mods.roost.contenttweaker.json", () -> UTMixinLoader.loaded("contenttweaker"));
            this.put("mixins.mods.simpledifficulty.json", () -> UTMixinLoader.loaded("simpledifficulty"));
            this.put("mixins.mods.steamworld.json", () -> UTMixinLoader.loaded("steamworld") && UTConfigMods.STEAMWORLD.utSkyOfOldFixToggle);
            this.put("mixins.mods.spiceoflife.dupes.json", () -> UTMixinLoader.loaded("spiceoflife") && UTConfigMods.SPICE_OF_LIFE.utDuplicationFixesToggle);
            this.put("mixins.mods.tconstruct.json", () -> UTMixinLoader.loaded("tconstruct"));
            this.put("mixins.mods.tconstruct.oredictcache.json", () -> UTMixinLoader.loaded("tconstruct") && UTConfigMods.TINKERS_CONSTRUCT.utTConOreDictCacheToggle);
            this.put("mixins.mods.tconstruct.toolcustomization.json", () -> UTMixinLoader.loaded("tconstruct") && UTConfigMods.TINKERS_CONSTRUCT.utTConToolCustomizationToggle);
            this.put("mixins.mods.tconstruct.toolcustomization.plustic.json", () -> UTMixinLoader.loaded("tconstruct") && UTMixinLoader.loaded("plustic") && UTConfigMods.TINKERS_CONSTRUCT.utTConToolCustomizationToggle);
            this.put("mixins.mods.techreborn.json", () -> UTMixinLoader.loaded("techreborn"));
            this.put("mixins.mods.thaumcraft.foci.focuseffects.json", () -> UTMixinLoader.loaded("thaumcraft"));
            this.put("mixins.mods.thaumcraft.foci.focusmediums.json", () -> UTMixinLoader.loaded("thaumcraft"));
            this.put("mixins.mods.thaumcraft.json", () -> UTMixinLoader.loaded("thaumcraft"));
            this.put("mixins.mods.thaumicwonders.dupes.json", () -> UTMixinLoader.loaded("thaumicwonders") && UTConfigMods.THAUMIC_WONDERS.utDuplicationFixesToggle);
            this.put("mixins.mods.thefarlanders.dupes.json", () -> UTMixinLoader.loaded("farlanders") && UTConfigMods.THE_FARLANDERS.utDuplicationFixesToggle);
            this.put("mixins.mods.thermalexpansion.dupes.json", () -> UTMixinLoader.loaded("thermalexpansion") && UTConfigMods.THERMAL_EXPANSION.utDuplicationFixesToggle);
            this.put("mixins.mods.thermalexpansion.json", () -> UTMixinLoader.loaded("thermalexpansion"));
            this.put("mixins.mods.tinyprogressions.dupes.json", () -> UTMixinLoader.loaded("tp") && UTConfigMods.TINY_PROGRESSIONS.utDuplicationFixesToggle);
            this.put("mixins.mods.woot.json", () -> UTMixinLoader.loaded("woot") && UTConfigMods.WOOT.utCleanupSimulatedKillsToggle);
        }
    });

    private static boolean loaded(String modid) {
        return Loader.isModLoaded((String)modid);
    }

    public List<String> getMixinConfigs() {
        ArrayList<String> configs = new ArrayList<String>();
        if (UTLoadingPlugin.isClient) {
            configs.addAll(clientsideMixinConfigs.keySet());
        }
        configs.addAll(commonMixinConfigs.keySet());
        return configs;
    }

    public boolean shouldMixinConfigQueue(String mixinConfig) {
        Supplier<Boolean> sidedSupplier = UTLoadingPlugin.isClient ? clientsideMixinConfigs.get(mixinConfig) : null;
        Supplier<Boolean> commonSupplier = commonMixinConfigs.get(mixinConfig);
        return sidedSupplier != null ? sidedSupplier.get() : commonSupplier == null || commonSupplier.get() != false;
    }
}

