/*
 * Decompiled with CFR 0.152.
 */
package io.github.phantamanta44.threng.client.gui;

import appeng.container.slot.SlotFake;
import appeng.util.ReadableNumberConverter;
import io.github.phantamanta44.libnine.client.gui.L9GuiContainer;
import io.github.phantamanta44.libnine.client.gui.component.GuiComponent;
import io.github.phantamanta44.libnine.client.gui.component.impl.GuiComponentTextInput;
import io.github.phantamanta44.libnine.gui.L9Container;
import io.github.phantamanta44.libnine.util.render.GuiUtils;
import io.github.phantamanta44.threng.constant.ResConst;
import io.github.phantamanta44.threng.inventory.ContainerLevelMaintainer;
import io.github.phantamanta44.threng.tile.TileLevelMaintainer;
import java.util.function.LongConsumer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.inventory.Slot;

public class GuiLevelMaintainer
extends L9GuiContainer {
    public static final int GUI_HEIGHT = 214;
    private final ContainerLevelMaintainer cont;
    private final GuiComponentTextInput[] qtyInputs = new GuiComponentTextInput[5];
    private final GuiComponentTextInput[] batchInputs = new GuiComponentTextInput[5];

    public GuiLevelMaintainer(ContainerLevelMaintainer cont) {
        super((L9Container)cont, ResConst.GUI_LEVEL_MAINTAINER.getTexture(), 176, 214);
        this.cont = cont;
        for (int i = 0; i < 5; ++i) {
            int index = i;
            this.qtyInputs[i] = this.createTextBox(38, 21 + 20 * i, cont.getRequestQuantity(i), "threng.misc.tooltip.request_size", q -> cont.updateRequestQuantity(index, q));
            this.batchInputs[i] = this.createTextBox(101, 21 + 20 * i, cont.getBatchSize(i), "threng.misc.tooltip.batch_size", q -> cont.updateBatchSize(index, q));
        }
    }

    private GuiComponentTextInput createTextBox(int x, int y, long initial, String tooltipKey, LongConsumer callback) {
        GuiComponentTextInput comp = new GuiComponentTextInput(x, y, 41, 6, ResConst.GUI_COMP_SUBMIT_NORMAL, ResConst.GUI_COMP_SUBMIT_HOVERED, ResConst.GUI_COMP_SUBMIT_DISABLED, 0xFFFFFF, 0xDD1515, s -> {
            try {
                return Long.parseLong(s) >= 0L;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }, s -> callback.accept(Long.parseLong(s)), Long.toString(initial), tooltipKey);
        this.addComponent((GuiComponent)comp);
        return comp;
    }

    public void updateTextBoxes(TileLevelMaintainer.InventoryRequest requests) {
        for (int i = 0; i < 5; ++i) {
            if (!this.qtyInputs[i].isFocused()) {
                this.qtyInputs[i].setValue(Long.toString(requests.getQuantity(i)));
            }
            if (this.batchInputs[i].isFocused()) continue;
            this.batchInputs[i].setValue(Long.toString(requests.getBatchSize(i)));
        }
    }

    public void drawForeground(float partialTicks, int mX, int mY) {
        super.drawForeground(partialTicks, mX, mY);
        this.drawContainerName(I18n.func_135052_a((String)"threng.container.level_maintainer", (Object[])new Object[0]));
    }

    public void func_146977_a(Slot slot) {
        long count;
        super.func_146977_a(slot);
        if (slot instanceof SlotFake && (count = this.cont.getRequestQuantity(slot.getSlotIndex())) > 0L) {
            String countStr = ReadableNumberConverter.INSTANCE.toSlimReadableForm(count);
            GlStateManager.func_179094_E();
            GlStateManager.func_179097_i();
            GlStateManager.func_179152_a((float)0.75f, (float)0.75f, (float)0.75f);
            this.drawString(countStr, (int)Math.floor(((float)(slot.field_75223_e + 16) - (float)GuiUtils.getStringWidth((String)countStr) * 0.375f) * 1.333f), (int)Math.floor(((float)(slot.field_75221_f + 16) - (float)GuiUtils.getFontHeight() * 0.375f) * 1.333f), 0xFFFFFF, true);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179126_j();
            GlStateManager.func_179121_F();
        }
    }
}

