/*
 * Decompiled with CFR 0.152.
 */
package io.github.phantamanta44.libnine.util.data.serialization;

public interface IDatum<T> {
    public static <T> IDatum<T> of(T value) {
        return new NonPrim<T>(value);
    }

    public static OfInt ofInt(int value) {
        return new OfInt(value);
    }

    public static OfFloat ofFloat(float value) {
        return new OfFloat(value);
    }

    public static OfDouble ofDouble(double value) {
        return new OfDouble(value);
    }

    public static OfByte ofByte(byte value) {
        return new OfByte(value);
    }

    public static OfShort ofShort(short value) {
        return new OfShort(value);
    }

    public static OfLong ofLong(long value) {
        return new OfLong(value);
    }

    public static OfBool ofBool(boolean value) {
        return new OfBool(value);
    }

    public void set(T var1);

    public T get();

    public static class OfBool
    implements IDatum<Boolean> {
        private boolean value;

        OfBool(boolean value) {
            this.value = value;
        }

        @Override
        public void set(Boolean value) {
            this.setBool(value);
        }

        public void setBool(boolean value) {
            this.value = value;
        }

        @Override
        public Boolean get() {
            return this.isTrue();
        }

        public boolean isTrue() {
            return this.value;
        }
    }

    public static class OfLong
    implements IDatum<Long> {
        private long value;

        OfLong(long value) {
            this.value = value;
        }

        @Override
        public void set(Long value) {
            this.setLong(value);
        }

        public void setLong(long value) {
            this.value = value;
        }

        @Override
        public Long get() {
            return this.getLong();
        }

        public long getLong() {
            return this.value;
        }

        public long preincrement(long offset) {
            return (this.value += offset) - offset;
        }

        public long preincrement() {
            return this.preincrement(1L);
        }

        public long postincrement(long offset) {
            return this.value += offset;
        }

        public long postincrement() {
            return this.postincrement(1L);
        }
    }

    public static class OfShort
    implements IDatum<Short> {
        private short value;

        OfShort(short value) {
            this.value = value;
        }

        @Override
        public void set(Short value) {
            this.setShort(value);
        }

        public void setShort(short value) {
            this.value = value;
        }

        @Override
        public Short get() {
            return this.getShort();
        }

        public short getShort() {
            return this.value;
        }

        public short preincrement(short offset) {
            this.value = (short)(this.value + offset);
            return (short)(this.value - offset);
        }

        public short preincrement() {
            return this.preincrement((short)1);
        }

        public short postincrement(short offset) {
            this.value = (short)(this.value + offset);
            return this.value;
        }

        public short postincrement() {
            return this.postincrement((short)1);
        }
    }

    public static class OfByte
    implements IDatum<Byte> {
        private byte value;

        OfByte(byte value) {
            this.value = value;
        }

        @Override
        public void set(Byte value) {
            this.setByte(value);
        }

        public void setByte(byte value) {
            this.value = value;
        }

        @Override
        public Byte get() {
            return this.getByte();
        }

        public byte getByte() {
            return this.value;
        }
    }

    public static class OfDouble
    implements IDatum<Double> {
        private double value;

        OfDouble(double value) {
            this.value = value;
        }

        @Override
        public void set(Double value) {
            this.setDouble(value);
        }

        public void setDouble(double value) {
            this.value = value;
        }

        @Override
        public Double get() {
            return this.getDouble();
        }

        public double getDouble() {
            return this.value;
        }

        public double preincrement(double offset) {
            return (this.value += offset) - offset;
        }

        public double postincrement(double offset) {
            return this.value += offset;
        }
    }

    public static class OfFloat
    implements IDatum<Float> {
        private float value;

        OfFloat(float value) {
            this.value = value;
        }

        @Override
        public void set(Float value) {
            this.setFloat(value.floatValue());
        }

        public void setFloat(float value) {
            this.value = value;
        }

        @Override
        public Float get() {
            return Float.valueOf(this.getFloat());
        }

        public float getFloat() {
            return this.value;
        }

        public float preincrement(float offset) {
            return (this.value += offset) - offset;
        }

        public float postincrement(float offset) {
            return this.value += offset;
        }
    }

    public static class OfInt
    implements IDatum<Integer> {
        private int value;

        OfInt(int value) {
            this.value = value;
        }

        @Override
        public void set(Integer value) {
            this.setInt(value);
        }

        public void setInt(int value) {
            this.value = value;
        }

        @Override
        public Integer get() {
            return this.getInt();
        }

        public int getInt() {
            return this.value;
        }

        public int preincrement(int offset) {
            return (this.value += offset) - offset;
        }

        public int preincrement() {
            return this.preincrement(1);
        }

        public int postincrement(int offset) {
            return this.value += offset;
        }

        public int postincrement() {
            return this.postincrement(1);
        }
    }

    public static class NonPrim<T>
    implements IDatum<T> {
        private T value;

        NonPrim(T value) {
            this.value = value;
        }

        @Override
        public void set(T value) {
            this.value = value;
        }

        @Override
        public T get() {
            return this.value;
        }
    }
}

