/*
 * Decompiled with CFR 0.152.
 */
package io.github.phantamanta44.libnine.tile;

import io.github.phantamanta44.libnine.LibNine;
import io.github.phantamanta44.libnine.capability.provider.NoopCapabilities;
import io.github.phantamanta44.libnine.util.LazyConstant;
import io.github.phantamanta44.libnine.util.data.ByteUtils;
import io.github.phantamanta44.libnine.util.data.ISerializable;
import io.github.phantamanta44.libnine.util.data.serialization.DataSerialization;
import io.github.phantamanta44.libnine.util.world.WorldBlockPos;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class L9TileEntity
extends TileEntity
implements ISerializable {
    private final DataSerialization serializer = new DataSerialization(this);
    private final LazyConstant<ICapabilityProvider> capabilityBroker = new LazyConstant<ICapabilityProvider>(this::initCapabilities);
    @Nullable
    private WorldBlockPos worldPos = null;
    private boolean requiresSync = false;

    protected ICapabilityProvider initCapabilities() {
        return new NoopCapabilities();
    }

    protected void markRequiresSync() {
        this.requiresSync = true;
    }

    public WorldBlockPos getWorldPos() {
        return this.worldPos == null ? (this.worldPos = new WorldBlockPos(this.field_145850_b, this.field_174879_c)) : this.worldPos;
    }

    protected void setDirty() {
        if (this.field_145850_b != null) {
            this.func_70296_d();
            if (!this.field_145850_b.field_72995_K) {
                LibNine.PROXY.getTileEntityDispatcher().queueTileUpdate(this);
            }
        }
    }

    public void func_174878_a(BlockPos pos) {
        super.func_174878_a(pos);
        if (this.field_145850_b != null) {
            this.worldPos = new WorldBlockPos(this.field_145850_b, pos);
        }
    }

    public void func_145834_a(World world) {
        super.func_145834_a(world);
        if (this.field_174879_c != null) {
            this.worldPos = new WorldBlockPos(world, this.field_174879_c);
        }
    }

    public void dispatchTileUpdate() {
        if (this.requiresSync) {
            LibNine.PROXY.dispatchTileUpdate(this);
        }
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return this.capabilityBroker.get().hasCapability(capability, facing) || super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        Object aspect = this.capabilityBroker.get().getCapability(capability, facing);
        return (T)(aspect != null ? aspect : super.getCapability(capability, facing));
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.worldPos = new WorldBlockPos(this.field_145850_b, this.field_174879_c);
        this.serializer.deserializeNBT(compound);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        this.serializer.serializeNBT(compound);
        return compound;
    }

    @Override
    public void deserNBT(NBTTagCompound nbt) {
        this.func_145839_a(nbt);
    }

    @Override
    public void serNBT(NBTTagCompound tag) {
        this.func_189515_b(tag);
    }

    @Override
    public void serBytes(ByteUtils.Writer data) {
        this.serializer.serializeBytes(data, true);
    }

    @Override
    public void deserBytes(ByteUtils.Reader data) {
        this.serializer.deserializeBytes(data, true);
    }

    public void onTileSyncPacket(ByteUtils.Reader data) {
        this.deserBytes(data);
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return this.requiresSync ? new SPacketUpdateTileEntity(this.field_174879_c, 0, this.func_189517_E_()) : null;
    }

    public NBTTagCompound func_189517_E_() {
        return this.serializeNBT();
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }
}

