/*
 * Decompiled with CFR 0.152.
 */
package io.github.phantamanta44.libnine.client.model;

import com.google.common.collect.Table;
import com.google.common.collect.Tables;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import io.github.phantamanta44.libnine.client.model.ParameterizedItemModelLoader;
import io.github.phantamanta44.libnine.util.ImpossibilityRealizedException;
import io.github.phantamanta44.libnine.util.helper.JsonUtils9;
import io.github.phantamanta44.libnine.util.tuple.IPair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.model.IModelState;

public class ParameterizedItemModel
implements IModel {
    private final Map<String, IPair<Integer, String[]>> mutKeyMap = new HashMap<String, IPair<Integer, String[]>>();
    private final List<IPair<String, String[]>> mutKeyMapInv = new ArrayList<IPair<String, String[]>>();
    private final MutationState[] mutationSet;
    private final IModel[] models;

    ParameterizedItemModel(ParameterizedItemModelLoader.ResourceInjector resourceInjector, JsonObject archetype, @Nullable Table<String, String, JsonElement> mutations) {
        if (mutations != null) {
            int[] maxValueIndices = new int[mutations.rowKeySet().size()];
            int totalMutCount = 1;
            int index = 0;
            for (Map.Entry keyEntry : mutations.rowMap().entrySet()) {
                Map valueMap = (Map)keyEntry.getValue();
                String key = (String)keyEntry.getKey();
                String[] valueSet = valueMap.keySet().toArray(new String[0]);
                this.mutKeyMap.put(key, IPair.of(index, valueSet));
                this.mutKeyMapInv.add(IPair.of(key, valueSet));
                int valueCount = valueMap.size();
                maxValueIndices[index] = valueCount - 1;
                totalMutCount *= valueCount;
                ++index;
            }
            this.mutationSet = new MutationState[totalMutCount];
            this.models = new IModel[totalMutCount];
            int[] valueIndices = new int[maxValueIndices.length];
            index = 0;
            block1: while (true) {
                MutationState mut;
                int[] currentValueIndices = Arrays.copyOf(valueIndices, valueIndices.length);
                this.mutationSet[index] = mut = new MutationState(this, index, currentValueIndices);
                for (int i = 0; i < valueIndices.length; ++i) {
                    int n = i;
                    valueIndices[n] = valueIndices[n] + 1;
                    if (valueIndices[n] <= maxValueIndices[i]) break;
                    if (i == valueIndices.length - 1) break block1;
                    valueIndices[i] = 0;
                }
                ++index;
            }
            for (MutationState mut : this.mutationSet) {
                mut.cacheAdjacents();
                this.models[((MutationState)mut).index] = this.mutateModel(archetype, mutations, mut).compile(resourceInjector);
            }
        } else {
            this.mutationSet = new MutationState[]{new MutationState(this, 0, new int[0])};
            this.models = new IModel[]{new IChildModel.JsonModel(archetype).compile(resourceInjector)};
        }
    }

    private IChildModel mutateModel(JsonObject model, Table<String, String, JsonElement> mutations, MutationState mutation) {
        JsonObject result = JsonUtils9.copy(model);
        for (int i = 0; i < this.mutKeyMapInv.size(); ++i) {
            IPair<String, String[]> keyEntry = this.mutKeyMapInv.get(i);
            JsonElement mutator = (JsonElement)mutations.get((Object)keyEntry.getA(), (Object)keyEntry.getB()[mutation.valueIndices[i]]);
            if (!mutator.isJsonObject()) {
                if (mutator.isJsonPrimitive()) {
                    JsonPrimitive mutatorPrim = mutator.getAsJsonPrimitive();
                    if (mutatorPrim.isString()) {
                        String mutatorStr = mutatorPrim.getAsString();
                        int spaceIndex = mutatorStr.indexOf(32);
                        if (spaceIndex != -1) {
                            String arg = mutatorStr.substring(spaceIndex + 1);
                            if (mutatorStr.substring(0, spaceIndex).equals("supplant")) {
                                return new IChildModel.Supplant(new ResourceLocation(arg));
                            }
                            throw new IllegalArgumentException("Unknown parametric mutator directive: " + mutatorStr);
                        }
                        throw new IllegalArgumentException("Unknown zero-arg mutator directive: " + mutatorStr);
                    }
                    throw new IllegalArgumentException("Cannot parse mutator: " + mutator);
                }
                throw new IllegalArgumentException("Cannot parse mutator: " + mutator);
            }
            JsonUtils9.merge(result, mutator.getAsJsonObject());
        }
        return new IChildModel.JsonModel(result);
    }

    public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> textureBaker) {
        return new ParameterizedItemModelBakedModelDelegator(this, (IBakedModel[])Arrays.stream(this.models).map(m -> m.bake(state, format, textureBaker)).toArray(IBakedModel[]::new));
    }

    private static boolean arrayEqualsWithChange(int[] arr, int changeIndex, int changeValue, int[] toTest) {
        for (int i = 0; i < arr.length; ++i) {
            if (toTest[i] == (i == changeIndex ? changeValue : arr[i])) continue;
            return false;
        }
        return true;
    }

    private static class MutationState {
        private final ParameterizedItemModel model;
        private final int index;
        private final int[] valueIndices;
        private final Table<String, String, MutationState> adjTable;

        MutationState(ParameterizedItemModel model, int index, int[] valueIndices) {
            this.model = model;
            this.index = index;
            this.valueIndices = valueIndices;
            this.adjTable = Tables.newCustomTable(new HashMap(), HashMap::new);
        }

        void cacheAdjacents() {
            this.model.mutKeyMap.forEach((key, keyEntry) -> {
                int keyIndex = (Integer)keyEntry.getA();
                String[] valueSet = (String[])keyEntry.getB();
                int i = 0;
                while (i < valueSet.length) {
                    int valueIndex = i++;
                    this.adjTable.put(key, (Object)valueSet[valueIndex], (Object)Arrays.stream(this.model.mutationSet).filter(mut -> ParameterizedItemModel.arrayEqualsWithChange(this.valueIndices, keyIndex, valueIndex, mut.valueIndices)).findAny().orElseThrow(ImpossibilityRealizedException::new));
                }
            });
        }

        public MutationState mutate(String key, String value) {
            MutationState result = (MutationState)this.adjTable.get((Object)key, (Object)value);
            if (result == null) {
                throw new IllegalArgumentException("Invalid mutation: " + key + "=" + value);
            }
            return result;
        }

        public String toString() {
            return "Mutation { " + this.model.mutKeyMap.entrySet().stream().map(entry -> String.format("%s=%s", entry.getKey(), ((String[])((IPair)entry.getValue()).getB())[this.valueIndices[(Integer)((IPair)entry.getValue()).getA()]])).collect(Collectors.joining(", ")) + " }";
        }
    }

    public static class Mutation {
        private MutationState state;

        Mutation(MutationState initialState) {
            this.state = initialState;
        }

        public Mutation mutate(String key, String value) {
            this.state = this.state.mutate(key, value);
            return this;
        }
    }

    public static interface IContextSensitive {
        public void getModelMutations(ItemStack var1, @Nullable World var2, @Nullable EntityLivingBase var3, Mutation var4);
    }

    public static interface IParamaterized
    extends IContextSensitive {
        public void getModelMutations(ItemStack var1, Mutation var2);

        @Override
        default public void getModelMutations(ItemStack stack, @Nullable World world, @Nullable EntityLivingBase holder, Mutation m) {
            this.getModelMutations(stack, m);
        }
    }

    private static class ParameterizedItemModelBakedModelDelegator
    implements IBakedModel {
        private final ParameterizedItemModel model;
        private final IBakedModel[] children;
        private final IBakedModel defaultDelegate;

        ParameterizedItemModelBakedModelDelegator(ParameterizedItemModel model, IBakedModel[] children) {
            this.model = model;
            this.children = children;
            this.defaultDelegate = children[0];
        }

        public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
            return this.defaultDelegate.func_188616_a(state, side, rand);
        }

        public boolean func_177555_b() {
            return this.defaultDelegate.func_177555_b();
        }

        public boolean func_177556_c() {
            return this.defaultDelegate.func_177556_c();
        }

        public boolean func_188618_c() {
            return this.defaultDelegate.func_188618_c();
        }

        public TextureAtlasSprite func_177554_e() {
            return this.defaultDelegate.func_177554_e();
        }

        public ItemOverrideList func_188617_f() {
            return new ParameterizedItemModelOverrideList(this);
        }

        private static class ParameterizedItemModelOverrideList
        extends ItemOverrideList {
            private final ParameterizedItemModelBakedModelDelegator container;

            ParameterizedItemModelOverrideList(ParameterizedItemModelBakedModelDelegator container) {
                super(Collections.emptyList());
                this.container = container;
            }

            public IBakedModel handleItemState(IBakedModel originalModel, ItemStack stack, @Nullable World world, @Nullable EntityLivingBase entity) {
                Mutation mutation = new Mutation(this.container.model.mutationSet[0]);
                ((IContextSensitive)stack.func_77973_b()).getModelMutations(stack, world, entity, mutation);
                IBakedModel delegate = this.container.children[mutation.state.index];
                return delegate.func_188617_f().handleItemState(delegate, stack, world, entity);
            }
        }
    }

    private static interface IChildModel {
        public IModel compile(ParameterizedItemModelLoader.ResourceInjector var1);

        public static class Supplant
        implements IChildModel {
            private final ResourceLocation suppletion;

            Supplant(ResourceLocation suppletion) {
                this.suppletion = suppletion;
            }

            @Override
            public IModel compile(ParameterizedItemModelLoader.ResourceInjector resourceInjector) {
                try {
                    return ModelLoaderRegistry.getModel((ResourceLocation)this.suppletion);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }

        public static class JsonModel
        implements IChildModel {
            private final JsonObject src;

            JsonModel(JsonObject src) {
                this.src = src;
            }

            @Override
            public IModel compile(ParameterizedItemModelLoader.ResourceInjector resourceInjector) {
                ResourceLocation injected = resourceInjector.injectResource(JsonUtils9.GSON.toJson((JsonElement)this.src));
                try {
                    return ModelLoaderRegistry.getModel((ResourceLocation)injected);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }
}

