/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.dropt.modules.dropt.rule.parse;

import com.codetaylor.mc.athenaeum.parser.recipe.item.MalformedRecipeItemException;
import com.codetaylor.mc.athenaeum.parser.recipe.item.ParseResult;
import com.codetaylor.mc.athenaeum.parser.recipe.item.RecipeItemParser;
import com.codetaylor.mc.dropt.modules.dropt.rule.data.Rule;
import com.codetaylor.mc.dropt.modules.dropt.rule.data.RuleList;
import com.codetaylor.mc.dropt.modules.dropt.rule.log.DebugFileWrapper;
import com.codetaylor.mc.dropt.modules.dropt.rule.log.ILogger;
import com.codetaylor.mc.dropt.modules.dropt.rule.parse.IRuleListParser;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class ParserRuleMatchBiome
implements IRuleListParser {
    @Override
    public void parse(RecipeItemParser parser, RuleList ruleList, Rule rule, ILogger logger, DebugFileWrapper debugFileWrapper) {
        if (rule.match == null) {
            if (rule.debug) {
                debugFileWrapper.debug("[PARSE] Match object not defined, skipped parsing biome match");
            }
            return;
        }
        if (rule.match.biomes == null) {
            if (rule.debug) {
                debugFileWrapper.debug("[PARSE] Match object not defined, skipped parsing biome match");
            }
            return;
        }
        for (String id : rule.match.biomes.ids) {
            Biome biome;
            ParseResult parse;
            try {
                parse = parser.parse(id);
            }
            catch (MalformedRecipeItemException e) {
                logger.error("[PARSE] Unable to parse biome [" + id + "] in file: " + ruleList._filename, e);
                continue;
            }
            if (rule.debug) {
                debugFileWrapper.debug("[PARSE] Parsed biome match: " + parse);
            }
            if ((biome = (Biome)ForgeRegistries.BIOMES.getValue(new ResourceLocation(parse.getDomain(), parse.getPath()))) == null) {
                logger.error("[PARSE] Unable to find registered biome: " + parse.toString());
                continue;
            }
            if (rule.debug) {
                debugFileWrapper.debug("[PARSE] Found registered biome: " + biome);
            }
            rule.match.biomes._biomes.add(biome);
            if (!rule.debug) continue;
            debugFileWrapper.debug("[PARSE] Added biome match: " + biome);
        }
    }
}

