/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.dropt.modules.dropt.rule.parse;

import com.codetaylor.mc.athenaeum.parser.recipe.item.RecipeItemParser;
import com.codetaylor.mc.dropt.modules.dropt.rule.data.Rule;
import com.codetaylor.mc.dropt.modules.dropt.rule.data.RuleDrop;
import com.codetaylor.mc.dropt.modules.dropt.rule.data.RuleList;
import com.codetaylor.mc.dropt.modules.dropt.rule.log.DebugFileWrapper;
import com.codetaylor.mc.dropt.modules.dropt.rule.log.ILogger;
import com.codetaylor.mc.dropt.modules.dropt.rule.parse.IRuleListParser;
import com.google.common.base.Optional;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class ParserRuleDropReplaceBlock
implements IRuleListParser {
    @Override
    public void parse(RecipeItemParser parser, RuleList ruleList, Rule rule, ILogger logger, DebugFileWrapper debugFileWrapper) {
        int dropIndex = 0;
        for (RuleDrop drop : rule.drops) {
            ResourceLocation resourceLocation;
            Block block;
            if (drop == null) {
                logger.warn(String.format("[PARSE] Malformed JSON caused null RuleDrop, skipping null RuleDrop at index %d in file %s", dropIndex, ruleList._filename));
                ++dropIndex;
                continue;
            }
            if (drop.replaceBlock == null) {
                if (rule.debug) {
                    debugFileWrapper.debug(String.format("[PARSE] Drop replaceBlock object not defined in IRuleDrop at index %d, skipped parsing drop item", dropIndex));
                }
                ++dropIndex;
                continue;
            }
            if (drop.replaceBlock.block == null) {
                if (rule.debug) {
                    debugFileWrapper.debug(String.format("[PARSE] Drop replaceBlock.block object not defined or empty in IRuleDrop at index %d, skipped parsing drop item", dropIndex));
                }
                ++dropIndex;
                continue;
            }
            if (rule.debug) {
                debugFileWrapper.debug("[PARSE] Parsing drop replaceBlock for IRuleDrop at index " + dropIndex);
            }
            if ((block = (Block)ForgeRegistries.BLOCKS.getValue(resourceLocation = new ResourceLocation(drop.replaceBlock.block))) == null) {
                logger.error("[PARSE] Unable to parse replaceBlock.block [" + drop.replaceBlock.block + "] in file: " + ruleList._filename);
                ++dropIndex;
                continue;
            }
            BlockStateContainer blockStateContainer = block.func_176194_O();
            drop.replaceBlock._blockState = block.func_176223_P();
            if (drop.replaceBlock.properties == null || drop.replaceBlock.properties.isEmpty()) {
                if (rule.debug) {
                    debugFileWrapper.debug(String.format("[PARSE] Drop replaceBlock.block object not defined or empty in IRuleDrop at index %d, skipped parsing drop item", dropIndex));
                }
                ++dropIndex;
                continue;
            }
            for (Map.Entry<String, String> entry : drop.replaceBlock.properties.entrySet()) {
                try {
                    IProperty property = blockStateContainer.func_185920_a(entry.getKey());
                    if (property == null) {
                        if (rule.debug) {
                            debugFileWrapper.debug(String.format("[PARSE] Unable to parse block property [%s] at index %d", entry.getKey(), dropIndex));
                        }
                        ++dropIndex;
                        continue;
                    }
                    drop.replaceBlock._blockState = this.setValue(drop.replaceBlock._blockState, property, entry.getValue(), logger, dropIndex, ruleList._filename);
                }
                catch (Throwable t) {
                    logger.error(String.format("[PARSE] Error parsing block property [%s] for IRuleDrop at index %d in file %s", entry.getKey(), dropIndex, ruleList._filename), t);
                }
            }
            ++dropIndex;
        }
    }

    private <T extends Comparable<T>> IBlockState setValue(IBlockState blockState, IProperty<T> property, String value, ILogger logger, int dropIndex, String filename) {
        Optional optional = property.func_185929_b(value);
        if (optional.isPresent()) {
            return blockState.func_177226_a(property, (Comparable)optional.get());
        }
        logger.warn(String.format("[PARSE] Unable to read property %s with value %s for blockState %s for IRuleDrop at index %d in file %s", property, value, blockState.toString(), dropIndex, filename));
        return blockState;
    }
}

