/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.dropt.modules.dropt.rule.match;

import com.codetaylor.mc.dropt.api.reference.EnumListType;
import com.codetaylor.mc.dropt.modules.dropt.rule.data.RuleMatchHarvesterHeldItem;
import com.codetaylor.mc.dropt.modules.dropt.rule.log.DebugFileWrapper;
import java.util.Set;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class HeldItemMatcher {
    public boolean matches(RuleMatchHarvesterHeldItem ruleMatchHarvesterHeldItem, ItemStack heldItemStack, IBlockState blockState, EntityPlayer harvester, DebugFileWrapper logFile, boolean debug) {
        Item item = heldItemStack.func_77973_b();
        String toolClass = ruleMatchHarvesterHeldItem._toolClass;
        if (toolClass != null) {
            int harvestLevel = item.getHarvestLevel(heldItemStack, toolClass, harvester, blockState);
            Set toolClasses = item.getToolClasses(heldItemStack);
            if (ruleMatchHarvesterHeldItem.type == EnumListType.WHITELIST) {
                if (!toolClasses.contains(toolClass)) {
                    if (debug) {
                        logFile.debug("[MATCH] [!!] Held item doesn't have required tool class: " + toolClass);
                    }
                    return false;
                }
                if (debug) {
                    logFile.debug("[MATCH] [OK] Held item has required tool class: " + toolClass);
                }
                if (harvestLevel < ruleMatchHarvesterHeldItem._minHarvestLevel || harvestLevel > ruleMatchHarvesterHeldItem._maxHarvestLevel) {
                    if (debug) {
                        logFile.debug("[MATCH] [!!] Harvest tool outside of level range");
                    }
                    return false;
                }
                if (debug) {
                    logFile.debug("[MATCH] [OK] Harvest tool inside of level range");
                }
            } else {
                boolean harvestLevelInRange = harvestLevel >= ruleMatchHarvesterHeldItem._minHarvestLevel && harvestLevel <= ruleMatchHarvesterHeldItem._maxHarvestLevel;
                boolean toolClassMatches = toolClasses.contains(toolClass);
                if (toolClassMatches && harvestLevelInRange) {
                    if (debug) {
                        logFile.debug("[MATCH] [!!] Held item is excluded: " + toolClass + ";" + harvestLevel);
                    }
                    return false;
                }
                if (debug) {
                    logFile.debug("[MATCH] [OK] Held item isn't excluded: " + toolClass + ";" + harvestLevel);
                }
            }
        }
        return this.checkItemList(ruleMatchHarvesterHeldItem, heldItemStack, logFile, debug);
    }

    private boolean checkItemList(RuleMatchHarvesterHeldItem ruleMatchHarvesterHeldItem, ItemStack heldItemStack, DebugFileWrapper logFile, boolean debug) {
        if (ruleMatchHarvesterHeldItem._items.isEmpty()) {
            if (debug) {
                logFile.debug("[MATCH] [OK] No item entries to match");
            }
            return true;
        }
        if (ruleMatchHarvesterHeldItem.type == EnumListType.WHITELIST) {
            return this.checkAsWhitelist(ruleMatchHarvesterHeldItem, heldItemStack, logFile, debug);
        }
        return this.checkAsBlacklist(ruleMatchHarvesterHeldItem, heldItemStack, logFile, debug);
    }

    private boolean checkAsWhitelist(RuleMatchHarvesterHeldItem ruleMatchHarvesterHeldItem, ItemStack heldItemStack, DebugFileWrapper logFile, boolean debug) {
        Item heldItem = heldItemStack.func_77973_b();
        int metadata = heldItemStack.func_77960_j();
        for (ItemStack itemStack : ruleMatchHarvesterHeldItem._items) {
            if (itemStack.func_77973_b() != heldItem) {
                if (!debug) continue;
                logFile.debug(String.format("[MATCH] [!!] Held item mismatch: (match) %s != %s (candidate)", itemStack.func_77973_b(), heldItem));
                continue;
            }
            if (debug) {
                logFile.debug(String.format("[MATCH] [OK] Held item match: (match) %s == %s (candidate)", itemStack.func_77973_b(), heldItem));
            }
            if (itemStack.func_77960_j() == Short.MAX_VALUE || itemStack.func_77960_j() == metadata) {
                if (debug) {
                    logFile.debug(String.format("[MATCH] [OK] Held item meta match: (match) %d == %d (candidate)", itemStack.func_77960_j(), metadata));
                    logFile.debug("[MATCH] [OK] Found held item match in whitelist");
                }
            } else if (debug) {
                logFile.debug(String.format("[MATCH] [!!] Held item meta mismatch: (match) %d != %d (candidate)", itemStack.func_77960_j(), metadata));
                continue;
            }
            if (itemStack.func_77978_p() != null) {
                if (heldItemStack.func_77978_p() == null) {
                    if (!debug) continue;
                    logFile.debug(String.format("[MATCH] [!!] Held item tag mismatch: (match) %s != %s (candidate)", itemStack.func_77978_p(), null));
                    continue;
                }
                boolean result = itemStack.func_77978_p().equals((Object)heldItemStack.func_77978_p());
                if (debug) {
                    if (result) {
                        logFile.debug("[MATCH] [OK] Item NBT matches: " + itemStack.func_77978_p());
                    } else {
                        logFile.debug(String.format("[MATCH] [!!] Held item tag mismatch: (match) %s != %s (candidate)", itemStack.func_77978_p(), heldItemStack.func_77978_p()));
                    }
                }
                return result;
            }
            if (debug) {
                logFile.debug("[MATCH] [OK] Match has no tag");
            }
            return true;
        }
        if (debug) {
            logFile.debug("[MATCH] [!!] Unable to find heldItemMainHand match in whitelist");
        }
        return false;
    }

    private boolean checkAsBlacklist(RuleMatchHarvesterHeldItem ruleMatchHarvesterHeldItem, ItemStack heldItemStack, DebugFileWrapper logFile, boolean debug) {
        Item heldItem = heldItemStack.func_77973_b();
        int metadata = heldItemStack.func_77960_j();
        for (ItemStack itemStack : ruleMatchHarvesterHeldItem._items) {
            if (itemStack.func_77973_b() != heldItem) {
                if (!debug) continue;
                logFile.debug(String.format("[MATCH] [OK] Held item item mismatch: (match) %s != %s (candidate)", itemStack.func_77973_b(), heldItem));
                continue;
            }
            if (debug) {
                logFile.debug(String.format("[MATCH] [!!] Held item item match: (match) %s == %s (candidate)", itemStack.func_77973_b(), heldItem));
            }
            if (itemStack.func_77960_j() != Short.MAX_VALUE && itemStack.func_77960_j() != metadata) {
                if (!debug) continue;
                logFile.debug(String.format("[MATCH] [OK] Held item meta mismatch: (match) %d != %d (candidate)", itemStack.func_77960_j(), metadata));
                continue;
            }
            if (debug) {
                logFile.debug(String.format("[MATCH] [!!] Held item meta match: (match) %d == %d (candidate)", itemStack.func_77960_j(), metadata));
                logFile.debug("[MATCH] [!!] Found heldItemMainHand match in blacklist");
            }
            if (itemStack.func_77978_p() != null) {
                if (heldItemStack.func_77978_p() == null) {
                    if (!debug) continue;
                    logFile.debug(String.format("[MATCH] [OK] Held item tag mismatch: (match) %s != %s (candidate)", itemStack.func_77978_p(), null));
                    continue;
                }
                boolean areTagsEqual = itemStack.func_77978_p().equals((Object)heldItemStack.func_77978_p());
                if (debug) {
                    if (areTagsEqual) {
                        logFile.debug("[MATCH] [!!] Item NBT matches: " + itemStack.func_77978_p());
                    } else {
                        logFile.debug(String.format("[MATCH] [OK] Held item tag mismatch: (match) %s != %s (candidate)", itemStack.func_77978_p(), heldItemStack.func_77978_p()));
                    }
                }
                if (areTagsEqual) {
                    return false;
                }
            } else if (debug) {
                logFile.debug("[MATCH] [OK] Match has no tag");
            }
            return false;
        }
        if (debug) {
            logFile.debug("[MATCH] [OK] Unable to find heldItemMainHand match in blacklist");
        }
        return true;
    }
}

