/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.dropt.modules.dropt.rule.match;

import com.codetaylor.mc.dropt.modules.dropt.rule.log.DebugFileWrapper;
import java.util.Arrays;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.ResourceLocation;

public class BlockMatchEntry {
    private final String domain;
    private final String path;
    private final int meta;
    private final int[] metas;

    public BlockMatchEntry(String domain, String path, int meta, int[] metas) {
        this.domain = domain;
        this.path = path;
        this.meta = meta;
        this.metas = metas;
    }

    public boolean matches(IBlockState blockState, DebugFileWrapper logFile, boolean debug, String logPrefix) {
        ResourceLocation registryName;
        if (debug) {
            logFile.debug(String.format("%s[--] Attempting to match candidate [%s] with: [%s]", logPrefix, blockState, this));
        }
        if ((registryName = blockState.func_177230_c().getRegistryName()) == null) {
            if (debug) {
                logFile.debug(logPrefix + "[!!] No registry name for match candidate: " + blockState);
            }
            return false;
        }
        if (!registryName.func_110624_b().equals(this.domain)) {
            if (debug) {
                logFile.debug(String.format("%s[!!] Domain mismatch: (match) %s != %s (candidate)", logPrefix, this.domain, registryName.func_110624_b()));
            }
            return false;
        }
        if (debug) {
            logFile.debug(String.format("%s[OK] Domain match: (match) %s == %s (candidate)", logPrefix, this.domain, registryName.func_110624_b()));
        }
        if (!registryName.func_110623_a().equals(this.path)) {
            if (debug) {
                logFile.debug(String.format("%s[!!] Path mismatch: (match) %s != %s (candidate)", logPrefix, this.path, registryName.func_110623_a()));
            }
            return false;
        }
        if (debug) {
            logFile.debug(String.format("%s[OK] Path match: (match) %s == %s (candidate)", logPrefix, this.path, registryName.func_110623_a()));
        }
        int metaFromState = blockState.func_177230_c().func_176201_c(blockState);
        if (this.meta == Short.MAX_VALUE || this.meta == metaFromState) {
            if (debug) {
                logFile.debug(String.format("%s[OK] Meta match: (match) %d == %d (candidate)", logPrefix, this.meta, metaFromState));
            }
            return true;
        }
        if (debug) {
            logFile.debug(String.format("%s[!!] Meta mismatch: (match) %d != %d (candidate)", logPrefix, this.meta, metaFromState));
        }
        for (int meta : this.metas) {
            if (meta == Short.MAX_VALUE || meta == metaFromState) {
                if (debug) {
                    logFile.debug(String.format("%s[OK] Meta match: (match) %d == %d (candidate)", logPrefix, meta, metaFromState));
                }
                return true;
            }
            if (!debug) continue;
            logFile.debug(String.format("%s[!!] Meta mismatch: (match) %d != %d (candidate)", logPrefix, meta, metaFromState));
        }
        return false;
    }

    public String toString() {
        return "BlockMatcher{domain='" + this.domain + '\'' + ", path='" + this.path + '\'' + ", meta=" + this.meta + ", metas=" + Arrays.toString(this.metas) + '}';
    }
}

