/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.integration.crafttweaker;

import com.jaquadro.minecraft.storagedrawers.StorageDrawers;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenRegister
@ZenClass(value="mods.storagedrawers.Compaction")
public class Compaction {
    @ZenMethod
    public static void add(IItemStack upper, IItemStack lower, int conversion) {
        if (upper == null || lower == null) {
            CraftTweakerAPI.logError((String)"Tried to add compacting tier with invalid item stack.");
            return;
        }
        ItemStack upperStack = (ItemStack)upper.getInternal();
        ItemStack lowerStack = (ItemStack)lower.getInternal();
        if (upperStack == null || lowerStack == null) {
            CraftTweakerAPI.logError((String)"Tried to add compacting tier with invalid item stack.");
        } else {
            CraftTweakerAPI.apply((IAction)new AddRecordAction(upperStack, lowerStack, conversion));
        }
    }

    @ZenMethod
    public static void remove(@Optional IItemStack upper, @Optional IItemStack lower) {
        if (upper == null && lower == null) {
            CraftTweakerAPI.logError((String)"Tried to remove compacting tier(s) with invalid item stacks.");
            return;
        }
        ItemStack upperStack = CraftTweakerMC.getItemStack((IItemStack)upper);
        ItemStack lowerStack = CraftTweakerMC.getItemStack((IItemStack)lower);
        if (upperStack == null && lowerStack == null) {
            CraftTweakerAPI.logError((String)"Tried to remove compacting tier(s) with invalid item stacks.");
        } else {
            CraftTweakerAPI.apply((IAction)new RemoveRecordAction(upperStack, lowerStack));
        }
    }

    private static class AddRecordAction
    implements IAction {
        ItemStack upper;
        ItemStack lower;
        int conversionRate;

        public AddRecordAction(ItemStack upper, ItemStack lower, int conversionRate) {
            this.upper = upper;
            this.lower = lower;
            this.conversionRate = conversionRate;
        }

        public void apply() {
            boolean added = StorageDrawers.compRegistry.register(this.upper, this.lower, this.conversionRate);
            if (!added) {
                CraftTweakerAPI.logError((String)("Failed to add compacting recipe with upper item '" + this.upper.func_82833_r() + "'."));
            }
        }

        public String describe() {
            return "Adding compacting tier: 1 '" + this.upper.func_82833_r() + "' = " + this.conversionRate + " '" + this.lower.func_82833_r() + "'.";
        }
    }

    private static class RemoveRecordAction
    implements IAction {
        ItemStack upper;
        ItemStack lower;

        public RemoveRecordAction(ItemStack upper, ItemStack lower) {
            this.upper = upper;
            this.lower = lower;
        }

        public void apply() {
            if (this.upper != ItemStack.field_190927_a) {
                StorageDrawers.compRegistry.unregisterUpperTarget(this.upper);
            }
            if (this.lower != ItemStack.field_190927_a) {
                StorageDrawers.compRegistry.unregisterLowerTarget(this.lower);
            }
        }

        public String describe() {
            return "Removing existing compacting tier(s) with upper item '" + (this.upper != ItemStack.field_190927_a ? this.upper.func_82833_r() : "null") + "' and/or lower item '" + (this.lower != ItemStack.field_190927_a ? this.lower.func_82833_r() : "null") + "'.";
        }
    }
}

