/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.block.dynamic;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.jaquadro.minecraft.chameleon.geometry.Area2D;
import com.jaquadro.minecraft.storagedrawers.item.EnumUpgradeStatus;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IResource;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.io.IOUtils;

public class StatusModelData {
    private double frontDepth;
    private Slot[] slots;

    public StatusModelData(int slotCount, ResourceLocation location) {
        this.slots = new Slot[slotCount];
        this.load(location);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load(ResourceLocation location) {
        try {
            BufferedReader reader;
            block6: {
                IResource configResource = Minecraft.func_71410_x().func_110442_L().func_110536_a(location);
                reader = null;
                try {
                    JsonArray slotsArray;
                    reader = new BufferedReader(new InputStreamReader(configResource.func_110527_b()));
                    JsonObject root = new JsonParser().parse((Reader)reader).getAsJsonObject();
                    if (root.has("frontDepth")) {
                        this.frontDepth = root.get("frontDepth").getAsDouble();
                    }
                    if (!root.has("slots") || (slotsArray = root.getAsJsonArray("slots")) == null || slotsArray.size() != this.slots.length) break block6;
                    for (int i = 0; i < this.slots.length; ++i) {
                        this.slots[i] = new Slot(slotsArray.get(i).getAsJsonObject());
                    }
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(reader);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((Reader)reader);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public double getFrontDepth() {
        return this.frontDepth;
    }

    public Slot getSlot(int i) {
        return this.slots[i];
    }

    public static class Slot {
        private ResourceLocation level1On;
        private ResourceLocation level1Off;
        private ResourceLocation level2On;
        private ResourceLocation level2Off;
        private Area2D statusArea;
        private Area2D statusActiveArea;
        private Area2D labelArea;
        private Area2D slotArea;
        private Area2D iconArea;
        private int activeStepsX;
        private int activeStepsY;

        public Slot(JsonObject json) {
            JsonArray arr;
            if (json == null) {
                return;
            }
            this.statusArea = this.readArea(json, "statusAreaFrom", "statusAreaTo");
            this.statusActiveArea = this.readArea(json, "statusActiveFrom", "statusActiveTo");
            this.labelArea = this.readArea(json, "labelAreaFrom", "labelAreaTo");
            if (this.labelArea.equals((Object)Area2D.EMPTY)) {
                this.labelArea = this.statusActiveArea;
            }
            this.slotArea = this.readArea(json, "slotAreaFrom", "slotAreaTo");
            if (this.slotArea.equals((Object)Area2D.EMPTY)) {
                this.slotArea = this.statusArea;
            }
            this.iconArea = this.readIconArea(json, "iconSize", this.slotArea);
            if (json.has("statusActiveSteps") && (arr = json.getAsJsonArray("statusActiveSteps")) != null && arr.size() == 2) {
                this.activeStepsX = arr.get(0).getAsInt();
                this.activeStepsY = arr.get(1).getAsInt();
            }
            if (json.has("textures")) {
                JsonObject textures = json.getAsJsonObject("textures");
                if (textures.has("level1Off")) {
                    this.level1Off = new ResourceLocation(textures.get("level1Off").getAsString());
                }
                if (textures.has("level1On")) {
                    this.level1On = new ResourceLocation(textures.get("level1On").getAsString());
                }
                if (textures.has("level2Off")) {
                    this.level2Off = new ResourceLocation(textures.get("level2Off").getAsString());
                }
                if (textures.has("level2On")) {
                    this.level2On = new ResourceLocation(textures.get("level2On").getAsString());
                }
            }
        }

        public Area2D getStatusArea() {
            return this.statusArea;
        }

        public Area2D getStatusActiveArea() {
            return this.statusActiveArea;
        }

        public Area2D getLabelArea() {
            return this.labelArea;
        }

        public Area2D getSlotArea() {
            return this.slotArea;
        }

        public Area2D getIconArea() {
            return this.iconArea;
        }

        public int getActiveStepsX() {
            return this.activeStepsX;
        }

        public int getActiveStepsY() {
            return this.activeStepsY;
        }

        public ResourceLocation getOnResource(EnumUpgradeStatus status) {
            ResourceLocation resourceLocation;
            switch (status.getLevel()) {
                case 1: {
                    resourceLocation = this.level1On;
                    break;
                }
                case 2: {
                    resourceLocation = this.level2On;
                    break;
                }
                default: {
                    resourceLocation = null;
                }
            }
            return resourceLocation;
        }

        public ResourceLocation getOffResource(EnumUpgradeStatus status) {
            ResourceLocation resourceLocation;
            switch (status.getLevel()) {
                case 1: {
                    resourceLocation = this.level1Off;
                    break;
                }
                case 2: {
                    resourceLocation = this.level2Off;
                    break;
                }
                default: {
                    resourceLocation = null;
                }
            }
            return resourceLocation;
        }

        private Area2D readArea(JsonObject object, String keyStart, String keyStop) {
            if (object == null) {
                return Area2D.EMPTY;
            }
            double[] start = this.readDoublePair(object, keyStart);
            double[] stop = this.readDoublePair(object, keyStop);
            return Area2D.From((double)start[0], (double)start[1], (double)stop[0], (double)stop[1]);
        }

        private Area2D readIconArea(JsonObject object, String key, Area2D bound) {
            if (object == null) {
                return Area2D.EMPTY;
            }
            double[] size = this.readDoublePair(object, key);
            double startX = bound.getX() + bound.getWidth() / 2.0 - size[0] / 2.0;
            double startY = bound.getY() + bound.getHeight() / 2.0 - size[1] / 2.0;
            return Area2D.From((double)startX, (double)startY, (double)(startX + size[0]), (double)(startY + size[1]));
        }

        private double[] readDoublePair(JsonObject object, String key) {
            JsonArray arr;
            double[] size = new double[]{0.0, 0.0};
            if (object.has(key) && (arr = object.getAsJsonArray(key)) != null && arr.size() == 2) {
                size[0] = arr.get(0).getAsDouble();
                size[1] = arr.get(1).getAsDouble();
            }
            return size;
        }
    }
}

