/*
 * Decompiled with CFR 0.152.
 */
package topextras.providers;

import javax.annotation.Nonnull;
import mcjty.theoneprobe.api.ElementAlignment;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoProvider;
import mcjty.theoneprobe.api.ProbeMode;
import mcjty.theoneprobe.api.TextStyleClass;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityEnchantmentTable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import topextras.Utilities;

public class EnchantingPowerInfoProvider
implements IProbeInfoProvider {
    private static final ItemStack ENCHANTED_BOOK = new ItemStack(Items.field_151134_bR);

    public String getID() {
        return Utilities.getProviderId("enchanting_power");
    }

    public void addProbeInfo(ProbeMode mode, @Nonnull IProbeInfo probeInfo, EntityPlayer player, @Nonnull World world, @Nonnull IBlockState blockState, @Nonnull IProbeHitData data) {
        float enchantingPower = ForgeHooks.getEnchantPower((World)world, (BlockPos)data.getPos());
        if (blockState.func_177230_c().hasTileEntity(blockState) && world.func_175625_s(data.getPos()) instanceof TileEntityEnchantmentTable) {
            BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(data.getPos());
            enchantingPower = 0.0f;
            for (int x = -1; x <= 1; ++x) {
                for (int z = -1; z <= 1; ++z) {
                    if (x == 0 && z == 0 || !world.func_175623_d(pos.func_177982_a(z, 0, x)) || !world.func_175623_d(pos.func_177982_a(z, 1, x))) continue;
                    enchantingPower += ForgeHooks.getEnchantPower((World)world, (BlockPos)pos.func_177982_a(z * 2, 0, x * 2));
                    enchantingPower += ForgeHooks.getEnchantPower((World)world, (BlockPos)pos.func_177982_a(z * 2, 1, x * 2));
                    if (z == 0 || x == 0) continue;
                    enchantingPower += ForgeHooks.getEnchantPower((World)world, (BlockPos)pos.func_177982_a(z * 2, 0, x));
                    enchantingPower += ForgeHooks.getEnchantPower((World)world, (BlockPos)pos.func_177982_a(z * 2, 1, x));
                    enchantingPower += ForgeHooks.getEnchantPower((World)world, (BlockPos)pos.func_177982_a(z, 0, x * 2));
                    enchantingPower += ForgeHooks.getEnchantPower((World)world, (BlockPos)pos.func_177982_a(z, 1, x * 2));
                }
            }
        }
        if (enchantingPower > 0.0f) {
            probeInfo.horizontal(probeInfo.defaultLayoutStyle().alignment(ElementAlignment.ALIGN_CENTER)).item(ENCHANTED_BOOK).text(TextStyleClass.LABEL + "{*topextras.top.enchanting_power*} " + TextFormatting.LIGHT_PURPLE + Utilities.FORMAT.format(enchantingPower));
        }
    }
}

