/*
 * Decompiled with CFR 0.152.
 */
package topextras.providers;

import java.util.Collections;
import javax.annotation.Nonnull;
import mcjty.theoneprobe.api.ElementAlignment;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoProvider;
import mcjty.theoneprobe.api.ProbeMode;
import mcjty.theoneprobe.api.TextStyleClass;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCocoa;
import net.minecraft.block.BlockStem;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import topextras.Utilities;

public class CropInfoProvider
implements IProbeInfoProvider {
    private static final ItemStack PUMPKIN = new ItemStack(Blocks.field_150423_aK);
    private static final ItemStack MELON = new ItemStack(Blocks.field_150440_ba);
    private static final ItemStack COCOA = new ItemStack(Items.field_151100_aR, 1, 3);

    public String getID() {
        return Utilities.getProviderId("crop");
    }

    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, @Nonnull IBlockState blockState, IProbeHitData data) {
        Block block = blockState.func_177230_c();
        if (block instanceof BlockStem || block instanceof BlockCocoa) {
            for (IProperty property : blockState.func_177228_b().keySet()) {
                if (!"age".equals(property.func_177701_a())) continue;
                if (property.func_177699_b() == Integer.class) {
                    IProperty integerProperty = property;
                    int age = (Integer)blockState.func_177229_b(integerProperty);
                    int maxAge = (Integer)Collections.max(integerProperty.func_177700_c());
                    IProbeInfo horizontalPane = probeInfo.horizontal(probeInfo.defaultLayoutStyle().alignment(ElementAlignment.ALIGN_CENTER));
                    if (block == Blocks.field_150393_bb) {
                        horizontalPane.item(PUMPKIN);
                    } else if (block == Blocks.field_150394_bc) {
                        horizontalPane.item(MELON);
                    } else if (block == Blocks.field_150375_by) {
                        horizontalPane.item(COCOA);
                    }
                    if (age == maxAge) {
                        horizontalPane.text(TextStyleClass.OK + "{*topextras.top.growth_finished*}");
                    } else {
                        horizontalPane.text(TextStyleClass.LABEL + "{*topextras.top.growth*} " + TextStyleClass.WARNING + age * 100 / maxAge + "%");
                    }
                    return;
                }
                return;
            }
        }
    }
}

