/*
 * Decompiled with CFR 0.152.
 */
package topextras.providers;

import java.util.Collections;
import javax.annotation.Nonnull;
import mcjty.theoneprobe.api.ElementAlignment;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoProvider;
import mcjty.theoneprobe.api.ProbeMode;
import mcjty.theoneprobe.api.TextStyleClass;
import net.minecraft.block.BlockCauldron;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.PotionTypes;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.world.World;
import topextras.Utilities;

public class CauldronInfoProvider
implements IProbeInfoProvider {
    private static final ItemStack WATER_BUCKET = new ItemStack(Items.field_151131_as);
    private static final ItemStack WATTER_BOTTLE = PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_151068_bn), (PotionType)PotionTypes.field_185230_b);
    private static final ItemStack BUCKET = new ItemStack(Items.field_151133_ar);

    public String getID() {
        return Utilities.getProviderId("cauldron");
    }

    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, @Nonnull IBlockState blockState, IProbeHitData data) {
        if (blockState.func_177230_c() instanceof BlockCauldron) {
            for (IProperty property : blockState.func_177228_b().keySet()) {
                if (!"level".equals(property.func_177701_a()) || property.func_177699_b() != Integer.class) continue;
                IProperty integerProperty = property;
                int fill = (Integer)blockState.func_177229_b(integerProperty);
                int maxFill = (Integer)Collections.max(integerProperty.func_177700_c());
                IProbeInfo horizontalPane = probeInfo.horizontal(probeInfo.defaultLayoutStyle().alignment(ElementAlignment.ALIGN_CENTER));
                if (fill > 0) {
                    horizontalPane.item(fill == maxFill ? WATER_BUCKET : WATTER_BOTTLE);
                    horizontalPane.text(TextStyleClass.LABEL + "" + fill + (fill == 1 ? " {*topextras.top.cauldron_fill_1*}" : " {*topextras.top.cauldron_fill_2*}"));
                } else {
                    horizontalPane.item(BUCKET);
                    horizontalPane.text(TextStyleClass.LABEL + "{*topextras.top.empty*} ");
                }
                return;
            }
        }
    }
}

