/*
 * Decompiled with CFR 0.152.
 */
package com.personthecat.cavegenerator.world.generator;

import com.personthecat.cavegenerator.data.RoomSettings;
import com.personthecat.cavegenerator.data.TunnelSettings;
import com.personthecat.cavegenerator.model.PrimerData;
import com.personthecat.cavegenerator.util.XoRoShiRo;
import com.personthecat.cavegenerator.world.generator.MapGenerator;
import com.personthecat.cavegenerator.world.generator.SphereData;
import com.personthecat.cavegenerator.world.generator.TunnelPathInfo;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.chunk.ChunkPrimer;

public class TunnelGenerator
extends MapGenerator {
    private static final float PI_OVER_2 = 1.5707964f;
    protected final TunnelSettings cfg;
    @Nullable
    private final RoomSettings rooms;
    @Nullable
    private final TunnelGenerator branches;

    public TunnelGenerator(TunnelSettings cfg, World world) {
        super(cfg.conditions, cfg.decorators, world, cfg.checkWater);
        this.cfg = cfg;
        this.rooms = cfg.rooms.orElse(null);
        this.branches = cfg.branches.map(b -> new TunnelGenerator((TunnelSettings)b, world)).orElse(null);
    }

    @Override
    protected void mapGenerate(MapGenerator.MapGenerationContext ctx) {
        this.createSystem(ctx.world, ctx.rand.nextLong(), ctx.destChunkX, ctx.destChunkZ, ctx.chunkX, ctx.chunkZ, ctx.primer);
    }

    @Override
    protected void fillSphere(SphereData sphere, double cX, double cY, double cZ, int absX, int absZ, double radXZ, double radY, int miX, int maX, int miY, int maY, int miZ, int maZ) {
        for (int x = miX; x < maX; ++x) {
            double distX = ((double)(x + absX) + 0.5 - cX) / radXZ;
            double distX2 = distX * distX;
            for (int z = miZ; z < maZ; ++z) {
                double distZ = ((double)(z + absZ) + 0.5 - cZ) / radXZ;
                double distZ2 = distZ * distZ;
                if (distX2 + distZ2 >= 1.0) continue;
                for (int y = maY; y > miY; --y) {
                    double distY = ((double)(y - 1) + 0.5 - cY) / radY;
                    double distY2 = distY * distY;
                    if (!(distY > -0.7) || !(distX2 + distY2 + distZ2 < 1.0)) continue;
                    sphere.inner.add(x, y, z);
                }
            }
        }
    }

    @Override
    protected void fillDouble(SphereData sphere, double cX, double cY, double cZ, int absX, int absZ, double rXZ, double rY, double roXZ, double roY, int miX, int maX, int miY, int maY, int miZ, int maZ) {
        double rXZ2 = rXZ * rXZ;
        double rY2 = rY * rY;
        double roXZ2 = roXZ * roXZ;
        double roY2 = roY * roY;
        for (int x = miX; x < maX; ++x) {
            double distX = (double)(x + absX) + 0.5 - cX;
            double distX2 = distX * distX;
            for (int z = miZ; z < maZ; ++z) {
                double distZ = (double)(z + absZ) + 0.5 - cZ;
                double distZ2 = distZ * distZ;
                double sumRoXZ = distX2 / roXZ2 + distZ2 / roXZ2;
                if (sumRoXZ >= 1.0) continue;
                double sumRXZ = distX2 / rXZ2 + distZ2 / rXZ2;
                for (int y = maY; y > miY; --y) {
                    double distY = (double)(y - 1) + 0.5 - cY;
                    double distY2 = distY * distY;
                    if (distY / rY > -0.7 && sumRXZ + distY2 / rY2 < 1.0) {
                        sphere.inner.add(x, y, z);
                        continue;
                    }
                    if (!(sumRoXZ + distY2 / roY2 < 1.0)) continue;
                    sphere.shell.add(x, y, z);
                }
            }
        }
    }

    protected void createSystem(World world, long seed, int destX, int destZ, int x, int z, ChunkPrimer primer) {
        XoRoShiRo rand = new XoRoShiRo(seed);
        int frequency = this.getTunnelCount(rand);
        for (int i = 0; i < frequency; ++i) {
            int distance = this.cfg.distance;
            PrimerData data = new PrimerData(primer, x, z);
            for (int j = 0; j < this.getBranchCount(rand); ++j) {
                TunnelPathInfo path = new TunnelPathInfo(this.cfg, (Random)rand, destX, destZ);
                if (!this.conditions.getColumn((int)path.getX(), (int)path.getZ()).contains((int)path.getY()) || !this.conditions.noise.GetBoolean(path.getX(), path.getY(), path.getZ())) continue;
                if (this.rooms != null && ((Random)rand).nextInt(this.rooms.chance) == 0) {
                    this.addRoom(world, rand, data, this.rooms.scale, this.rooms.stretch, path.getX(), path.getY(), path.getZ());
                    path.multiplyScale(((Random)rand).nextFloat() * ((Random)rand).nextFloat() * 3.0f + 1.0f);
                }
                long tunnelSeed = this.cfg.seed.orElseGet(rand::nextLong);
                this.addTunnel(world, tunnelSeed, data, path, 0, distance);
            }
        }
    }

    protected int getTunnelCount(Random rand) {
        int frequency = rand.nextInt(rand.nextInt(rand.nextInt(this.cfg.count) + 1) + 1);
        if (rand.nextInt(this.cfg.chance) != 0) {
            return 0;
        }
        return frequency;
    }

    protected int getBranchCount(Random rand) {
        if (rand.nextInt(this.cfg.systemChance) == 0) {
            return 1 + rand.nextInt(this.cfg.systemDensity);
        }
        return 1;
    }

    protected void addTunnel(World world, long seed, PrimerData data, TunnelPathInfo path, int position, int distance) {
        XoRoShiRo rand = new XoRoShiRo(seed);
        distance = this.getDistance(rand, distance);
        int randomBranchIndex = ((Random)rand).nextInt(distance / 2) + distance / 4;
        boolean randomNoiseCorrection = ((Random)rand).nextInt(6) == 0;
        for (int currentPos = position; currentPos < distance; ++currentPos) {
            double rXZ = 1.5 + (double)(MathHelper.func_76126_a((float)((float)currentPos * (float)Math.PI / (float)distance)) * path.getScale());
            double rY = rXZ * (double)path.getStretch();
            double d = this.decorators.shell.cfg.radius;
            double roXZ = rXZ + d;
            double roY = rY + d;
            path.update(rand, this.cfg.noiseYReduction, randomNoiseCorrection ? 0.92f : 0.7f, 0.1f);
            if (path.getScale() > 1.0f && distance > 0 && currentPos == randomBranchIndex && currentPos != position) {
                this.addBranches(world, rand, seed, data, path, currentPos, distance);
                return;
            }
            if (((Random)rand).nextInt(this.cfg.resolution) == 0) continue;
            if (path.travelledTooFar(data, currentPos, distance)) {
                return;
            }
            int decSeed = ((Random)rand).nextInt();
            if (!path.touchesChunk(data, roXZ * 2.0) || this.getNearestBorder((int)path.getX(), (int)path.getZ()) < roXZ + 9.0 || !this.conditions.height.contains((int)path.getY())) continue;
            this.generateSphere(data, world, new XoRoShiRo(decSeed), path.getX(), path.getY(), path.getZ(), rXZ, rY, roXZ, roY);
        }
    }

    private void addRoom(World world, Random main, PrimerData data, float scale, float stretch, double x, double y, double z) {
        long seed = main.nextLong();
        scale = main.nextFloat() * scale + 1.0f;
        XoRoShiRo local = new XoRoShiRo(seed);
        int distance = this.getDistance(local, 0);
        int position = distance / 2;
        double rXZ = 1.5 + (double)(MathHelper.func_76126_a((float)((float)position * (float)Math.PI / (float)distance)) * scale);
        double rY = rXZ * (double)stretch;
        double d = this.decorators.shell.cfg.radius;
        this.generateSphere(data, world, local, x, y, z, rXZ, rY, rXZ + d, rY + d);
    }

    private void addBranches(World world, Random rand, long seed, PrimerData data, TunnelPathInfo path, int currentPos, int distance) {
        TunnelPathInfo reset2;
        TunnelPathInfo reset1;
        if (!this.cfg.hasBranches) {
            return;
        }
        float yaw1 = path.getYaw() - 1.5707964f;
        float yaw2 = path.getYaw() + 1.5707964f;
        float pitch = path.getPitch() / 3.0f;
        if (this.cfg.resizeBranches) {
            reset1 = path.reset(yaw1, pitch, rand.nextFloat() * 0.5f + 0.5f, 1.0f);
            reset2 = path.reset(yaw2, pitch, rand.nextFloat() * 0.5f + 0.5f, 1.0f);
        } else {
            reset1 = path.reset(yaw1, pitch, path.getScale(), path.getStretch());
            reset2 = path.reset(yaw2, pitch, path.getScale(), path.getStretch());
        }
        if (this.branches != null) {
            long seedA = this.branches.cfg.seed.orElse(this.cfg.reseedBranches ? rand.nextLong() : seed);
            this.branches.addTunnel(world, seedA, data, reset1, currentPos, distance);
            long seedB = this.branches.cfg.seed.orElse(this.cfg.reseedBranches ? rand.nextLong() : seed);
            this.branches.addTunnel(world, seedB, data, reset2, currentPos, distance);
        } else {
            long seedA = this.cfg.seed.orElse(this.cfg.reseedBranches ? rand.nextLong() : seed);
            this.addTunnel(world, seedA, data, reset1, currentPos, distance);
            long seedB = this.cfg.seed.orElse(this.cfg.reseedBranches ? rand.nextLong() : seed);
            this.addTunnel(world, seedB, data, reset2, currentPos, distance);
        }
    }
}

