/*
 * Decompiled with CFR 0.152.
 */
package com.personthecat.cavegenerator.world.generator;

import com.personthecat.cavegenerator.data.ConditionSettings;
import com.personthecat.cavegenerator.model.Conditions;
import com.personthecat.cavegenerator.util.CommonMethods;
import com.personthecat.cavegenerator.world.generator.PrimerContext;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.Pair;

public abstract class ListGenerator<T> {
    protected final WeakReference<World> world;
    protected final List<Pair<T, Conditions>> features;

    public ListGenerator(List<T> features, Function<T, ConditionSettings> getter, World world) {
        Objects.requireNonNull(world, "Nullable world types are not yet supported.");
        this.world = new WeakReference<World>(world);
        this.features = CommonMethods.map(features, f -> Pair.of((Object)f, (Object)Conditions.compile((ConditionSettings)getter.apply(f), world)));
    }

    protected final World getWorld() {
        return (World)Objects.requireNonNull(this.world.get(), "World reference has been culled.");
    }

    public void generate(PrimerContext ctx) {
        this.generateChecked(ctx);
    }

    protected abstract void generateChecked(PrimerContext var1);

    protected void forEachFeature(BiConsumer<T, Conditions> fn) {
        for (Pair<T, Conditions> feature : this.features) {
            fn.accept(feature.getLeft(), (Conditions)feature.getRight());
        }
    }
}

