/*
 * Decompiled with CFR 0.152.
 */
package com.personthecat.cavegenerator.world.generator;

import com.personthecat.cavegenerator.data.LayerSettings;
import com.personthecat.cavegenerator.world.generator.BasicGenerator;
import com.personthecat.cavegenerator.world.generator.PrimerContext;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;

public class LayerGenerator
extends BasicGenerator {
    private final LayerSettings cfg;

    public LayerGenerator(LayerSettings cfg, World world) {
        super(cfg.conditions, world);
        this.cfg = cfg;
    }

    @Override
    public void generate(PrimerContext ctx) {
        int dim = ctx.world.field_73011_w.getDimension();
        if (this.conditions.dimensions.test(dim)) {
            this.generateChecked(ctx);
        }
    }

    @Override
    protected void generateChecked(PrimerContext ctx) {
        for (int x = 0; x < 16; ++x) {
            int actualX = x + ctx.chunkX * 16;
            for (int z = 0; z < 16; ++z) {
                int actualZ = z + ctx.chunkZ * 16;
                Biome b = ctx.world.func_180494_b(new BlockPos(actualX, 0, actualZ));
                if (!this.conditions.biomes.test(b) || !this.conditions.region.GetBoolean(actualX, actualZ)) continue;
                for (int y : this.conditions.getColumn(actualX, actualZ)) {
                    if (!this.cfg.matchers.contains(ctx.primer.func_177856_a(x, y, z)) || !this.conditions.noise.GetBoolean(x, z)) continue;
                    ctx.primer.func_177855_a(x, y, z, this.cfg.state);
                }
            }
        }
    }
}

