/*
 * Decompiled with CFR 0.152.
 */
package com.personthecat.cavegenerator.world.generator;

import com.personthecat.cavegenerator.data.ClusterSettings;
import com.personthecat.cavegenerator.model.Conditions;
import com.personthecat.cavegenerator.util.MultiValueIdentityMap;
import com.personthecat.cavegenerator.util.XoRoShiRo;
import com.personthecat.cavegenerator.world.RandomChunkSelector;
import com.personthecat.cavegenerator.world.generator.ListGenerator;
import com.personthecat.cavegenerator.world.generator.PrimerContext;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;
import org.apache.commons.lang3.tuple.Pair;

public class ClusterGenerator
extends ListGenerator<ClusterSettings> {
    private final MultiValueIdentityMap<Conditions, ClusterInfo> clusterMap = new MultiValueIdentityMap();
    private final RandomChunkSelector selector;

    public ClusterGenerator(List<ClusterSettings> cfg, World world) {
        super(cfg, c -> c.conditions, world);
        this.selector = new RandomChunkSelector(world.func_72905_C());
    }

    @Override
    public void generate(PrimerContext ctx) {
        if (!this.features.isEmpty()) {
            this.generateChecked(ctx);
        }
    }

    @Override
    protected void generateChecked(PrimerContext ctx) {
        ctx.world.field_73012_v.setSeed(ctx.world.func_72905_C());
        this.clusterMap.clear();
        this.locateFinalClusters(ctx.world, ctx.world.field_73012_v, ctx.chunkX, ctx.chunkZ);
        this.generateClusters(ctx.primer, ctx.localRand, ctx.chunkX, ctx.chunkZ);
    }

    private void locateFinalClusters(World world, Random rand, int chunkX, int chunkZ) {
        this.forEachFeature((cfg, conditions) -> {
            int cRadiusX = cfg.radiusX.max / 16 + 1;
            int cRadiusZ = cfg.radiusZ.max / 16 + 1;
            double threshold = cfg.selectionThreshold;
            int clusterSeed = rand.nextInt();
            for (int cX = chunkX - cRadiusX; cX <= chunkX + cRadiusX; ++cX) {
                for (int cZ = chunkZ - cRadiusZ; cZ <= chunkZ + cRadiusZ; ++cZ) {
                    int x = cX * 16 + 8;
                    int z = cZ * 16 + 8;
                    Biome b = world.func_72959_q().func_180631_a(new BlockPos(x, 0, z));
                    if (!conditions.biomes.test(b)) continue;
                    for (Pair<IBlockState, Integer> pair : cfg.states) {
                        IBlockState state = (IBlockState)pair.getLeft();
                        int id = (Integer)pair.getRight();
                        if (!this.selector.getBooleanForCoordinates(id, cX, cZ, threshold)) continue;
                        XoRoShiRo localRand = new XoRoShiRo(cX ^ cZ ^ clusterSeed);
                        int y = cfg.centerHeight.rand(localRand);
                        BlockPos origin = new BlockPos(x, y, z);
                        int radX = cfg.radiusX.rand(localRand) - cfg.radiusX.diff() / 2;
                        int radY = cfg.radiusY.rand(localRand) - cfg.radiusY.diff() / 2;
                        int radZ = cfg.radiusZ.rand(localRand) - cfg.radiusZ.diff() / 2;
                        this.clusterMap.add((Conditions)conditions, new ClusterInfo((ClusterSettings)cfg, state, id, origin, radX, radY, radZ));
                    }
                }
            }
        });
    }

    private void generateClusters(ChunkPrimer primer, Random rand, int chunkX, int chunkZ) {
        for (int x = 0; x < 16; ++x) {
            int actualX = x + chunkX * 16;
            for (int z = 0; z < 16; ++z) {
                int actualZ = z + chunkZ * 16;
                this.spawnColumn(primer, rand, x, z, actualX, actualZ);
            }
        }
    }

    private void spawnColumn(ChunkPrimer primer, Random rand, int x, int z, int actualX, int actualZ) {
        for (Map.Entry entry : this.clusterMap.entrySet()) {
            Conditions conditions = (Conditions)entry.getKey();
            for (int y : conditions.getColumn(actualX, actualZ)) {
                if (!conditions.noise.GetBoolean(actualX, y, actualZ)) continue;
                ClusterGenerator.spawnCluster((List)entry.getValue(), primer, rand, x, y, z, actualX, actualZ);
            }
        }
    }

    private static void spawnCluster(List<ClusterInfo> clusters, ChunkPrimer primer, Random rand, int x, int y, int z, int actualX, int actualZ) {
        IBlockState state = primer.func_177856_a(x, y, z);
        for (ClusterInfo info : clusters) {
            double chance;
            double distZ;
            double distZ2;
            double distY;
            double distY2;
            BlockPos origin;
            double distX;
            double distX2;
            if (!info.cluster.canSpawn(state) || !((distX2 = (distX = (double)(actualX - (origin = info.center).func_177958_n())) * distX) / (double)info.radX2 + (distY2 = (distY = (double)(y - origin.func_177956_o())) * distY) / (double)info.radY2 + (distZ2 = (distZ = (double)(actualZ - origin.func_177952_p())) * distZ) / (double)info.radZ2 <= 1.0) || (chance = info.cluster.integrity) != 1.0 && !((double)rand.nextFloat() <= chance)) continue;
            primer.func_177855_a(x, y, z, info.state);
            return;
        }
    }

    private static class ClusterInfo {
        final ClusterSettings cluster;
        final IBlockState state;
        final int id;
        final BlockPos center;
        final int radY;
        final int radX2;
        final int radY2;
        final int radZ2;

        ClusterInfo(ClusterSettings cluster, IBlockState state, int id, BlockPos center, int radX, int radY, int radZ) {
            this.cluster = cluster;
            this.state = state;
            this.id = id;
            this.center = center;
            this.radY = radY;
            this.radY2 = radY * radY;
            this.radX2 = radX * radX;
            this.radZ2 = radZ * radZ;
        }
    }
}

