/*
 * Decompiled with CFR 0.152.
 */
package com.personthecat.cavegenerator.world.feature;

import com.personthecat.cavegenerator.Main;
import com.personthecat.cavegenerator.io.SafeFileIO;
import com.personthecat.cavegenerator.util.CommonMethods;
import com.personthecat.cavegenerator.util.Result;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Optional;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraft.world.gen.structure.template.TemplateManager;
import net.minecraftforge.fml.common.Loader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class StructureSpawner {
    private static final Logger log = LogManager.getLogger(StructureSpawner.class);
    private static final String FOLDER = "cavegenerator/structures";
    public static final File DIR = new File(Loader.instance().getConfigDir(), "cavegenerator/structures");

    public static void loadAllStructures(Map<String, Template> structures) {
        SafeFileIO.ensureDirExists(DIR).expect("Error creating structure directory");
        structures.clear();
        SafeFileIO.listFiles(DIR).ifPresent(files -> {
            for (File file : files) {
                if (!file.getName().endsWith(".nbt")) continue;
                Template template = new Template();
                String name = file.getName();
                StructureSpawner.read(template, file).expectF("Error: unable to read structure file {}", name);
                StructureSpawner.warnSizeLimitations(template, name);
                structures.put(StructureSpawner.removeNbt(name), template);
            }
        });
    }

    private static Result<IOException> read(Template template, File nbt) {
        try {
            template.func_186256_b(CompressedStreamTools.func_74796_a((InputStream)new FileInputStream(nbt)));
        }
        catch (IOException e) {
            return Result.of(e);
        }
        return Result.ok();
    }

    private static void warnSizeLimitations(Template template, String name) {
        if (template.func_186259_a().func_177958_n() > 15 || template.func_186259_a().func_177952_p() > 15) {
            log.warn("Large structures are not yet fully supported. Expect cascading generation lag caused by {}.", (Object)name);
        }
    }

    public static Template getTemplate(String fileOrResource, World world) {
        ResourceLocation location;
        Map<String, Template> structures = Main.instance.structures;
        Optional<Template> fromMap = CommonMethods.safeGet(structures, fileOrResource = StructureSpawner.removeNbt(fileOrResource));
        if (fromMap.isPresent()) {
            return fromMap.get();
        }
        if (world.field_72995_K) {
            throw CommonMethods.runEx("Build error: Somehow called StructureSpawner#getTemplate with an invalid World object.");
        }
        WorldServer worldServer = (WorldServer)world;
        MinecraftServer mcServer = world.func_73046_m();
        TemplateManager manager = worldServer.func_184163_y();
        Template template = manager.func_189942_b(mcServer, location = new ResourceLocation(fileOrResource));
        if (template == null) {
            throw StructureSpawner.templateNotFound(fileOrResource);
        }
        return template;
    }

    private static RuntimeException templateNotFound(String name) {
        return CommonMethods.runExF("Error: No template named \"{}\" was found. Please verify that this refers to a valid file or registry name.", name);
    }

    public static void spawnStructure(Template template, PlacementSettings settings, World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        world.func_184138_a(pos, state, state, 3);
        template.func_186253_b(world, pos, settings);
    }

    private static String removeNbt(String name) {
        return name.replace(".nbt", "");
    }
}

