/*
 * Decompiled with CFR 0.152.
 */
package com.personthecat.cavegenerator.world.feature;

import com.personthecat.cavegenerator.data.StalactiteSettings;
import com.personthecat.cavegenerator.model.Range;
import com.personthecat.cavegenerator.util.XoRoShiRo;
import com.personthecat.cavegenerator.world.feature.FeatureGenerator;
import com.personthecat.cavegenerator.world.feature.WorldContext;
import java.util.Random;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;

@ParametersAreNonnullByDefault
public class StalactiteGenerator
extends FeatureGenerator {
    private final StalactiteSettings cfg;
    private final int resolution;
    private final boolean speleothem;
    private final boolean stalactite;
    private final boolean stalagmite;

    public StalactiteGenerator(StalactiteSettings cfg, World world) {
        super(cfg.conditions, world);
        this.cfg = cfg;
        this.resolution = StalactiteGenerator.calculateResolution(cfg.chance);
        this.speleothem = cfg.type.equals((Object)StalactiteSettings.Type.SPELEOTHEM);
        this.stalactite = this.speleothem || cfg.type.equals((Object)StalactiteSettings.Type.STALACTITE);
        this.stalagmite = this.speleothem || cfg.type.equals((Object)StalactiteSettings.Type.STALAGMITE);
    }

    private static int calculateResolution(double chance) {
        if (chance < 0.25) {
            return 16;
        }
        if (chance < 0.35) {
            return 8;
        }
        if (chance < 0.55) {
            return 4;
        }
        if (chance < 0.75) {
            return 2;
        }
        return 1;
    }

    @Override
    protected void doGenerate(WorldContext ctx) {
        XoRoShiRo localRand = new XoRoShiRo(ctx.rand.nextInt());
        for (int x = ctx.offsetX; x < ctx.offsetX + 16; x += this.resolution) {
            for (int z = ctx.offsetZ; z < ctx.offsetZ + 16; z += this.resolution) {
                Biome biome = ctx.world.func_180494_b(new BlockPos(x, 0, z));
                if (!this.conditions.biomes.test(biome) || !this.conditions.region.GetBoolean(x, z)) continue;
                this.generateRegion(ctx, localRand, x, z);
            }
        }
    }

    private void generateRegion(WorldContext info, Random rand, int x, int z) {
        for (int dx = x; dx < x + this.resolution; ++dx) {
            for (int dz = z; dz < z + this.resolution; ++dz) {
                BlockPos pos;
                int y;
                int maxY;
                Range height;
                if (rand.nextDouble() >= this.cfg.chance || (height = this.conditions.getColumn(dx, dz)).diff() == 0 || !this.conditions.region.GetBoolean(dz, dz) || (maxY = Math.min(info.heightmap[dx & 0xF][dz & 0xF] - 5, height.max)) <= height.min) continue;
                int n = y = this.stalactite ? this.findCeiling(info.world, dx, height.min, dz, maxY) : this.findFloor(info.world, dx, maxY, dz, height.min);
                if (y == Integer.MIN_VALUE || !this.conditions.noise.GetBoolean(dx, y, dz) || !this.checkSources(this.cfg.matchers, info.world, pos = new BlockPos(dx, y, dz))) continue;
                this.checkSpace(info.world, rand, pos);
            }
        }
    }

    private void checkSpace(World world, Random rand, BlockPos pos) {
        int length = this.cfg.length.rand(rand);
        int needed = this.cfg.space + length;
        int space = this.getSpace(world, pos, needed);
        if (this.speleothem && space > 2 * needed) {
            return;
        }
        if (space >= needed) {
            this.generateSingle(world, rand, pos, length, !this.stalactite);
            if (this.speleothem) {
                this.generateSingle(world, rand, pos.func_177979_c(space), length, true);
            }
        }
    }

    private void generateSingle(World world, Random rand, BlockPos pos, int length, boolean up) {
        this.place(world, pos, length, up);
        if (length > 2 && this.cfg.size != StalactiteSettings.Size.SMALL) {
            this.placeAll(world, rand, length * 2 / 3, up, StalactiteGenerator.sidePositions(pos));
            this.placeAll(world, rand, length / 4, up, StalactiteGenerator.cornerPositions(pos));
            if (length > 5 && this.cfg.size.ordinal() > StalactiteSettings.Size.MEDIUM.ordinal()) {
                this.placeAll(world, rand, length / 4, up, StalactiteGenerator.middleSidePositions(pos));
                this.placeAll(world, rand, length / 6, up, StalactiteGenerator.middleCornerPositions(pos));
                if (length > 9 && this.cfg.size.ordinal() > StalactiteSettings.Size.LARGE.ordinal()) {
                    this.placeAll(world, rand, length / 8, up, StalactiteGenerator.outerSidePositions(pos));
                    this.placeAll(world, rand, length / 11, up, StalactiteGenerator.outerCornerPositions(pos));
                    this.placeAll(world, rand, length / 8, up, StalactiteGenerator.outerBetweenPositions(pos));
                }
            }
        }
    }

    private int getSpace(World world, BlockPos pos, int max) {
        for (int i = 0; i < max; ++i) {
            BlockPos blockPos = pos = this.stalactite ? pos.func_177977_b() : pos.func_177984_a();
            if (!world.func_180495_p(pos).func_185914_p()) continue;
            return i;
        }
        return max;
    }

    private void place(World world, BlockPos pos, int length, boolean up) {
        for (int i = 0; i < length; ++i) {
            pos = up ? pos.func_177984_a() : pos.func_177977_b();
            world.func_180501_a(pos, this.cfg.state, 16);
        }
    }

    private void placeAll(World world, Random rand, int length, boolean up, BlockPos[] positions) {
        for (BlockPos pos : positions) {
            if (!this.cfg.symmetrical) {
                int min = length * 9 / 11;
                length = rand.nextInt(length - min + 1) + min;
            }
            this.findPlace(world, pos, length, up);
        }
    }

    private void findPlace(World world, BlockPos pos, int length, boolean up) {
        for (int i = 0; i < 3; ++i) {
            if (world.func_180495_p(pos).func_185914_p()) {
                this.place(world, pos, length, up);
                return;
            }
            pos = up ? pos.func_177977_b() : pos.func_177984_a();
        }
    }

    private static BlockPos[] sidePositions(BlockPos pos) {
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        return new BlockPos[]{new BlockPos(x, y, z - 1), new BlockPos(x, y, z + 1), new BlockPos(x + 1, y, z), new BlockPos(x - 1, y, z)};
    }

    private static BlockPos[] cornerPositions(BlockPos pos) {
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        return new BlockPos[]{new BlockPos(x + 1, y, z - 1), new BlockPos(x + 1, y, z + 1), new BlockPos(x - 1, y, z + 1), new BlockPos(x - 1, y, z - 1)};
    }

    private static BlockPos[] middleSidePositions(BlockPos pos) {
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        return new BlockPos[]{new BlockPos(x, y, z - 2), new BlockPos(x, y, z + 2), new BlockPos(x + 2, y, z), new BlockPos(x - 2, y, z)};
    }

    private static BlockPos[] middleCornerPositions(BlockPos pos) {
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        return new BlockPos[]{new BlockPos(x + 2, y, z + 1), new BlockPos(x + 2, y, z - 1), new BlockPos(x - 2, y, z + 1), new BlockPos(x - 2, y, z - 1), new BlockPos(x + 1, y, z + 2), new BlockPos(x - 1, y, z + 2), new BlockPos(x + 1, y, z - 2), new BlockPos(x - 1, y, z - 2)};
    }

    private static BlockPos[] outerSidePositions(BlockPos pos) {
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        return new BlockPos[]{new BlockPos(x, y, z - 3), new BlockPos(x, y, z + 3), new BlockPos(x + 3, y, z), new BlockPos(x - 3, y, z)};
    }

    private static BlockPos[] outerBetweenPositions(BlockPos pos) {
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        return new BlockPos[]{new BlockPos(x + 2, y, z - 2), new BlockPos(x + 2, y, z + 2), new BlockPos(x - 2, y, z + 2), new BlockPos(x - 2, y, z - 2)};
    }

    private static BlockPos[] outerCornerPositions(BlockPos pos) {
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        return new BlockPos[]{new BlockPos(x + 1, y, z + 3), new BlockPos(x + 3, y, z + 1), new BlockPos(x + 3, y, z - 1), new BlockPos(x + 1, y, z - 3), new BlockPos(x - 1, y, z - 3), new BlockPos(x - 3, y, z - 1), new BlockPos(x - 3, y, z + 1), new BlockPos(x - 1, y, z + 3)};
    }
}

