/*
 * Decompiled with CFR 0.152.
 */
package com.personthecat.cavegenerator.world;

import java.util.Arrays;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HeightMapLocator {
    private static final Logger log = LogManager.getLogger(HeightMapLocator.class);
    private static final int RELATIVE_DISTANCE = 5;
    private static final int NUM_TO_SKIP = 5;
    private static final IBlockState BLK_WATER = Blocks.field_150355_j.func_176223_P();
    public static final int FAUX_MAP_HEIGHT = 255;
    public static final int[][] FAUX_MAP = HeightMapLocator.getFauxMap();

    public static int[][] getHeightFromPrimer(ChunkPrimer primer) {
        int[][] map = new int[16][16];
        int previousHeight = HeightMapLocator.getHeightFromBottom(primer, 0, 0);
        for (int x = 0; x < 16; x += 2) {
            previousHeight = HeightMapLocator.fillTwoRows(primer, map, previousHeight, x);
        }
        return map;
    }

    public static int[][] getHeightFromChunk(World world, Chunk chunk) {
        int[][] map = new int[16][16];
        int[] original = chunk.func_177445_q();
        int seaLevel = world.func_181545_F();
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int originalY = original[z << 4 | x];
                map[x][z] = originalY == seaLevel ? HeightMapLocator.getHeight(chunk, x, z, seaLevel - 1) : originalY;
            }
        }
        return map;
    }

    public static int[][] getHeightFromWorld(World world, int chunkX, int chunkZ) {
        int[][] map = new int[16][16];
        HeightMapLocator.fillMapCorner(map, world, chunkX, chunkZ, 8, 15, 8, 15);
        HeightMapLocator.fillMapCorner(map, world, chunkX + 1, chunkZ, 0, 7, 8, 15);
        HeightMapLocator.fillMapCorner(map, world, chunkX, chunkZ + 1, 8, 15, 0, 7);
        HeightMapLocator.fillMapCorner(map, world, chunkX + 1, chunkZ + 1, 0, 7, 0, 7);
        return map;
    }

    private static void fillMapCorner(int[][] map, World world, int chunkX, int chunkZ, int minX, int maxX, int minZ, int maxZ) {
        Chunk chunk = world.func_72964_e(chunkX, chunkZ);
        int seaLevel = world.func_181545_F();
        int[] original = chunk.func_177445_q();
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                int originalY = original[z << 4 | x];
                map[x][z] = originalY == seaLevel ? HeightMapLocator.getHeight(chunk, x, z, seaLevel - 1) : originalY;
            }
        }
    }

    private static int toRelative(int absolute) {
        return absolute & 0xF;
    }

    private static int getHeightFromBottom(ChunkPrimer primer, int x, int z) {
        boolean previouslySolid = HeightMapLocator.isSolid(primer, x, 0, z);
        for (int y = 1; y < 256; ++y) {
            boolean currentlySolid = HeightMapLocator.isSolid(primer, x, y, z);
            if (previouslySolid && !currentlySolid) {
                return y - 1;
            }
            previouslySolid = currentlySolid;
        }
        return 63;
    }

    private static int getHeightFromRelative(ChunkPrimer primer, int x, int z, int previousHeight) {
        boolean previouslySolid = HeightMapLocator.isSolid(primer, x, previousHeight, z);
        if (previouslySolid) {
            for (int y = previousHeight + 1; y < previousHeight + 5; ++y) {
                boolean currentlySolid = HeightMapLocator.isSolid(primer, x, y, z);
                if (previouslySolid && !currentlySolid) {
                    return y - 1;
                }
                previouslySolid = currentlySolid;
            }
        } else {
            for (int y = previousHeight - 1; y > previousHeight - 5; --y) {
                boolean currentlySolid = HeightMapLocator.isSolid(primer, x, y, z);
                if (!previouslySolid && currentlySolid) {
                    return y;
                }
                previouslySolid = currentlySolid;
            }
        }
        return HeightMapLocator.getHeightFromBottom(primer, x, z);
    }

    private static boolean isSolid(ChunkPrimer primer, int x, int y, int z) {
        return primer.func_177856_a(x, y, z).func_185914_p();
    }

    private static int fillTwoRows(ChunkPrimer primer, int[][] map, int previousHeight, int startX) {
        int z;
        for (z = 0; z < 16; ++z) {
            map[startX][z] = previousHeight = HeightMapLocator.getHeightFromRelative(primer, startX, z, previousHeight);
        }
        for (z = 15; z > -1; --z) {
            map[startX + 1][z] = previousHeight = HeightMapLocator.getHeightFromRelative(primer, startX + 1, z, previousHeight);
        }
        return previousHeight;
    }

    private static int getHeight(Chunk chunk, int x, int z, int seaLevel) {
        for (int y = seaLevel; y > 5; y -= 5) {
            if (chunk.func_186032_a(x, y, z).equals(BLK_WATER)) continue;
            return HeightMapLocator.findWaterAbove(chunk, x, y, z) - 1;
        }
        return seaLevel;
    }

    private static int findWaterAbove(Chunk chunk, int x, int y, int z) {
        for (int h = y; h < y + 5; ++h) {
            if (!chunk.func_186032_a(x, h, z).equals(BLK_WATER)) continue;
            return h;
        }
        return y;
    }

    private static int[][] getFauxMap() {
        int[][] map;
        for (int[] x : map = new int[16][16]) {
            Arrays.fill(x, 255);
        }
        return map;
    }

    private static void printMap(int[][] map) {
        for (int[] row : map) {
            log.info(Arrays.toString(row));
        }
        log.info("");
    }
}

