/*
 * Decompiled with CFR 0.152.
 */
package com.personthecat.cavegenerator.util;

import com.personthecat.cavegenerator.util.PositionConsumer;
import com.personthecat.cavegenerator.util.PositionPredicate;

public class PositionFlags {
    private static final int Z_MASK = 15;
    private static final int Y_MASK = 255;
    private static final int BUFFER_SIZE = 64;
    private int[] positions;
    private int index;

    public PositionFlags(int capacity) {
        this.positions = new int[capacity];
        this.index = 0;
    }

    public void grow(int volume) {
        int len = this.positions.length;
        if (volume > len) {
            int[] data = this.positions;
            this.positions = new int[volume + 64];
            System.arraycopy(data, 0, this.positions, 0, len);
        }
    }

    public void add(int x, int y, int z) {
        this.positions[this.index++] = x << 12 | z << 8 | y;
    }

    public void forEach(PositionConsumer f) {
        for (int i = 0; i < this.index; ++i) {
            int data = this.positions[i];
            f.accept(data >> 12, data & 0xFF, data >> 8 & 0xF);
        }
    }

    public void filter(PositionPredicate predicate) {
        int end = this.index;
        this.index = 0;
        for (int i = 0; i < end; ++i) {
            int data = this.positions[i];
            int x = data >> 12;
            int y = data & 0xFF;
            int z = data >> 8 & 0xF;
            if (!predicate.test(x, y, z)) continue;
            this.positions[this.index++] = data;
        }
    }

    public boolean anyMatches(PositionPredicate predicate) {
        for (int i = 0; i < this.index; ++i) {
            int data = this.positions[i];
            if (!predicate.test(data >> 12, data & 0xFF, data >> 8 & 0xF)) continue;
            return true;
        }
        return false;
    }

    public void reset() {
        this.index = 0;
    }
}

