/*
 * Decompiled with CFR 0.152.
 */
package com.personthecat.cavegenerator.util;

import java.util.Optional;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

public class Lazy<T> {
    private T value = null;
    private final Supplier<T> supplier;

    private Lazy(Supplier<T> supplier) {
        this.supplier = supplier;
    }

    private Lazy(@NotNull T value) {
        this.value = value;
        this.supplier = () -> null;
    }

    public static <T> Lazy<T> of(Supplier<T> supplier) {
        return new Lazy<Supplier<T>>(supplier);
    }

    public static <T> Lazy<T> of(T value) {
        return new Lazy<T>(value);
    }

    public T get() {
        if (this.value == null) {
            this.value = this.supplier.get();
            if (this.value == null) {
                throw new NullPointerException("Lazy value produced nothing.");
            }
        }
        return this.value;
    }

    public Optional<T> getIfComputed() {
        return Optional.ofNullable(this.value);
    }

    public boolean computed() {
        return this.value != null;
    }
}

