/*
 * Decompiled with CFR 0.152.
 */
package com.personthecat.cavegenerator.util;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;

public class CaveLinter {
    private static final Pattern MULTILINE_DOC = Pattern.compile("/\\*\\*[\\s\\S]*?\\*/", 32);
    private static final Pattern MULTILINE_COMMENT = Pattern.compile("/\\*[\\s\\S]*?\\*/", 32);
    private static final Pattern LINE_TODO = Pattern.compile("(?:#|//).*(?:todo|to-do).*$", 10);
    private static final Pattern LINE_DOC = Pattern.compile("(?:#!|///).*$", 8);
    private static final Pattern LINE_COMMENT = Pattern.compile("(?:#|//).*$", 8);
    private static final Pattern CONSTANT = Pattern.compile("[-_A-Z]+\\s*:|[-_\\w./]+\\s*::\\s*[-_A-Z]+|.*\\s[aA][sS]\\s+[-_A-Z]+", 8);
    private static final Pattern FUNCTION = Pattern.compile("\\b\\w+\\(\\)\\s*:|[-_\\w./]+\\s*::\\s*\\w+\\(\\)|.*\\s[aA][sS]\\s+\\w+\\(\\)", 8);
    private static final Pattern KEY = Pattern.compile("(\"[\\w\\s]*\"|\\w+)\\s*:|[-_\\w./]+\\s*::\\s*\\w+|.*\\s[aA][sS]\\s+\\w+", 8);
    private static final Pattern CALL = Pattern.compile("\\B\\$\\w+\\((?:.*\\)\\B)?", 8);
    private static final Pattern REFERENCE = Pattern.compile("\\B\\$\\w+", 8);
    private static final Pattern ARGUMENT = Pattern.compile("\\B@\\d+(?:\\s*\\?(?:\\s*\\(.*\\))?)?", 8);

    public static ITextComponent lint(String text) {
        Scope s;
        TextComponentString formatted = new TextComponentString("");
        Context ctx = new Context(text);
        int i = 0;
        while ((s = ctx.next(i)) != null) {
            int start = s.matcher.start();
            int end = s.matcher.end();
            ctx.skipTo(end);
            if (start - i > 0) {
                formatted.func_150257_a(CaveLinter.tcs(text.substring(i, start)));
            }
            formatted.func_150257_a(CaveLinter.tcs(text.substring(start, end)).func_150255_a(s.style));
            i = end;
        }
        return formatted.func_150257_a(CaveLinter.tcs(text.substring(i)));
    }

    private static ITextComponent tcs(String s) {
        return new TextComponentString(s);
    }

    static /* synthetic */ Pattern access$000() {
        return MULTILINE_DOC;
    }

    static /* synthetic */ Pattern access$100() {
        return LINE_TODO;
    }

    static /* synthetic */ Pattern access$200() {
        return LINE_DOC;
    }

    static /* synthetic */ Pattern access$300() {
        return MULTILINE_COMMENT;
    }

    static /* synthetic */ Pattern access$400() {
        return LINE_COMMENT;
    }

    static /* synthetic */ Pattern access$500() {
        return CONSTANT;
    }

    static /* synthetic */ Pattern access$600() {
        return FUNCTION;
    }

    static /* synthetic */ Pattern access$700() {
        return KEY;
    }

    static /* synthetic */ Pattern access$800() {
        return CALL;
    }

    static /* synthetic */ Pattern access$900() {
        return REFERENCE;
    }

    static /* synthetic */ Pattern access$1000() {
        return ARGUMENT;
    }

    private static class Scope {
        final Matcher matcher;
        final Style style;
        boolean found;

        void next() {
            this.found = this.matcher.find();
        }

        public Scope(Matcher matcher, Style style, boolean found) {
            this.matcher = matcher;
            this.style = style;
            this.found = found;
        }
    }

    private static class Target {
        final Pattern pattern;
        final Style style;

        public Target(Pattern pattern, Style style) {
            this.pattern = pattern;
            this.style = style;
        }
    }

    private static class Context {
        static final Target[] TARGETS = new Target[]{new Target(CaveLinter.access$000(), new Style().func_150238_a(TextFormatting.DARK_GREEN).func_150217_b(Boolean.valueOf(true))), new Target(CaveLinter.access$100(), new Style().func_150238_a(TextFormatting.YELLOW)), new Target(CaveLinter.access$200(), new Style().func_150238_a(TextFormatting.DARK_GREEN).func_150217_b(Boolean.valueOf(true))), new Target(CaveLinter.access$300(), new Style().func_150238_a(TextFormatting.GRAY)), new Target(CaveLinter.access$400(), new Style().func_150238_a(TextFormatting.GRAY)), new Target(CaveLinter.access$500(), new Style().func_150238_a(TextFormatting.DARK_PURPLE)), new Target(CaveLinter.access$600(), new Style().func_150238_a(TextFormatting.GOLD)), new Target(CaveLinter.access$700(), new Style().func_150238_a(TextFormatting.AQUA)), new Target(CaveLinter.access$800(), new Style().func_150238_a(TextFormatting.GOLD).func_150228_d(Boolean.valueOf(true))), new Target(CaveLinter.access$900(), new Style().func_150238_a(TextFormatting.DARK_PURPLE).func_150228_d(Boolean.valueOf(true))), new Target(CaveLinter.access$1000(), new Style().func_150238_a(TextFormatting.DARK_GREEN).func_150228_d(Boolean.valueOf(true)))};
        final List<Scope> scopes = new ArrayList<Scope>();
        final String text;

        Context(String text) {
            this.text = text;
            for (Target t : TARGETS) {
                Matcher matcher = t.pattern.matcher(text);
                this.scopes.add(new Scope(matcher, t.style, matcher.find()));
            }
        }

        @Nullable
        Scope next(int i) {
            int start = Integer.MAX_VALUE;
            Scope first = null;
            for (Scope s : this.scopes) {
                int mStart;
                if (!s.found || (mStart = s.matcher.start()) < i || mStart >= start) continue;
                start = mStart;
                first = s;
            }
            return first;
        }

        void skipTo(int i) {
            for (Scope s : this.scopes) {
                if (!s.found || s.matcher.end() > i) continue;
                s.next();
            }
        }
    }
}

