/*
 * Decompiled with CFR 0.152.
 */
package com.personthecat.cavegenerator.model;

import com.personthecat.cavegenerator.data.ShellSettings;
import com.personthecat.cavegenerator.noise.DummyGenerator;
import com.personthecat.cavegenerator.util.CommonMethods;
import fastnoise.FastNoise;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.world.World;

public class ConfiguredShell {
    public static final ConfiguredShell EMPTY_SHELL = new ConfiguredShell();
    public final ShellSettings cfg;
    public final double radius;
    public final float noiseThreshold;
    public final List<Decorator> decorators;

    public ConfiguredShell(ShellSettings cfg, World world) {
        this.cfg = cfg;
        this.radius = cfg.radius;
        this.noiseThreshold = cfg.noiseThreshold.orElse(Float.valueOf(((float)cfg.radius + 1.0E-4f) / 10.0f)).floatValue();
        this.decorators = CommonMethods.map(cfg.decorators, d -> new Decorator((ShellSettings.Decorator)d, world));
    }

    private ConfiguredShell() {
        this.cfg = ShellSettings.builder().build();
        this.radius = 0.0;
        this.noiseThreshold = 0.0f;
        this.decorators = Collections.emptyList();
    }

    public static class Decorator {
        public final ShellSettings.Decorator cfg;
        public final FastNoise noise;

        private Decorator(ShellSettings.Decorator cfg, World world) {
            this.cfg = cfg;
            this.noise = cfg.noise.map(n -> n.getGenerator(world)).orElse(new DummyGenerator(0.0f));
        }

        public boolean matches(IBlockState state) {
            if (this.cfg.matchers.isEmpty()) {
                return state.func_185914_p();
            }
            return this.cfg.matchers.contains(state);
        }

        public boolean testNoise(int x, int y, int z, int chunkX, int chunkZ) {
            int actualX = chunkX * 16 + x;
            int actualZ = chunkZ * 16 + z;
            return this.testNoise(actualX, y, actualZ);
        }

        private boolean testNoise(int x, int y, int z) {
            return this.noise.GetBoolean(x, y, z);
        }
    }
}

