/*
 * Decompiled with CFR 0.152.
 */
package com.personthecat.cavegenerator.model;

import com.personthecat.cavegenerator.data.CaveBlockSettings;
import com.personthecat.cavegenerator.noise.DummyGenerator;
import fastnoise.FastNoise;
import net.minecraft.world.World;

public class ConfiguredCaveBlock {
    public final CaveBlockSettings cfg;
    public final FastNoise noise;

    public ConfiguredCaveBlock(CaveBlockSettings cfg, World world) {
        this.cfg = cfg;
        this.noise = cfg.noise.map(n -> n.getGenerator(world)).orElse(new DummyGenerator(0.0f));
    }

    public boolean canGenerate(int x, int y, int z, int chunkX, int chunkZ) {
        return this.canGenerateAtHeight(y) && this.testNoise(x, y, z, chunkX, chunkZ);
    }

    private boolean canGenerateAtHeight(int y) {
        return y >= this.cfg.height.min && y <= this.cfg.height.max;
    }

    private boolean testNoise(int x, int y, int z, int chunkX, int chunkZ) {
        int actualX = chunkX * 16 + x;
        int actualZ = chunkZ * 16 + z;
        return this.testNoise(actualX, y, actualZ);
    }

    private boolean testNoise(int x, int y, int z) {
        return this.noise.GetBoolean(x, y, z);
    }
}

