/*
 * Decompiled with CFR 0.152.
 */
package com.personthecat.cavegenerator.data;

import com.personthecat.cavegenerator.data.ConditionSettings;
import com.personthecat.cavegenerator.data.DecoratorSettings;
import com.personthecat.cavegenerator.data.OverrideSettings;
import com.personthecat.cavegenerator.data.RoomSettings;
import com.personthecat.cavegenerator.model.Range;
import com.personthecat.cavegenerator.model.ScalableFloat;
import com.personthecat.cavegenerator.util.CommonMethods;
import com.personthecat.cavegenerator.util.HjsonMapper;
import java.util.Optional;
import org.hjson.JsonObject;

public class TunnelSettings {
    private static final String FEATURE_NAME = "tunnels";
    private static final ConditionSettings DEFAULT_CONDITIONS = ConditionSettings.builder().height(Range.of(8, 128)).build();
    private static final DecoratorSettings DEFAULT_DECORATORS = DecoratorSettings.DEFAULTS;
    public final ConditionSettings conditions;
    public final DecoratorSettings decorators;
    public final Range originHeight;
    public final boolean noiseYReduction;
    public final boolean resizeBranches;
    public final Optional<TunnelSettings> branches;
    public final Optional<RoomSettings> rooms;
    public final ScalableFloat dYaw;
    public final ScalableFloat dPitch;
    public final ScalableFloat scale;
    public final ScalableFloat stretch;
    public final ScalableFloat yaw;
    public final ScalableFloat pitch;
    public final int systemChance;
    public final int chance;
    public final int systemDensity;
    public final int distance;
    public final int count;
    public final int resolution;
    public final Optional<Long> seed;
    public final boolean reseedBranches;
    public final boolean hasBranches;
    public final boolean checkWater;

    public static TunnelSettings from(JsonObject json, OverrideSettings overrides) {
        ConditionSettings conditions = overrides.apply(DEFAULT_CONDITIONS.toBuilder()).build();
        DecoratorSettings decorators = overrides.apply(DEFAULT_DECORATORS.toBuilder()).build();
        TunnelSettingsBuilder builder = overrides.apply(TunnelSettings.builder());
        return TunnelSettings.copyInto(json, builder.conditions(conditions).decorators(decorators));
    }

    public static TunnelSettings from(JsonObject json, ConditionSettings conditions, DecoratorSettings decorators) {
        return TunnelSettings.copyInto(json, TunnelSettings.builder().conditions(conditions).decorators(decorators));
    }

    public static TunnelSettings from(JsonObject json) {
        return TunnelSettings.copyInto(json, TunnelSettings.builder());
    }

    private static TunnelSettings copyInto(JsonObject json, TunnelSettingsBuilder builder) {
        TunnelSettings original = builder.build();
        return new HjsonMapper(json).mapSelf(o -> builder.conditions(ConditionSettings.from(o, original.conditions))).mapSelf(o -> builder.decorators(DecoratorSettings.from(o, original.decorators))).mapRangeOrTry("originHeight", "height", builder::originHeight).mapBool("noiseYReduction", builder::noiseYReduction).mapBool("resizeBranches", builder::resizeBranches).mapObject("branches", o -> builder.branches(CommonMethods.full(TunnelSettings.from(o)))).mapObject("rooms", o -> builder.rooms(CommonMethods.full(RoomSettings.from(o)))).mapScalableFloat("dYaw", original.dYaw, builder::dYaw).mapScalableFloat("dPitch", original.dPitch, builder::dPitch).mapScalableFloat("scale", original.scale, builder::scale).mapScalableFloat("stretch", original.stretch, builder::stretch).mapScalableFloat("yaw", original.yaw, builder::yaw).mapScalableFloat("pitch", original.pitch, builder::pitch).mapFloat("systemChance", f -> builder.systemChance(CommonMethods.invert(f.floatValue()))).mapFloat("chance", f -> builder.chance(CommonMethods.invert(f.floatValue()))).mapInt("systemDensity", builder::systemDensity).mapInt("distance", builder::distance).mapInt("count", builder::count).mapInt("resolution", builder::resolution).mapInt("seed", i -> builder.seed(CommonMethods.full(Long.valueOf(i.intValue())))).mapBool("reseedBranches", builder::reseedBranches).mapBool("hasBranches", builder::hasBranches).mapBool("checkWater", builder::checkWater).release(builder::build);
    }

    private static ConditionSettings $default$conditions() {
        return DEFAULT_CONDITIONS;
    }

    private static DecoratorSettings $default$decorators() {
        return DEFAULT_DECORATORS;
    }

    private static Range $default$originHeight() {
        return Range.of(8, 128);
    }

    private static boolean $default$noiseYReduction() {
        return true;
    }

    private static boolean $default$resizeBranches() {
        return true;
    }

    private static Optional<TunnelSettings> $default$branches() {
        return CommonMethods.empty();
    }

    private static Optional<RoomSettings> $default$rooms() {
        return CommonMethods.empty();
    }

    private static ScalableFloat $default$dYaw() {
        return new ScalableFloat(0.0f, 0.0f, 0.75f, 4.0f, 1.0f);
    }

    private static ScalableFloat $default$dPitch() {
        return new ScalableFloat(0.0f, 0.0f, 0.9f, 2.0f, 1.0f);
    }

    private static ScalableFloat $default$scale() {
        return new ScalableFloat(0.0f, 1.0f, 1.0f, 0.0f, 1.0f);
    }

    private static ScalableFloat $default$stretch() {
        return new ScalableFloat(1.0f, 1.0f, 1.0f, 0.0f, 1.0f);
    }

    private static ScalableFloat $default$yaw() {
        return new ScalableFloat(0.0f, 1.0f, 1.0f, 0.0f, 1.0f);
    }

    private static ScalableFloat $default$pitch() {
        return new ScalableFloat(0.0f, 0.25f, 1.0f, 0.0f, 1.0f);
    }

    private static int $default$systemChance() {
        return 4;
    }

    private static int $default$chance() {
        return 7;
    }

    private static int $default$systemDensity() {
        return 4;
    }

    private static int $default$distance() {
        return 0;
    }

    private static int $default$count() {
        return 15;
    }

    private static int $default$resolution() {
        return 4;
    }

    private static Optional<Long> $default$seed() {
        return CommonMethods.empty();
    }

    private static boolean $default$reseedBranches() {
        return true;
    }

    private static boolean $default$hasBranches() {
        return true;
    }

    private static boolean $default$checkWater() {
        return true;
    }

    TunnelSettings(ConditionSettings conditions, DecoratorSettings decorators, Range originHeight, boolean noiseYReduction, boolean resizeBranches, Optional<TunnelSettings> branches, Optional<RoomSettings> rooms, ScalableFloat dYaw, ScalableFloat dPitch, ScalableFloat scale, ScalableFloat stretch, ScalableFloat yaw, ScalableFloat pitch, int systemChance, int chance, int systemDensity, int distance, int count, int resolution, Optional<Long> seed, boolean reseedBranches, boolean hasBranches, boolean checkWater) {
        this.conditions = conditions;
        this.decorators = decorators;
        this.originHeight = originHeight;
        this.noiseYReduction = noiseYReduction;
        this.resizeBranches = resizeBranches;
        this.branches = branches;
        this.rooms = rooms;
        this.dYaw = dYaw;
        this.dPitch = dPitch;
        this.scale = scale;
        this.stretch = stretch;
        this.yaw = yaw;
        this.pitch = pitch;
        this.systemChance = systemChance;
        this.chance = chance;
        this.systemDensity = systemDensity;
        this.distance = distance;
        this.count = count;
        this.resolution = resolution;
        this.seed = seed;
        this.reseedBranches = reseedBranches;
        this.hasBranches = hasBranches;
        this.checkWater = checkWater;
    }

    public static TunnelSettingsBuilder builder() {
        return new TunnelSettingsBuilder();
    }

    public static final class Fields {
        public static final String conditions = "conditions";
        public static final String decorators = "decorators";
        public static final String originHeight = "originHeight";
        public static final String noiseYReduction = "noiseYReduction";
        public static final String resizeBranches = "resizeBranches";
        public static final String branches = "branches";
        public static final String rooms = "rooms";
        public static final String dYaw = "dYaw";
        public static final String dPitch = "dPitch";
        public static final String scale = "scale";
        public static final String stretch = "stretch";
        public static final String yaw = "yaw";
        public static final String pitch = "pitch";
        public static final String systemChance = "systemChance";
        public static final String chance = "chance";
        public static final String systemDensity = "systemDensity";
        public static final String distance = "distance";
        public static final String count = "count";
        public static final String resolution = "resolution";
        public static final String seed = "seed";
        public static final String reseedBranches = "reseedBranches";
        public static final String hasBranches = "hasBranches";
        public static final String checkWater = "checkWater";

        private Fields() {
        }
    }

    public static class TunnelSettingsBuilder {
        private boolean conditions$set;
        private ConditionSettings conditions$value;
        private boolean decorators$set;
        private DecoratorSettings decorators$value;
        private boolean originHeight$set;
        private Range originHeight$value;
        private boolean noiseYReduction$set;
        private boolean noiseYReduction$value;
        private boolean resizeBranches$set;
        private boolean resizeBranches$value;
        private boolean branches$set;
        private Optional<TunnelSettings> branches$value;
        private boolean rooms$set;
        private Optional<RoomSettings> rooms$value;
        private boolean dYaw$set;
        private ScalableFloat dYaw$value;
        private boolean dPitch$set;
        private ScalableFloat dPitch$value;
        private boolean scale$set;
        private ScalableFloat scale$value;
        private boolean stretch$set;
        private ScalableFloat stretch$value;
        private boolean yaw$set;
        private ScalableFloat yaw$value;
        private boolean pitch$set;
        private ScalableFloat pitch$value;
        private boolean systemChance$set;
        private int systemChance$value;
        private boolean chance$set;
        private int chance$value;
        private boolean systemDensity$set;
        private int systemDensity$value;
        private boolean distance$set;
        private int distance$value;
        private boolean count$set;
        private int count$value;
        private boolean resolution$set;
        private int resolution$value;
        private boolean seed$set;
        private Optional<Long> seed$value;
        private boolean reseedBranches$set;
        private boolean reseedBranches$value;
        private boolean hasBranches$set;
        private boolean hasBranches$value;
        private boolean checkWater$set;
        private boolean checkWater$value;

        TunnelSettingsBuilder() {
        }

        public TunnelSettingsBuilder conditions(ConditionSettings conditions) {
            this.conditions$value = conditions;
            this.conditions$set = true;
            return this;
        }

        public TunnelSettingsBuilder decorators(DecoratorSettings decorators) {
            this.decorators$value = decorators;
            this.decorators$set = true;
            return this;
        }

        public TunnelSettingsBuilder originHeight(Range originHeight) {
            this.originHeight$value = originHeight;
            this.originHeight$set = true;
            return this;
        }

        public TunnelSettingsBuilder noiseYReduction(boolean noiseYReduction) {
            this.noiseYReduction$value = noiseYReduction;
            this.noiseYReduction$set = true;
            return this;
        }

        public TunnelSettingsBuilder resizeBranches(boolean resizeBranches) {
            this.resizeBranches$value = resizeBranches;
            this.resizeBranches$set = true;
            return this;
        }

        public TunnelSettingsBuilder branches(Optional<TunnelSettings> branches) {
            this.branches$value = branches;
            this.branches$set = true;
            return this;
        }

        public TunnelSettingsBuilder rooms(Optional<RoomSettings> rooms) {
            this.rooms$value = rooms;
            this.rooms$set = true;
            return this;
        }

        public TunnelSettingsBuilder dYaw(ScalableFloat dYaw) {
            this.dYaw$value = dYaw;
            this.dYaw$set = true;
            return this;
        }

        public TunnelSettingsBuilder dPitch(ScalableFloat dPitch) {
            this.dPitch$value = dPitch;
            this.dPitch$set = true;
            return this;
        }

        public TunnelSettingsBuilder scale(ScalableFloat scale) {
            this.scale$value = scale;
            this.scale$set = true;
            return this;
        }

        public TunnelSettingsBuilder stretch(ScalableFloat stretch) {
            this.stretch$value = stretch;
            this.stretch$set = true;
            return this;
        }

        public TunnelSettingsBuilder yaw(ScalableFloat yaw) {
            this.yaw$value = yaw;
            this.yaw$set = true;
            return this;
        }

        public TunnelSettingsBuilder pitch(ScalableFloat pitch) {
            this.pitch$value = pitch;
            this.pitch$set = true;
            return this;
        }

        public TunnelSettingsBuilder systemChance(int systemChance) {
            this.systemChance$value = systemChance;
            this.systemChance$set = true;
            return this;
        }

        public TunnelSettingsBuilder chance(int chance) {
            this.chance$value = chance;
            this.chance$set = true;
            return this;
        }

        public TunnelSettingsBuilder systemDensity(int systemDensity) {
            this.systemDensity$value = systemDensity;
            this.systemDensity$set = true;
            return this;
        }

        public TunnelSettingsBuilder distance(int distance) {
            this.distance$value = distance;
            this.distance$set = true;
            return this;
        }

        public TunnelSettingsBuilder count(int count) {
            this.count$value = count;
            this.count$set = true;
            return this;
        }

        public TunnelSettingsBuilder resolution(int resolution) {
            this.resolution$value = resolution;
            this.resolution$set = true;
            return this;
        }

        public TunnelSettingsBuilder seed(Optional<Long> seed) {
            this.seed$value = seed;
            this.seed$set = true;
            return this;
        }

        public TunnelSettingsBuilder reseedBranches(boolean reseedBranches) {
            this.reseedBranches$value = reseedBranches;
            this.reseedBranches$set = true;
            return this;
        }

        public TunnelSettingsBuilder hasBranches(boolean hasBranches) {
            this.hasBranches$value = hasBranches;
            this.hasBranches$set = true;
            return this;
        }

        public TunnelSettingsBuilder checkWater(boolean checkWater) {
            this.checkWater$value = checkWater;
            this.checkWater$set = true;
            return this;
        }

        public TunnelSettings build() {
            ConditionSettings conditions$value = this.conditions$value;
            if (!this.conditions$set) {
                conditions$value = TunnelSettings.$default$conditions();
            }
            DecoratorSettings decorators$value = this.decorators$value;
            if (!this.decorators$set) {
                decorators$value = TunnelSettings.$default$decorators();
            }
            Range originHeight$value = this.originHeight$value;
            if (!this.originHeight$set) {
                originHeight$value = TunnelSettings.$default$originHeight();
            }
            boolean noiseYReduction$value = this.noiseYReduction$value;
            if (!this.noiseYReduction$set) {
                noiseYReduction$value = TunnelSettings.$default$noiseYReduction();
            }
            boolean resizeBranches$value = this.resizeBranches$value;
            if (!this.resizeBranches$set) {
                resizeBranches$value = TunnelSettings.$default$resizeBranches();
            }
            Optional branches$value = this.branches$value;
            if (!this.branches$set) {
                branches$value = TunnelSettings.$default$branches();
            }
            Optional rooms$value = this.rooms$value;
            if (!this.rooms$set) {
                rooms$value = TunnelSettings.$default$rooms();
            }
            ScalableFloat dYaw$value = this.dYaw$value;
            if (!this.dYaw$set) {
                dYaw$value = TunnelSettings.$default$dYaw();
            }
            ScalableFloat dPitch$value = this.dPitch$value;
            if (!this.dPitch$set) {
                dPitch$value = TunnelSettings.$default$dPitch();
            }
            ScalableFloat scale$value = this.scale$value;
            if (!this.scale$set) {
                scale$value = TunnelSettings.$default$scale();
            }
            ScalableFloat stretch$value = this.stretch$value;
            if (!this.stretch$set) {
                stretch$value = TunnelSettings.$default$stretch();
            }
            ScalableFloat yaw$value = this.yaw$value;
            if (!this.yaw$set) {
                yaw$value = TunnelSettings.$default$yaw();
            }
            ScalableFloat pitch$value = this.pitch$value;
            if (!this.pitch$set) {
                pitch$value = TunnelSettings.$default$pitch();
            }
            int systemChance$value = this.systemChance$value;
            if (!this.systemChance$set) {
                systemChance$value = TunnelSettings.$default$systemChance();
            }
            int chance$value = this.chance$value;
            if (!this.chance$set) {
                chance$value = TunnelSettings.$default$chance();
            }
            int systemDensity$value = this.systemDensity$value;
            if (!this.systemDensity$set) {
                systemDensity$value = TunnelSettings.$default$systemDensity();
            }
            int distance$value = this.distance$value;
            if (!this.distance$set) {
                distance$value = TunnelSettings.$default$distance();
            }
            int count$value = this.count$value;
            if (!this.count$set) {
                count$value = TunnelSettings.$default$count();
            }
            int resolution$value = this.resolution$value;
            if (!this.resolution$set) {
                resolution$value = TunnelSettings.$default$resolution();
            }
            Optional seed$value = this.seed$value;
            if (!this.seed$set) {
                seed$value = TunnelSettings.$default$seed();
            }
            boolean reseedBranches$value = this.reseedBranches$value;
            if (!this.reseedBranches$set) {
                reseedBranches$value = TunnelSettings.$default$reseedBranches();
            }
            boolean hasBranches$value = this.hasBranches$value;
            if (!this.hasBranches$set) {
                hasBranches$value = TunnelSettings.$default$hasBranches();
            }
            boolean checkWater$value = this.checkWater$value;
            if (!this.checkWater$set) {
                checkWater$value = TunnelSettings.$default$checkWater();
            }
            return new TunnelSettings(conditions$value, decorators$value, originHeight$value, noiseYReduction$value, resizeBranches$value, branches$value, rooms$value, dYaw$value, dPitch$value, scale$value, stretch$value, yaw$value, pitch$value, systemChance$value, chance$value, systemDensity$value, distance$value, count$value, resolution$value, seed$value, reseedBranches$value, hasBranches$value, checkWater$value);
        }

        public String toString() {
            return "TunnelSettings.TunnelSettingsBuilder(conditions$value=" + this.conditions$value + ", decorators$value=" + this.decorators$value + ", originHeight$value=" + this.originHeight$value + ", noiseYReduction$value=" + this.noiseYReduction$value + ", resizeBranches$value=" + this.resizeBranches$value + ", branches$value=" + this.branches$value + ", rooms$value=" + this.rooms$value + ", dYaw$value=" + this.dYaw$value + ", dPitch$value=" + this.dPitch$value + ", scale$value=" + this.scale$value + ", stretch$value=" + this.stretch$value + ", yaw$value=" + this.yaw$value + ", pitch$value=" + this.pitch$value + ", systemChance$value=" + this.systemChance$value + ", chance$value=" + this.chance$value + ", systemDensity$value=" + this.systemDensity$value + ", distance$value=" + this.distance$value + ", count$value=" + this.count$value + ", resolution$value=" + this.resolution$value + ", seed$value=" + this.seed$value + ", reseedBranches$value=" + this.reseedBranches$value + ", hasBranches$value=" + this.hasBranches$value + ", checkWater$value=" + this.checkWater$value + ")";
        }
    }
}

