/*
 * Decompiled with CFR 0.152.
 */
package com.personthecat.cavegenerator.data;

import com.personthecat.cavegenerator.data.ConditionSettings;
import com.personthecat.cavegenerator.data.DecoratorSettings;
import com.personthecat.cavegenerator.data.NoiseMapSettings;
import com.personthecat.cavegenerator.data.NoiseSettings;
import com.personthecat.cavegenerator.data.OverrideSettings;
import com.personthecat.cavegenerator.data.TunnelSettings;
import com.personthecat.cavegenerator.model.Range;
import com.personthecat.cavegenerator.util.CommonMethods;
import com.personthecat.cavegenerator.util.HjsonMapper;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.hjson.JsonObject;

public class CavernSettings {
    private static final String FEATURE_NAME = "caverns";
    private static final NoiseSettings DEFAULT_GENERATOR = NoiseSettings.builder().frequency(0.0143f).threshold(Range.of(-0.6f)).stretch(0.5f).octaves(1).build();
    private static final NoiseMapSettings DEFAULT_CEIL_NOISE = NoiseMapSettings.builder().frequency(0.02f).range(Range.of(-17, -3)).build();
    private static final NoiseMapSettings DEFAULT_FLOOR_NOISE = NoiseMapSettings.builder().frequency(0.02f).range(Range.of(0, 8)).build();
    private static final NoiseMapSettings DEFAULT_HEIGHT_OFFSET = NoiseMapSettings.builder().frequency(0.005f).range(Range.of(0, 50)).build();
    private static final NoiseMapSettings DEFAULT_WALL_NOISE = NoiseMapSettings.builder().frequency(0.02f).range(Range.of(9, 15)).build();
    private static final NoiseMapSettings DEFAULT_WALL_OFFSET = NoiseMapSettings.builder().frequency(0.05f).range(Range.of(0, 255)).build();
    private static final ConditionSettings DEFAULT_CONDITIONS = ConditionSettings.builder().height(Range.of(10, 50)).ceiling(CommonMethods.full(DEFAULT_CEIL_NOISE)).floor(CommonMethods.full(DEFAULT_FLOOR_NOISE)).build();
    private static final DecoratorSettings DEFAULT_DECORATORS = DecoratorSettings.DEFAULTS;
    public final ConditionSettings conditions;
    public final DecoratorSettings decorators;
    public final int resolution;
    public final Optional<NoiseMapSettings> offset;
    public final Optional<NoiseMapSettings> walls;
    public final Optional<NoiseMapSettings> wallOffset;
    public final float wallCurveRatio;
    public final boolean wallInterpolation;
    public final List<NoiseSettings> generators;
    public final Optional<TunnelSettings> branches;
    public final boolean deferred;

    public static CavernSettings from(JsonObject json, OverrideSettings overrides) {
        ConditionSettings conditions = overrides.apply(DEFAULT_CONDITIONS.toBuilder()).build();
        DecoratorSettings decorators = overrides.apply(DEFAULT_DECORATORS.toBuilder()).build();
        return CavernSettings.copyInto(json, CavernSettings.builder().conditions(conditions).decorators(decorators));
    }

    public static CavernSettings from(JsonObject json) {
        return CavernSettings.copyInto(json, CavernSettings.builder());
    }

    private static CavernSettings copyInto(JsonObject json, CavernSettingsBuilder builder) {
        CavernSettings original = builder.build();
        return new HjsonMapper(json).mapSelf(o -> builder.conditions(ConditionSettings.from(o, original.conditions))).mapSelf(o -> builder.decorators(DecoratorSettings.from(o, original.decorators))).mapInt("resolution", builder::resolution).mapObject("offset", o -> builder.offset(CommonMethods.full(NoiseMapSettings.from(o, DEFAULT_HEIGHT_OFFSET)))).mapObject("walls", o -> builder.walls(CommonMethods.full(NoiseMapSettings.from(o, DEFAULT_WALL_NOISE)))).mapObject("wallOffset", o -> builder.wallOffset(CommonMethods.full(NoiseMapSettings.from(o, DEFAULT_WALL_OFFSET)))).mapFloat("wallCurveRatio", builder::wallCurveRatio).mapBool("wallInterpolation", builder::wallInterpolation).mapArray("generators", CavernSettings::createNoise, builder::generators).mapObject("branches", o -> CavernSettings.copyBranches(builder, o)).mapBool("deferred", builder::deferred).release(builder::build);
    }

    private static NoiseSettings createNoise(JsonObject json) {
        return NoiseSettings.from(json, DEFAULT_GENERATOR);
    }

    private static void copyBranches(CavernSettingsBuilder builder, JsonObject branches) {
        CavernSettings updated = builder.build();
        builder.branches(CommonMethods.full(TunnelSettings.from(branches, updated.conditions, updated.decorators)));
    }

    private static ConditionSettings $default$conditions() {
        return DEFAULT_CONDITIONS;
    }

    private static DecoratorSettings $default$decorators() {
        return DEFAULT_DECORATORS;
    }

    private static int $default$resolution() {
        return 1;
    }

    private static Optional<NoiseMapSettings> $default$offset() {
        return CommonMethods.empty();
    }

    private static Optional<NoiseMapSettings> $default$walls() {
        return CommonMethods.empty();
    }

    private static Optional<NoiseMapSettings> $default$wallOffset() {
        return CommonMethods.empty();
    }

    private static float $default$wallCurveRatio() {
        return 1.0f;
    }

    private static boolean $default$wallInterpolation() {
        return false;
    }

    private static List<NoiseSettings> $default$generators() {
        return Collections.singletonList(DEFAULT_GENERATOR);
    }

    private static Optional<TunnelSettings> $default$branches() {
        return CommonMethods.empty();
    }

    private static boolean $default$deferred() {
        return false;
    }

    CavernSettings(ConditionSettings conditions, DecoratorSettings decorators, int resolution, Optional<NoiseMapSettings> offset, Optional<NoiseMapSettings> walls, Optional<NoiseMapSettings> wallOffset, float wallCurveRatio, boolean wallInterpolation, List<NoiseSettings> generators, Optional<TunnelSettings> branches, boolean deferred) {
        this.conditions = conditions;
        this.decorators = decorators;
        this.resolution = resolution;
        this.offset = offset;
        this.walls = walls;
        this.wallOffset = wallOffset;
        this.wallCurveRatio = wallCurveRatio;
        this.wallInterpolation = wallInterpolation;
        this.generators = generators;
        this.branches = branches;
        this.deferred = deferred;
    }

    public static CavernSettingsBuilder builder() {
        return new CavernSettingsBuilder();
    }

    public static final class Fields {
        public static final String conditions = "conditions";
        public static final String decorators = "decorators";
        public static final String resolution = "resolution";
        public static final String offset = "offset";
        public static final String walls = "walls";
        public static final String wallOffset = "wallOffset";
        public static final String wallCurveRatio = "wallCurveRatio";
        public static final String wallInterpolation = "wallInterpolation";
        public static final String generators = "generators";
        public static final String branches = "branches";
        public static final String deferred = "deferred";

        private Fields() {
        }
    }

    public static class CavernSettingsBuilder {
        private boolean conditions$set;
        private ConditionSettings conditions$value;
        private boolean decorators$set;
        private DecoratorSettings decorators$value;
        private boolean resolution$set;
        private int resolution$value;
        private boolean offset$set;
        private Optional<NoiseMapSettings> offset$value;
        private boolean walls$set;
        private Optional<NoiseMapSettings> walls$value;
        private boolean wallOffset$set;
        private Optional<NoiseMapSettings> wallOffset$value;
        private boolean wallCurveRatio$set;
        private float wallCurveRatio$value;
        private boolean wallInterpolation$set;
        private boolean wallInterpolation$value;
        private boolean generators$set;
        private List<NoiseSettings> generators$value;
        private boolean branches$set;
        private Optional<TunnelSettings> branches$value;
        private boolean deferred$set;
        private boolean deferred$value;

        CavernSettingsBuilder() {
        }

        public CavernSettingsBuilder conditions(ConditionSettings conditions) {
            this.conditions$value = conditions;
            this.conditions$set = true;
            return this;
        }

        public CavernSettingsBuilder decorators(DecoratorSettings decorators) {
            this.decorators$value = decorators;
            this.decorators$set = true;
            return this;
        }

        public CavernSettingsBuilder resolution(int resolution) {
            this.resolution$value = resolution;
            this.resolution$set = true;
            return this;
        }

        public CavernSettingsBuilder offset(Optional<NoiseMapSettings> offset) {
            this.offset$value = offset;
            this.offset$set = true;
            return this;
        }

        public CavernSettingsBuilder walls(Optional<NoiseMapSettings> walls) {
            this.walls$value = walls;
            this.walls$set = true;
            return this;
        }

        public CavernSettingsBuilder wallOffset(Optional<NoiseMapSettings> wallOffset) {
            this.wallOffset$value = wallOffset;
            this.wallOffset$set = true;
            return this;
        }

        public CavernSettingsBuilder wallCurveRatio(float wallCurveRatio) {
            this.wallCurveRatio$value = wallCurveRatio;
            this.wallCurveRatio$set = true;
            return this;
        }

        public CavernSettingsBuilder wallInterpolation(boolean wallInterpolation) {
            this.wallInterpolation$value = wallInterpolation;
            this.wallInterpolation$set = true;
            return this;
        }

        public CavernSettingsBuilder generators(List<NoiseSettings> generators) {
            this.generators$value = generators;
            this.generators$set = true;
            return this;
        }

        public CavernSettingsBuilder branches(Optional<TunnelSettings> branches) {
            this.branches$value = branches;
            this.branches$set = true;
            return this;
        }

        public CavernSettingsBuilder deferred(boolean deferred) {
            this.deferred$value = deferred;
            this.deferred$set = true;
            return this;
        }

        public CavernSettings build() {
            ConditionSettings conditions$value = this.conditions$value;
            if (!this.conditions$set) {
                conditions$value = CavernSettings.$default$conditions();
            }
            DecoratorSettings decorators$value = this.decorators$value;
            if (!this.decorators$set) {
                decorators$value = CavernSettings.$default$decorators();
            }
            int resolution$value = this.resolution$value;
            if (!this.resolution$set) {
                resolution$value = CavernSettings.$default$resolution();
            }
            Optional offset$value = this.offset$value;
            if (!this.offset$set) {
                offset$value = CavernSettings.$default$offset();
            }
            Optional walls$value = this.walls$value;
            if (!this.walls$set) {
                walls$value = CavernSettings.$default$walls();
            }
            Optional wallOffset$value = this.wallOffset$value;
            if (!this.wallOffset$set) {
                wallOffset$value = CavernSettings.$default$wallOffset();
            }
            float wallCurveRatio$value = this.wallCurveRatio$value;
            if (!this.wallCurveRatio$set) {
                wallCurveRatio$value = CavernSettings.$default$wallCurveRatio();
            }
            boolean wallInterpolation$value = this.wallInterpolation$value;
            if (!this.wallInterpolation$set) {
                wallInterpolation$value = CavernSettings.$default$wallInterpolation();
            }
            List generators$value = this.generators$value;
            if (!this.generators$set) {
                generators$value = CavernSettings.$default$generators();
            }
            Optional branches$value = this.branches$value;
            if (!this.branches$set) {
                branches$value = CavernSettings.$default$branches();
            }
            boolean deferred$value = this.deferred$value;
            if (!this.deferred$set) {
                deferred$value = CavernSettings.$default$deferred();
            }
            return new CavernSettings(conditions$value, decorators$value, resolution$value, offset$value, walls$value, wallOffset$value, wallCurveRatio$value, wallInterpolation$value, generators$value, branches$value, deferred$value);
        }

        public String toString() {
            return "CavernSettings.CavernSettingsBuilder(conditions$value=" + this.conditions$value + ", decorators$value=" + this.decorators$value + ", resolution$value=" + this.resolution$value + ", offset$value=" + this.offset$value + ", walls$value=" + this.walls$value + ", wallOffset$value=" + this.wallOffset$value + ", wallCurveRatio$value=" + this.wallCurveRatio$value + ", wallInterpolation$value=" + this.wallInterpolation$value + ", generators$value=" + this.generators$value + ", branches$value=" + this.branches$value + ", deferred$value=" + this.deferred$value + ")";
        }
    }
}

