/*
 * Decompiled with CFR 0.152.
 */
package com.personthecat.cavegenerator.config;

import com.personthecat.cavegenerator.util.CommonMethods;
import java.io.File;
import java.util.regex.Pattern;
import org.hjson.JsonArray;
import org.hjson.JsonObject;
import org.hjson.JsonValue;

public class SyntaxHelper {
    private static final String COMMA_MESSAGE = "Found comma (,) in string. Remove it or use double quotes. e.g. <\"value\",>\nSource: {}";
    private static final String COMMENT_MESSAGE = "Found comment (# or //) in string. Put your comment above this value or use double quotes. e.g. <\"value\" # comment>\nSource: {}";
    private static final String SEMICOLON_MESSAGE = "Found semicolon (;) in string. You need to remove it.\nSource: {}";
    private static final Pattern COMMENT_PATTERN = Pattern.compile("#|//|/\\*");

    public static void check(File file, JsonObject json) {
        for (JsonObject.Member member : json) {
            JsonValue value = member.getValue();
            if (value.isString()) {
                SyntaxHelper.checkString(file, value.asString());
                continue;
            }
            if (value.isObject()) {
                SyntaxHelper.check(file, value.asObject());
                continue;
            }
            if (!value.isArray()) continue;
            SyntaxHelper.checkArray(file, value.asArray());
        }
    }

    private static void checkArray(File file, JsonArray array) {
        for (JsonValue value : array) {
            if (value.isString()) {
                SyntaxHelper.checkString(file, value.asString());
                continue;
            }
            if (value.isObject()) {
                SyntaxHelper.check(file, value.asObject());
                continue;
            }
            if (!value.isArray()) continue;
            SyntaxHelper.checkArray(file, value.asArray());
        }
    }

    private static void checkString(File file, String string) {
        if (string.endsWith(",")) {
            throw CommonMethods.runExF(COMMA_MESSAGE, file.getName());
        }
        if (string.endsWith(";")) {
            throw CommonMethods.runExF(SEMICOLON_MESSAGE, file.getName());
        }
        if (COMMENT_PATTERN.matcher(string).find()) {
            throw CommonMethods.runExF(COMMENT_MESSAGE, file.getName());
        }
    }
}

