/*
 * Decompiled with CFR 0.152.
 */
package com.personthecat.cavegenerator.config;

import com.personthecat.cavegenerator.CaveInit;
import com.personthecat.cavegenerator.config.CavePreset;
import com.personthecat.cavegenerator.config.ConfigFile;
import com.personthecat.cavegenerator.config.PresetCompat;
import com.personthecat.cavegenerator.config.PresetExpander;
import com.personthecat.cavegenerator.config.PresetTester;
import com.personthecat.cavegenerator.config.SyntaxHelper;
import com.personthecat.cavegenerator.io.SafeFileIO;
import com.personthecat.cavegenerator.util.CommonMethods;
import com.personthecat.cavegenerator.util.HjsonTools;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hjson.JsonObject;
import org.hjson.JsonValue;
import org.hjson.ParseException;

public class PresetReader {
    private static final Logger log = LogManager.getLogger(PresetReader.class);
    public static final String INNER_KEY = "inner";

    public static Map<String, CavePreset> getPresets(File dir, File imports) {
        Map<File, JsonObject> jsons = PresetReader.loadJsons(dir);
        Map<File, JsonObject> definitions = PresetReader.loadJsons(imports);
        jsons.forEach(SyntaxHelper::check);
        definitions.forEach(SyntaxHelper::check);
        definitions.forEach((file, json) -> PresetCompat.updateImport(json, file).expectF("Updating import {}", file));
        jsons.forEach((file, json) -> PresetCompat.updatePreset(json, file).expectF("Updating preset {}", file));
        PresetExpander.expandAll(jsons, definitions);
        jsons.forEach((file, json) -> json.setAllAccessed(false));
        Map<String, CavePreset> settings = PresetReader.toSettings(jsons);
        settings.forEach((name, cfg) -> new PresetTester((CavePreset)cfg, (String)name, ConfigFile.strictPresets).run());
        return settings;
    }

    private static Map<File, JsonObject> loadJsons(File dir) {
        HashMap<File, JsonObject> jsons = new HashMap<File, JsonObject>();
        PresetReader.loadInto(jsons, dir);
        return jsons;
    }

    private static void loadInto(Map<File, JsonObject> jsons, File dir) {
        for (File file : SafeFileIO.listFiles(dir).orElse(new File[0])) {
            if (file.isDirectory()) {
                PresetReader.loadInto(jsons, file);
                continue;
            }
            if (!CaveInit.validExtension(file)) continue;
            log.info("Parsing preset file: {}", (Object)file.getName());
            jsons.put(file, PresetReader.loadJson(file).asObject());
        }
    }

    private static Map<String, CavePreset> toSettings(Map<File, JsonObject> jsons) {
        HashMap<String, CavePreset> settings = new HashMap<String, CavePreset>();
        PresetReader.extractInner(jsons).forEach((name, json) -> {
            try {
                settings.put((String)name, CavePreset.from(json));
            }
            catch (RuntimeException e) {
                String msg = CommonMethods.f("Error reading {}: {}", name, e.getMessage());
                if (ConfigFile.ignoreInvalidPresets) {
                    log.error(msg);
                }
                throw CommonMethods.runEx(msg);
            }
        });
        return settings;
    }

    private static Map<String, JsonObject> extractInner(Map<File, JsonObject> jsons) {
        HashMap<String, JsonObject> extracted = new HashMap<String, JsonObject>();
        jsons.forEach((file, json) -> PresetReader.extractRecursive(extracted, CommonMethods.noExtension(file), json));
        return extracted;
    }

    private static void extractRecursive(Map<String, JsonObject> data, String name, JsonObject parent) {
        List<JsonObject> inner = HjsonTools.getRegularObjects(parent, INNER_KEY);
        for (int i = 0; i < inner.size(); ++i) {
            JsonObject child = inner.get(i);
            JsonObject clone = new JsonObject().addAll(parent).remove(INNER_KEY);
            for (JsonObject.Member member : child) {
                clone.set(member.getName(), member.getValue());
            }
            String innerName = CommonMethods.f("{}[{}]", name, i);
            PresetReader.extractRecursive(data, innerName, clone);
        }
        data.put(name, parent);
    }

    public static Optional<JsonObject> getPresetJson(File file) {
        try {
            return CommonMethods.full(PresetReader.loadJson(file).asObject());
        }
        catch (RuntimeException ignored) {
            return CommonMethods.empty();
        }
    }

    private static JsonValue loadJson(File file) {
        try {
            FileReader reader = new FileReader(file);
            String extension = CommonMethods.extension(file);
            if (extension.equals("json")) {
                return JsonObject.readJSON(reader);
            }
            return JsonObject.readHjson(reader);
        }
        catch (IOException ignored) {
            throw CommonMethods.runExF("Unable to load preset file {}", file.getName());
        }
        catch (ParseException e) {
            throw CommonMethods.runEx(CommonMethods.f("Error reading {}", file.getName()), e);
        }
    }
}

