/*
 * Decompiled with CFR 0.152.
 */
package com.personthecat.cavegenerator.config;

import com.personthecat.cavegenerator.config.FieldHistory;
import com.personthecat.cavegenerator.config.ImportHelper;
import com.personthecat.cavegenerator.config.ReferenceHelper;
import com.personthecat.cavegenerator.util.Calculator;
import com.personthecat.cavegenerator.util.CommonMethods;
import com.personthecat.cavegenerator.util.HjsonTools;
import java.io.File;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import org.apache.commons.lang3.ArrayUtils;
import org.hjson.JsonArray;
import org.hjson.JsonObject;
import org.hjson.JsonValue;

public class PresetExpander {
    public static final String IMPORTS = "imports";
    public static final String VARIABLES = "variables";
    public static final String DEFAULTS = "defaults.cave";
    public static final String VANILLA = "VANILLA";
    public static final Pattern MERGE_ALL = Pattern.compile("all", 2);

    public static void expandAll(Map<File, JsonObject> presets, Map<File, JsonObject> definitions) {
        definitions.forEach((f, json) -> PresetExpander.variablesToRoot(json));
        definitions.forEach((f, json) -> {
            if (!json.has(IMPORTS)) {
                PresetExpander.expand(json);
            }
        });
        definitions.forEach((f, json) -> PresetExpander.copyImports(definitions, json, true));
        definitions.forEach((f, json) -> PresetExpander.expand(json));
        definitions.forEach((f, json) -> PresetExpander.stripPrivateValues(definitions, json));
        presets.forEach((f, json) -> PresetExpander.copyImports(definitions, json, false));
        PresetExpander.copyVanilla(presets, definitions);
        presets.forEach((f, json) -> PresetExpander.expandVariables(json));
        presets.forEach((f, json) -> PresetExpander.calculateAll(json));
        presets.forEach((f, json) -> PresetExpander.deleteUnused(json));
    }

    private static void variablesToRoot(JsonObject json) {
        JsonValue variables = json.get(VARIABLES);
        if (variables != null) {
            if (!variables.isObject()) {
                throw CommonMethods.runExF("\"{}\" is reserved for definitions and must be an object.", VARIABLES);
            }
            json.addAll(variables.asObject());
        }
    }

    private static void copyImports(Map<File, JsonObject> definitions, JsonObject json, boolean root) {
        HashSet imports = new HashSet();
        HjsonTools.getArray(json, IMPORTS).ifPresent(arr -> {
            for (JsonValue value : arr) {
                if (!value.isString()) {
                    throw CommonMethods.runExF("Invalid data type in imports: {}", value.toString());
                }
                imports.add(ImportHelper.getRequiredImport(definitions, value.asString()));
            }
        });
        JsonObject variables = root ? json : HjsonTools.getObjectOrNew(json, VARIABLES);
        imports.forEach(variables::addAll);
    }

    private static void expand(JsonObject json) {
        PresetExpander.copyObject(json, json);
        PresetExpander.mergeObject(json, json);
        PresetExpander.overrideObject(json);
    }

    private static void stripPrivateValues(Map<File, JsonObject> definitions, JsonObject json) {
        JsonValue variables;
        JsonValue imports = json.get(IMPORTS);
        if (imports != null) {
            for (String exp : HjsonTools.toStringArray(HjsonTools.asOrToArray(imports))) {
                for (String key : ImportHelper.getKeys(definitions, exp)) {
                    json.remove(key);
                    json.remove(key + "()");
                }
            }
            json.remove(IMPORTS);
        }
        if ((variables = json.get(VARIABLES)) != null) {
            if (!variables.isObject()) {
                throw CommonMethods.runEx("<variables> must be an object");
            }
            for (JsonObject.Member variable : variables.asObject()) {
                json.remove(variable.getName());
                json.remove(variable.getName() + "()");
            }
            json.remove(VARIABLES);
        }
    }

    private static void copyVanilla(Map<File, JsonObject> presets, Map<File, JsonObject> definitions) {
        JsonObject vanilla = PresetExpander.getDefaults(definitions).orElseThrow(() -> CommonMethods.runEx("defaults.cave may not be renamed or deleted."));
        for (JsonObject json : presets.values()) {
            JsonObject variables = HjsonTools.getObjectOrNew(json, VARIABLES);
            if (variables.has(VANILLA)) continue;
            variables.add(VANILLA, vanilla);
        }
    }

    private static Optional<JsonObject> getDefaults(Map<File, JsonObject> definitions) {
        for (Map.Entry<File, JsonObject> entry : definitions.entrySet()) {
            if (!entry.getKey().getName().equals(DEFAULTS)) continue;
            return CommonMethods.full(entry.getValue());
        }
        return CommonMethods.empty();
    }

    private static void expandVariables(JsonObject json) {
        JsonObject variables = HjsonTools.getObject(json, VARIABLES).orElseThrow(() -> CommonMethods.runEx("Nothing to expand."));
        PresetExpander.expand(variables);
        PresetExpander.copyObject(variables, json);
        PresetExpander.mergeObject(variables, json);
        PresetExpander.overrideObject(json);
    }

    private static void copyObject(JsonObject from, JsonObject to) {
        JsonObject clone = new JsonObject();
        for (JsonObject.Member member : to) {
            String name = member.getName();
            JsonValue value = member.getValue();
            clone.add(name, value);
            if (value.isString()) {
                ReferenceHelper.trySubstitute(from, value.asString()).ifPresent(val -> clone.set(name, (JsonValue)val));
                continue;
            }
            if (value.isArray()) {
                PresetExpander.copyArray(from, value.asArray());
                continue;
            }
            if (!value.isObject()) continue;
            PresetExpander.copyObject(from, value.asObject());
        }
        PresetExpander.replaceContents(clone, to);
    }

    private static void copyArray(JsonObject from, JsonArray to) {
        JsonArray clone = new JsonArray();
        for (int i = 0; i < to.size(); ++i) {
            JsonValue value = to.get(i);
            clone.add(value);
            if (value.isString()) {
                Optional<JsonValue> variable = ReferenceHelper.trySubstitute(from, value.asString());
                if (!variable.isPresent()) continue;
                clone.set(i, variable.get());
                continue;
            }
            if (value.isArray()) {
                PresetExpander.copyArray(from, value.asArray());
                continue;
            }
            if (!value.isObject()) continue;
            PresetExpander.copyObject(from, value.asObject());
        }
        PresetExpander.replaceContents(clone, to);
    }

    private static void mergeObject(JsonObject from, JsonObject to) {
        JsonObject clone = new JsonObject();
        for (JsonObject.Member member : to) {
            String name = member.getName();
            JsonValue value = member.getValue();
            clone.add(name, value);
            if (PresetExpander.tryMerge(from, clone, name, value)) continue;
            if (value.isObject()) {
                PresetExpander.mergeObject(from, value.asObject());
                continue;
            }
            if (!value.isArray()) continue;
            PresetExpander.mergeArray(from, value.asArray());
        }
        PresetExpander.replaceContents(clone, to);
    }

    private static void mergeArray(JsonObject from, JsonArray to) {
        for (JsonValue value : to) {
            if (value.isObject()) {
                PresetExpander.mergeObject(from, value.asObject());
                continue;
            }
            if (!value.isArray()) continue;
            PresetExpander.mergeArray(from, value.asArray());
        }
    }

    private static void overrideObject(JsonObject json) {
        JsonObject clone = new JsonObject();
        for (JsonObject.Member member : json) {
            String name = member.getName();
            JsonValue value = member.getValue();
            if (name.startsWith("*")) {
                String[] path = name.substring(1).split(Pattern.quote("."));
                String recursiveKey = path[0];
                if (path.length == 1) {
                    PresetExpander.forEachParent(json, recursiveKey, (JsonObject o) -> o.set(recursiveKey, value));
                } else {
                    FieldHistory.recursive(recursiveKey).forEach(json, o -> FieldHistory.withPath((String[])ArrayUtils.subarray((Object[])path, (int)1, (int)(path.length - 1))).forEach((JsonObject)o, c -> c.set(path[path.length - 1], value)));
                }
            } else {
                clone.add(name, value);
            }
            if (value.isObject()) {
                PresetExpander.overrideObject(value.asObject());
                continue;
            }
            if (!value.isArray()) continue;
            PresetExpander.overrideArray(value.asArray());
        }
        PresetExpander.replaceContents(clone, json);
    }

    private static void overrideArray(JsonArray json) {
        for (JsonValue value : json) {
            if (value.isObject()) {
                PresetExpander.overrideObject(value.asObject());
                continue;
            }
            if (!value.isArray()) continue;
            PresetExpander.overrideArray(value.asArray());
        }
    }

    private static void forEachParent(JsonObject json, String key, Consumer<JsonObject> fn) {
        for (JsonObject.Member member : json) {
            String name = member.getName();
            JsonValue value = member.getValue();
            if (name.equals(key)) {
                fn.accept(json);
                continue;
            }
            if (value.isObject()) {
                PresetExpander.forEachParent(value.asObject(), key, fn);
                continue;
            }
            if (!value.isArray()) continue;
            PresetExpander.forEachParent(value.asArray(), key, fn);
        }
    }

    private static void forEachParent(JsonArray json, String key, Consumer<JsonObject> fn) {
        for (JsonValue value : json) {
            if (value.isObject()) {
                PresetExpander.forEachParent(value.asObject(), key, fn);
                continue;
            }
            if (!value.isArray()) continue;
            PresetExpander.forEachParent(value.asArray(), key, fn);
        }
    }

    private static boolean tryMerge(JsonObject from, JsonObject to, String key, JsonValue value) {
        Optional<JsonValue> r = ReferenceHelper.trySubstitute(from, key);
        r.ifPresent(ref -> {
            if (!ref.isObject()) {
                throw CommonMethods.runExF("Only objects can be merged: {}", key);
            }
            if (value.isString() && MERGE_ALL.matcher(value.asString()).matches()) {
                to.addAll(ref.asObject());
            } else {
                PresetExpander.addAllReferences(ref.asObject(), to, HjsonTools.asOrToArray(value));
            }
            to.remove(key);
        });
        return r.isPresent();
    }

    private static void addAllReferences(JsonObject from, JsonObject to, JsonArray array) {
        for (JsonValue v : array) {
            if (!v.isString()) {
                throw CommonMethods.runExF("Not a field: {}", v);
            }
            String key = v.asString();
            HjsonTools.setOrAdd(to, key, ReferenceHelper.readValue(from, key));
        }
    }

    public static void calculateAll(JsonObject json) {
        JsonObject clone = new JsonObject();
        for (JsonObject.Member member : json) {
            String name = member.getName();
            JsonValue value = member.getValue();
            if (value.isString()) {
                String exp = value.asString();
                if (Calculator.isExpression(exp)) {
                    clone.add(name, Calculator.evaluate(value.asString()));
                    continue;
                }
            } else if (value.isObject()) {
                PresetExpander.calculateAll(value.asObject());
            } else if (value.isArray()) {
                PresetExpander.calculateAll(value.asArray());
            }
            clone.add(name, value);
        }
        PresetExpander.replaceContents(clone, json);
    }

    public static void calculateAll(JsonArray json) {
        JsonArray clone = new JsonArray();
        for (JsonValue value : json) {
            if (value.isString()) {
                String exp = value.asString();
                if (Calculator.isExpression(exp)) {
                    clone.add(Calculator.evaluate(value.asString()));
                    continue;
                }
            } else if (value.isObject()) {
                PresetExpander.calculateAll(value.asObject());
            } else if (value.isArray()) {
                PresetExpander.calculateAll(value.asArray());
            }
            clone.add(value);
        }
        PresetExpander.replaceContents(clone, json);
    }

    private static void replaceContents(JsonObject from, JsonObject to) {
        to.clear();
        to.addAll(from);
    }

    private static void replaceContents(JsonArray from, JsonArray to) {
        to.clear();
        to.addAll(from);
    }

    private static void deleteUnused(JsonObject json) {
        json.remove(IMPORTS);
        json.remove(VARIABLES);
    }
}

