/*
 * Decompiled with CFR 0.152.
 */
package com.personthecat.cavegenerator.config;

import com.google.common.collect.ImmutableMap;
import com.personthecat.cavegenerator.config.ConfigFile;
import com.personthecat.cavegenerator.config.FieldHistory;
import com.personthecat.cavegenerator.data.RoomSettings;
import com.personthecat.cavegenerator.data.StalactiteSettings;
import com.personthecat.cavegenerator.data.WallDecoratorSettings;
import com.personthecat.cavegenerator.io.JarFiles;
import com.personthecat.cavegenerator.util.HjsonTools;
import com.personthecat.cavegenerator.util.Result;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hjson.JsonArray;
import org.hjson.JsonObject;
import org.hjson.JsonValue;

class PresetCompat {
    private static final Logger log = LogManager.getLogger(PresetCompat.class);
    private static final String CG_1_0 = "1.0";
    private static final String MIN_HEIGHT = "minHeight";
    private static final String MAX_HEIGHT = "maxHeight";
    private static final String MIN_LENGTH = "minLength";
    private static final String MAX_LENGTH = "maxLength";
    private static final String MIN_VAL = "minVal";
    private static final String MAX_VAL = "maxVal";
    private static final String NOISE_2D = "noise2D";
    private static final String NOISE_3D = "noise3D";
    private static final String WALL_NOISE = "wallNoise";
    private static final String ISOLATED_CHANCE = "isolatedChance";
    private static final String SCALE = "scale";
    private static final String SCALE_Y = "scaleY";
    private static final String USE_BIOME_BLACKLIST = "useBiomeBlacklist";
    private static final String USE_DIMENSION_BLACKLIST = "useDimensionBlacklist";
    private static final String ANGLE_XZ = "angleXZ";
    private static final String ANGLE_Y = "angleY";
    private static final String TWIST_XZ = "twistXZ";
    private static final String TWIST_Y = "twistY";
    private static final String LARGE_STALACTITES = "largeStalactites";
    private static final String LARGE_STALAGMITES = "largeStalagmites";
    private static final String STONE_CLUSTERS = "stoneClusters";
    private static final String PREFERENCE = "preference";
    private static final String REPLACE_MATCH = "replace_match";
    private static final String REPLACE_ORIGINAL = "replace_original";
    private static final String STONE_LAYERS = "stoneLayers";
    private static final String GIANT_PILLARS = "giantPillars";
    private static final String AIR_MATCHERS = "airMatchers";
    private static final String SOLID_MATCHERS = "solidMatchers";
    private static final String NON_SOLID_MATCHERS = "nonSolidMatchers";
    private static final String WATER_MATCHERS = "waterMatchers";
    private static final String ROOM_CHANCE = "roomChance";
    private static final String FREQUENCY = "frequency";
    private static final String ENABLED = "enabled";
    private static final String BLANK_SLATE = "blankSlate";
    private static final String RADIUS_VARIANCE = "radiusVariance";
    private static final String START_HEIGHT = "startHeight";
    private static final String HEIGHT_VARIANCE = "heightVariance";
    private static final String WIDE = "wide";
    private static final String CHANCE = "chance";
    private static final String IMPORTS = "imports";
    private static final String VARIABLES = "variables";
    private static final String VANILLA = "VANILLA";
    private static final String REPLACE_DIRT_STONE = "REPLACE_DIRT_STONE";
    private static final String VANILLA_ROOM = "VANILLA_ROOM";
    private static final String LAVA_CAVE_BLOCK = "LAVA_CAVE_BLOCK";
    private static final String VANILLA_TUNNELS = "VANILLA_TUNNELS";
    private static final String VANILLA_RAVINES = "VANILLA_RAVINES";
    private static final Pattern DEFAULT_IMPORT = Pattern.compile("defaults.cave\\s*::\\s*(\\w+)");
    private static final Map<String, String> IMPORT_FIELD_MAP = ImmutableMap.builder().put((Object)"REPLACE_DIRT_STONE", (Object)"replaceableBlocks").put((Object)"VANILLA_ROOM", (Object)"rooms").put((Object)"LAVA_CAVE_BLOCK", (Object)"caveBlocks").put((Object)"VANILLA_TUNNELS", (Object)"tunnels").put((Object)"VANILLA_RAVINES", (Object)"ravines").build();

    PresetCompat() {
    }

    static Result<IOException> updatePreset(JsonObject json, File file) {
        int hash = json.hashCode();
        PresetCompat.updateRegularValues(json);
        PresetCompat.enforceValueOrder(json);
        return ConfigFile.autoFormat || json.hashCode() != hash ? HjsonTools.writeJson(json, file) : Result.ok();
    }

    static Result<IOException> updateImport(JsonObject json, File file) {
        int hash = json.hashCode();
        if (file.getName().equals("defaults.cave") && json.has(VANILLA)) {
            PresetCompat.updateDefaults(json);
        } else if (ConfigFile.updateImports) {
            PresetCompat.updateRegularValues(json);
        }
        return ConfigFile.autoFormat || json.hashCode() != hash ? HjsonTools.writeJson(json, file) : Result.ok();
    }

    private static void updateRegularValues(JsonObject json) {
        PresetCompat.updateInner(json);
        PresetCompat.updateRoot(json);
        PresetCompat.updateImports(json);
        PresetCompat.updateCaveBlocks(json);
        PresetCompat.updateWallDecorators(json);
        PresetCompat.updateRooms(json);
        PresetCompat.updateTunnels(json);
        PresetCompat.updateRavines(json);
        PresetCompat.updateCaverns(json);
        PresetCompat.updateClusters(json);
        PresetCompat.updateLayers(json);
        PresetCompat.updateStalactites(json);
        PresetCompat.updatePillars(json);
        PresetCompat.updateStructures(json);
        PresetCompat.updateRecursive(json);
        PresetCompat.removeBlankSlate(json);
    }

    private static void updateDefaults(JsonObject json) {
        json.remove(VANILLA).remove(REPLACE_DIRT_STONE).remove(VANILLA_ROOM).remove(LAVA_CAVE_BLOCK).remove(VANILLA_RAVINES).remove(VANILLA_TUNNELS).addAll(JarFiles.getDefaults());
    }

    private static void updateInner(JsonObject json) {
        for (JsonObject inner : HjsonTools.getRegularObjects(json, "inner")) {
            PresetCompat.updateRegularValues(inner);
        }
    }

    private static void updateRoot(JsonObject json) {
        FieldHistory.withPath(new String[0]).toRange(MIN_HEIGHT, 0, MAX_HEIGHT, 255, "height").history(USE_BIOME_BLACKLIST, "blacklistBiomes").history(USE_DIMENSION_BLACKLIST, "blacklistDimensions").history(STONE_CLUSTERS, "clusters").history(STONE_LAYERS, "layers").history(GIANT_PILLARS, "pillars").updateAll(json);
    }

    private static void updateImports(JsonObject json) {
        JsonValue rawImports = json.get(IMPORTS);
        if (rawImports != null) {
            JsonArray imports = HjsonTools.asOrToArray(rawImports);
            JsonArray clone = new JsonArray();
            for (JsonValue value : imports) {
                clone.add(PresetCompat.replaceImportVal(value.asString()));
            }
            if (rawImports.isArray()) {
                json.set(IMPORTS, clone.setCondensed(imports.isCondensed()));
            } else {
                json.set(IMPORTS, clone.get(0));
            }
        }
    }

    private static String replaceImportVal(String val) {
        String name;
        Matcher matcher = DEFAULT_IMPORT.matcher(val);
        if (matcher.matches() && IMPORT_FIELD_MAP.containsKey(name = matcher.group(1))) {
            return "defaults.cave::" + IMPORT_FIELD_MAP.get(name) + " as " + name;
        }
        return val;
    }

    private static void updateCaveBlocks(JsonObject json) {
        FieldHistory.withPath("caveBlocks").toRange(MIN_HEIGHT, 0, MAX_HEIGHT, 50, "height").history(NOISE_3D, "noise").history(CHANCE, "integrity").updateAll(json);
    }

    private static void updateWallDecorators(JsonObject json) {
        FieldHistory.withPath("wallDecorators").toRange(MIN_HEIGHT, 10, MAX_HEIGHT, 50, "height").history(NOISE_3D, "noise").history(CHANCE, "integrity").updateAll(json);
    }

    private static void updateRooms(JsonObject json) {
        FieldHistory.withPath("rooms").history(SCALE_Y, "stretch").updateAll(json);
        PresetCompat.updateRoomChance(json);
    }

    private static void updateTunnels(JsonObject json) {
        FieldHistory.withPath("tunnels").toRange(MIN_HEIGHT, 8, MAX_HEIGHT, 128, "originHeight").history(ISOLATED_CHANCE, CHANCE).history(FREQUENCY, "count").history(ANGLE_XZ, "yaw").history(ANGLE_Y, "pitch").history(TWIST_XZ, "dYaw").history(TWIST_Y, "dPitch").history(SCALE_Y, "stretch").updateAll(json);
    }

    private static void updateRavines(JsonObject json) {
        FieldHistory.withPath("ravines").toRange(MIN_HEIGHT, 20, MAX_HEIGHT, 66, "originHeight").history(ANGLE_XZ, "yaw").history(ANGLE_Y, "pitch").history(TWIST_XZ, "dYaw").history(TWIST_Y, "dPitch").history(SCALE_Y, "stretch").history(WALL_NOISE, "walls").collapse("walls", NOISE_2D).updateAll(json);
        FieldHistory.withPath("ravines", "walls").toRange(MIN_VAL, 0.0, MAX_VAL, 4.0, "range").markRemoved(SCALE, CG_1_0).updateAll(json);
    }

    private static void updateCaverns(JsonObject json) {
        FieldHistory.withPath("caverns").toRange(MIN_HEIGHT, 10, MAX_HEIGHT, 50, "height").history(NOISE_3D, "generators").collapse("ceiling", NOISE_2D).collapse("floor", NOISE_2D).markRemoved(ENABLED, CG_1_0).updateAll(json);
        FieldHistory.withPath("caverns", "ceiling").toRange(MIN_VAL, -17.0, MAX_VAL, -3.0, "range").updateAll(json);
        FieldHistory.withPath("caverns", "floor").toRange(MIN_VAL, 0.0, MAX_VAL, 8.0, "range").updateAll(json);
        FieldHistory.withPath("caverns", "generators").transform(SCALE, PresetCompat::transformScale).history(SCALE_Y, "stretch").updateAll(json);
    }

    private static void updateClusters(JsonObject json) {
        FieldHistory.withPath("clusters").history(NOISE_3D, "noise").updateAll(json);
        PresetCompat.updateClusterRanges(json);
    }

    private static void updateLayers(JsonObject json) {
        FieldHistory.withPath("layers").toRange(MIN_HEIGHT, 0, MAX_HEIGHT, 20, "height").history(NOISE_2D, "ceiling").updateAll(json);
        FieldHistory.withPath("layers", "ceiling").toRange(MIN_VAL, -7.0, MAX_VAL, 7.0, "range").updateAll(json);
    }

    private static void updateStalactites(JsonObject json) {
        PresetCompat.condenseStalactites(json);
        FieldHistory.withPath("stalactites").toRange(MIN_HEIGHT, 11, MAX_HEIGHT, 55, "height").toRange(MIN_LENGTH, 1, MAX_LENGTH, 3, "length").history(NOISE_2D, "region").transform(WIDE, PresetCompat::transformSize).updateAll(json);
    }

    private static void updatePillars(JsonObject json) {
        FieldHistory.withPath("pillars").history(FREQUENCY, "count").toRange(MIN_HEIGHT, 10, MAX_HEIGHT, 50, "height").toRange(MIN_LENGTH, 4, MAX_LENGTH, 12, "length").updateAll(json);
    }

    private static void updateStructures(JsonObject json) {
        FieldHistory.withPath("structures").toRange(MIN_HEIGHT, 10, MAX_HEIGHT, 50, "height").history(FREQUENCY, "count").history(AIR_MATCHERS, "airChecks").history(SOLID_MATCHERS, "solidChecks").history(NON_SOLID_MATCHERS, "nonSolidChecks").history(WATER_MATCHERS, "waterChecks").updateAll(json);
    }

    private static void updateRecursive(JsonObject json) {
        FieldHistory.recursive("ceiling").markRemoved(SCALE, CG_1_0).markRemoved("threshold", CG_1_0).updateAll(json);
        FieldHistory.recursive("floor").markRemoved(SCALE, CG_1_0).markRemoved("threshold", CG_1_0).updateAll(json);
        FieldHistory.recursive("noise").transform(SCALE, PresetCompat::transformScale).updateAll(json);
        FieldHistory.recursive("region").transform(SCALE, PresetCompat::transformScale).markRemoved(MIN_VAL, CG_1_0).markRemoved(MAX_VAL, CG_1_0).markRemoved("range", CG_1_0).updateAll(json);
        FieldHistory.recursive("wallDecorators").history(PREFERENCE, "placement").renameValue("placement", REPLACE_MATCH, WallDecoratorSettings.Placement.EMBED.name()).renameValue("placement", REPLACE_ORIGINAL, WallDecoratorSettings.Placement.OVERLAY.name()).updateAll(json);
    }

    private static void condenseStalactites(JsonObject json) {
        List<JsonObject> largeStalactites = HjsonTools.getRegularObjects(json, LARGE_STALACTITES);
        List<JsonObject> largeStalagmites = HjsonTools.getRegularObjects(json, LARGE_STALAGMITES);
        if (!largeStalactites.isEmpty() || !largeStalagmites.isEmpty()) {
            JsonArray stalactites = HjsonTools.getArrayOrNew(json, "stalactites");
            for (JsonObject stalactite : largeStalactites) {
                stalactite.set("type", StalactiteSettings.Type.STALACTITE.name());
                stalactites.add(stalactite);
            }
            for (JsonObject stalagmite : largeStalagmites) {
                stalagmite.set("type", StalactiteSettings.Type.STALAGMITE.name());
                stalactites.add(stalagmite);
            }
            json.set("stalactites", stalactites);
            json.remove(LARGE_STALACTITES);
            json.remove(LARGE_STALAGMITES);
        }
    }

    private static void updateRoomChance(JsonObject json) {
        List<JsonObject> tunnels = HjsonTools.getRegularObjects(json, "tunnels");
        JsonObject rooms = HjsonTools.getObject(json, "rooms").orElseGet(PresetCompat::getDefaultRooms);
        boolean updated = false;
        for (JsonObject tunnel : tunnels) {
            JsonValue roomChance = tunnel.get(ROOM_CHANCE);
            if (roomChance == null) continue;
            JsonObject tunnelRooms = HjsonTools.getObject(tunnel, "rooms").orElseGet(() -> new JsonObject().addAll(rooms)).set(CHANCE, roomChance);
            tunnel.set("rooms", tunnelRooms);
            tunnel.remove(ROOM_CHANCE);
            updated = true;
        }
        if (updated) {
            PresetCompat.moveRoomsFromOverrides(json, rooms, tunnels);
        }
    }

    private static void moveRoomsFromOverrides(JsonObject json, JsonObject rooms, List<JsonObject> tunnels) {
        for (JsonObject tunnel : tunnels) {
            if (tunnel.has("rooms")) continue;
            tunnel.add("rooms", rooms);
        }
        json.remove("rooms");
    }

    private static JsonObject getDefaultRooms() {
        RoomSettings settings = RoomSettings.builder().build();
        return new JsonObject().add(SCALE, settings.scale).add("stretch", settings.stretch);
    }

    private static void updateClusterRanges(JsonObject json) {
        for (JsonObject cluster : HjsonTools.getRegularObjects(json, "clusters")) {
            JsonValue radiusVariance = cluster.get(RADIUS_VARIANCE);
            if (radiusVariance != null) {
                PresetCompat.updateClusterRadii(cluster, radiusVariance.asInt() / 2);
            }
            if (!cluster.has(START_HEIGHT) && !cluster.has(HEIGHT_VARIANCE)) continue;
            int center = HjsonTools.getIntOr(cluster, START_HEIGHT, 32);
            int variance = HjsonTools.getIntOr(cluster, HEIGHT_VARIANCE, 16);
            PresetCompat.updateClusterCenter(cluster, center, variance / 2);
        }
    }

    private static void updateClusterRadii(JsonObject cluster, int diff) {
        String radiusXKey = "radiusX";
        String radiusYKey = "radiusY";
        String radiusZKey = "radiusZ";
        int radX = HjsonTools.getIntOr(cluster, "radiusX", 16);
        int radY = HjsonTools.getIntOr(cluster, "radiusY", 12);
        int radZ = HjsonTools.getIntOr(cluster, "radiusZ", 16);
        cluster.set("radiusX", new JsonArray().add(radX - diff).add(radX + diff).setCondensed(true)).set("radiusY", new JsonArray().add(radY - diff).add(radY + diff).setCondensed(true)).set("radiusZ", new JsonArray().add(radZ - diff).add(radZ + diff).setCondensed(true));
        cluster.remove(RADIUS_VARIANCE);
    }

    private static void updateClusterCenter(JsonObject cluster, int center, int diff) {
        String centerKey = "centerHeight";
        cluster.set("centerHeight", new JsonArray().add(center - diff).add(center + diff).setCondensed(true));
        cluster.remove(START_HEIGHT);
        cluster.remove(HEIGHT_VARIANCE);
    }

    private static Pair<String, JsonValue> transformScale(String name, JsonValue value) {
        double scale = value.asDouble();
        double threshold = 2.0 * scale - 1.0;
        return Pair.of((Object)"threshold", (Object)JsonValue.valueOf(threshold));
    }

    private static Pair<String, JsonValue> transformSize(String name, JsonValue value) {
        String size = value.isBoolean() && value.asBoolean() ? StalactiteSettings.Size.MEDIUM.name() : StalactiteSettings.Size.SMALL.name();
        return Pair.of((Object)"size", (Object)JsonValue.valueOf(size));
    }

    private static void removeBlankSlate(JsonObject json) {
        JsonValue blankSlate = json.get(BLANK_SLATE);
        if (blankSlate != null) {
            if (!blankSlate.asBoolean()) {
                JsonValue all = JsonValue.valueOf("ALL").setEOLComment("Default ravines and lava settings.");
                HjsonTools.setOrAdd(json, "$VANILLA", all);
            }
            json.remove(BLANK_SLATE);
        }
    }

    private static void enforceValueOrder(JsonObject json) {
        JsonObject top = new JsonObject();
        JsonObject bottom = new JsonObject();
        PresetCompat.moveValue(IMPORTS, json, top);
        PresetCompat.moveValue(VARIABLES, json, top);
        for (JsonObject.Member member : json) {
            if (member.getName().startsWith("$")) {
                top.add(member.getName(), member.getValue());
                continue;
            }
            bottom.add(member.getName(), member.getValue());
        }
        json.clear();
        json.addAll(top);
        json.addAll(bottom);
    }

    private static void moveValue(String field, JsonObject from, JsonObject to) {
        if (from.has(field)) {
            to.add(field, from.get(field));
            from.remove(field);
        }
    }
}

