/*
 * Decompiled with CFR 0.152.
 */
package wile.engineersdecor.blocks;

import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import wile.engineersdecor.ModEngineersDecor;
import wile.engineersdecor.blocks.BlockDecorDirectedHorizontal;

public class BlockDecorMineralSmelter
extends BlockDecorDirectedHorizontal {
    public static final int PHASE_MAX = 3;
    public static final PropertyInteger PHASE = PropertyInteger.func_177719_a((String)"phase", (int)0, (int)3);

    public BlockDecorMineralSmelter(@Nonnull String registryName, long config, @Nullable Material material, float hardness, float resistance, @Nullable SoundType sound, @Nonnull AxisAlignedBB unrotatedAABB) {
        super(registryName, config, material, hardness, resistance, sound, unrotatedAABB);
        this.func_149713_g(0);
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, PHASE});
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        return super.func_176203_a(meta).func_177226_a((IProperty)PHASE, (Comparable)Integer.valueOf(meta >> 2 & 3));
    }

    @Override
    public int func_176201_c(IBlockState state) {
        return super.func_176201_c(state) | (Integer)state.func_177229_b((IProperty)PHASE) << 2;
    }

    @Override
    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return super.getStateForPlacement(world, pos, facing, hitX, hitY, hitZ, meta, placer, hand).func_177226_a((IProperty)PHASE, (Comparable)Integer.valueOf(0));
    }

    @Override
    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.SOLID;
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState state, World world, BlockPos pos) {
        return MathHelper.func_76125_a((int)((Integer)state.func_177229_b((IProperty)PHASE) * 5), (int)0, (int)15);
    }

    @Override
    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new BTileEntity();
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        if (world.field_72995_K) {
            return true;
        }
        BTileEntity te = this.getTe(world, pos);
        if (te == null) {
            return super.removedByPlayer(state, world, pos, player, willHarvest);
        }
        ItemStack st = ItemStack.field_190927_a;
        if (!te.func_70301_a(1).func_190926_b()) {
            st = te.func_70301_a(1).func_77946_l();
        } else if (!te.func_70301_a(0).func_190926_b()) {
            st = te.func_70301_a(0).func_77946_l();
        }
        te.reset_process();
        ItemStack stack = new ItemStack((Block)this, 1);
        world.func_72838_d((Entity)new EntityItem(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, stack));
        world.func_175698_g(pos);
        world.func_175713_t(pos);
        if (!st.func_190926_b()) {
            st.func_190920_e(1);
            world.func_72838_d((Entity)new EntityItem(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, st));
        }
        return false;
    }

    public void onBlockExploded(World world, BlockPos pos, Explosion explosion) {
        if (world.field_72995_K) {
            return;
        }
        BTileEntity te = this.getTe(world, pos);
        if (te == null) {
            return;
        }
        te.reset_process();
        super.onBlockExploded(world, pos, explosion);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        if (player.func_70093_af()) {
            return false;
        }
        BTileEntity te = this.getTe(world, pos);
        if (te == null) {
            return true;
        }
        ItemStack stack = player.func_184586_b(hand);
        boolean dirty = false;
        if (te.accepts_lava_container(stack)) {
            if (stack.func_185136_b(BTileEntity.BUCKET_STACK) && te.fluid_level() >= 900) {
                if (stack.func_190916_E() > 1) {
                    int target_stack_index = -1;
                    for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                        if (!player.field_71071_by.func_70301_a(i).func_190926_b()) continue;
                        target_stack_index = i;
                        break;
                    }
                    if (target_stack_index >= 0) {
                        te.reset_process();
                        stack.func_190918_g(1);
                        player.func_184611_a(hand, stack);
                        player.field_71071_by.func_70299_a(target_stack_index, BTileEntity.LAVA_BUCKET_STACK.func_77946_l());
                        world.func_184133_a(null, pos, SoundEvents.field_187633_N, SoundCategory.BLOCKS, 1.0f, 1.0f);
                        dirty = true;
                    }
                } else {
                    te.reset_process();
                    player.func_184611_a(hand, BTileEntity.LAVA_BUCKET_STACK.func_77946_l());
                    world.func_184133_a(null, pos, SoundEvents.field_187633_N, SoundCategory.BLOCKS, 1.0f, 1.0f);
                    dirty = true;
                }
            }
        } else if (stack.func_77973_b() == Items.field_190931_a) {
            ItemStack istack = te.func_70301_a(1).func_77946_l();
            if (te.phase() > 0) {
                player.func_70015_d(1);
            }
            if (!istack.func_190926_b()) {
                istack.func_190920_e(1);
                player.func_184611_a(hand, istack);
                te.reset_process();
                dirty = true;
            }
        } else if (te.insert(stack.func_77946_l(), false)) {
            stack.func_190918_g(1);
            dirty = true;
        }
        if (dirty) {
            player.field_71071_by.func_70296_d();
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rnd) {
        if (state.func_177230_c() != this) {
            return;
        }
        EnumParticleTypes particle = EnumParticleTypes.SMOKE_NORMAL;
        switch ((Integer)state.func_177229_b((IProperty)PHASE)) {
            case 0: {
                return;
            }
            case 1: {
                if (rnd.nextInt(10) <= 4) break;
                return;
            }
            case 2: {
                if (rnd.nextInt(10) > 7) {
                    return;
                }
                particle = EnumParticleTypes.SMOKE_LARGE;
                break;
            }
            case 3: {
                if (rnd.nextInt(10) > 2) {
                    return;
                }
                particle = EnumParticleTypes.LAVA;
                break;
            }
            default: {
                return;
            }
        }
        double x = 0.5 + (double)pos.func_177958_n();
        double y = 0.5 + (double)pos.func_177956_o();
        double z = 0.5 + (double)pos.func_177952_p();
        double xr = rnd.nextDouble() * 0.4 - 0.2;
        double yr = rnd.nextDouble() * 0.5;
        double zr = rnd.nextDouble() * 0.4 - 0.2;
        world.func_175688_a(particle, x + xr, y + yr, z + zr, 0.0, 0.0, 0.0, new int[0]);
    }

    @Nullable
    private BTileEntity getTe(World world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        return !(te instanceof BTileEntity) ? null : (BTileEntity)te;
    }

    public static class BTileEntity
    extends TileEntity
    implements ITickable,
    ISidedInventory,
    IEnergyStorage {
        public static final int TICK_INTERVAL = 20;
        public static final int MAX_FLUID_LEVEL = 1000;
        public static final int MAX_BUCKET_EXTRACT_FLUID_LEVEL = 900;
        public static final int MAX_ENERGY_BUFFER = 32000;
        public static final int MAX_ENERGY_TRANSFER = 8192;
        public static final int DEFAULT_ENERGY_CONSUMPTION = 92;
        public static final int DEFAULT_HEATUP_RATE = 2;
        public static final int PHASE_WARMUP = 0;
        public static final int PHASE_HOT = 1;
        public static final int PHASE_MAGMABLOCK = 2;
        public static final int PHASE_LAVA = 3;
        private static final ItemStack MAGMA_STACK = new ItemStack(Blocks.field_189877_df);
        private static final ItemStack BUCKET_STACK = new ItemStack(Items.field_151133_ar);
        private static final ItemStack LAVA_BUCKET_STACK = new ItemStack(Items.field_151129_at);
        private static int energy_consumption = 92;
        private static int heatup_rate = 2;
        private static int cooldown_rate = 1;
        private static Set<Item> accepted_minerals = new HashSet<Item>();
        private static Set<Item> accepted_lava_contrainers = new HashSet<Item>();
        private int tick_timer_;
        private int energy_stored_;
        private int progress_;
        private int fluid_level_;
        private boolean force_block_update_;
        private NonNullList<ItemStack> stacks_ = NonNullList.func_191197_a((int)2, (Object)ItemStack.field_190927_a);
        private static final int[] SIDED_INV_SLOTS;
        private BItemHandler item_handler_ = new BItemHandler(this);
        private final BFluidHandler fluid_handler_ = new BFluidHandler(this);

        public static void on_config(int energy_consumption, int heatup_per_second) {
            energy_consumption = MathHelper.func_76125_a((int)energy_consumption, (int)32, (int)4096);
            heatup_rate = MathHelper.func_76125_a((int)heatup_per_second, (int)1, (int)5);
            cooldown_rate = MathHelper.func_76125_a((int)(heatup_per_second / 2), (int)1, (int)5);
            ModEngineersDecor.logger.info("Config mineal smelter energy consumption:" + energy_consumption + "rf/t, heat-up rate: " + heatup_rate + "%/s.");
        }

        public BTileEntity() {
            this.reset_process();
        }

        public int progress() {
            return this.progress_;
        }

        public int phase() {
            if (this.progress_ >= 100) {
                return 3;
            }
            if (this.progress_ >= 90) {
                return 2;
            }
            if (this.progress_ >= 5) {
                return 1;
            }
            return 0;
        }

        public int fluid_level() {
            return this.fluid_level_;
        }

        public int fluid_level_drain(int amount) {
            amount = MathHelper.func_76125_a((int)amount, (int)0, (int)this.fluid_level_);
            this.fluid_level_ -= amount;
            return amount;
        }

        public int comparator_signal() {
            return this.phase() * 5;
        }

        private boolean accepts_lava_container(ItemStack stack) {
            return accepted_lava_contrainers.contains(stack.func_77973_b());
        }

        private boolean accepts_input(ItemStack stack) {
            if (!((ItemStack)this.stacks_.get(0)).func_190926_b()) {
                return false;
            }
            if (this.fluid_level() > 900) {
                return this.accepts_lava_container(stack);
            }
            return accepted_minerals.contains(stack.func_77973_b());
        }

        public boolean insert(ItemStack stack, boolean simulate) {
            if (stack.func_190926_b() || !this.accepts_input(stack)) {
                return false;
            }
            if (!simulate) {
                ItemStack st = stack.func_77946_l();
                st.func_190920_e(st.func_77976_d());
                this.stacks_.set(0, (Object)st);
                if (!this.accepts_lava_container(stack)) {
                    this.progress_ = 0;
                }
                this.force_block_update_ = true;
            }
            return true;
        }

        public ItemStack extract(boolean simulate) {
            ItemStack stack = ((ItemStack)this.stacks_.get(1)).func_77946_l();
            if (stack.func_190926_b()) {
                return ItemStack.field_190927_a;
            }
            if (!simulate) {
                this.reset_process();
            }
            return stack;
        }

        protected void reset_process() {
            this.stacks_ = NonNullList.func_191197_a((int)2, (Object)ItemStack.field_190927_a);
            this.force_block_update_ = true;
            this.fluid_level_ = 0;
            this.tick_timer_ = 0;
            this.progress_ = 0;
        }

        public void readnbt(NBTTagCompound nbt) {
            this.energy_stored_ = nbt.func_74762_e("energy");
            this.progress_ = nbt.func_74762_e("progress");
            this.fluid_level_ = nbt.func_74762_e("fluidlevel");
            ItemStackHelper.func_191283_b((NBTTagCompound)nbt, this.stacks_);
            if (this.stacks_.size() != 1) {
                this.reset_process();
            }
        }

        protected void writenbt(NBTTagCompound nbt) {
            nbt.func_74768_a("energy", MathHelper.func_76125_a((int)this.energy_stored_, (int)0, (int)32000));
            nbt.func_74768_a("progress", MathHelper.func_76125_a((int)this.progress_, (int)0, (int)100));
            nbt.func_74768_a("fluidlevel", MathHelper.func_76125_a((int)this.fluid_level_, (int)0, (int)1000));
            ItemStackHelper.func_191282_a((NBTTagCompound)nbt, this.stacks_);
        }

        public boolean shouldRefresh(World world, BlockPos pos, IBlockState os, IBlockState ns) {
            return os.func_177230_c() != ns.func_177230_c() || !(ns.func_177230_c() instanceof BlockDecorMineralSmelter);
        }

        public void func_145839_a(NBTTagCompound compound) {
            super.func_145839_a(compound);
            this.readnbt(compound);
        }

        public NBTTagCompound func_189515_b(NBTTagCompound compound) {
            super.func_189515_b(compound);
            this.writenbt(compound);
            return compound;
        }

        public String func_70005_c_() {
            Block block = this.func_145838_q();
            return block != null ? block.func_149739_a() + ".name" : "";
        }

        public boolean func_145818_k_() {
            return false;
        }

        public ITextComponent func_145748_c_() {
            return new TextComponentTranslation(this.func_70005_c_(), new Object[0]);
        }

        public int func_70302_i_() {
            return this.stacks_.size();
        }

        public boolean func_191420_l() {
            for (ItemStack stack : this.stacks_) {
                if (stack.func_190926_b()) continue;
                return false;
            }
            return true;
        }

        public ItemStack func_70301_a(int index) {
            return index >= 0 && index < this.func_70302_i_() ? (ItemStack)this.stacks_.get(index) : ItemStack.field_190927_a;
        }

        public ItemStack func_70298_a(int index, int count) {
            return ItemStackHelper.func_188382_a(this.stacks_, (int)index, (int)count);
        }

        public ItemStack func_70304_b(int index) {
            return ItemStackHelper.func_188383_a(this.stacks_, (int)index);
        }

        public void func_70299_a(int index, ItemStack stack) {
            if (stack.func_190916_E() > this.func_70297_j_()) {
                stack.func_190920_e(this.func_70297_j_());
            }
            this.stacks_.set(index, (Object)stack);
            this.func_70296_d();
        }

        public int func_70297_j_() {
            return 1;
        }

        public void func_70296_d() {
            super.func_70296_d();
        }

        public boolean func_70300_a(EntityPlayer player) {
            return this.field_145850_b.func_175625_s(this.field_174879_c) == this && player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
        }

        public void func_174889_b(EntityPlayer player) {
        }

        public void func_174886_c(EntityPlayer player) {
            this.func_70296_d();
        }

        public boolean func_94041_b(int index, ItemStack stack) {
            return index == 0 && this.accepts_input(stack) || index == 1;
        }

        public int func_174887_a_(int id) {
            return 0;
        }

        public void func_174885_b(int id, int value) {
        }

        public int func_174890_g() {
            return 0;
        }

        public void func_174888_l() {
            this.reset_process();
        }

        public int[] func_180463_a(EnumFacing side) {
            return SIDED_INV_SLOTS;
        }

        public boolean func_180462_a(int index, ItemStack stack, EnumFacing direction) {
            return index == 0 && this.func_94041_b(index, stack);
        }

        public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
            return index == 1 && !((ItemStack)this.stacks_.get(1)).func_190926_b();
        }

        public boolean canExtract() {
            return false;
        }

        public boolean canReceive() {
            return true;
        }

        public int getMaxEnergyStored() {
            return 32000;
        }

        public int getEnergyStored() {
            return this.energy_stored_;
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            return 0;
        }

        public int receiveEnergy(int maxReceive, boolean simulate) {
            if (this.energy_stored_ >= 32000) {
                return 0;
            }
            int n = Math.min(maxReceive, 32000 - this.energy_stored_);
            if (n > 8192) {
                n = 8192;
            }
            if (!simulate) {
                this.energy_stored_ += n;
                this.func_70296_d();
            }
            return n;
        }

        public boolean hasCapability(Capability<?> cap, EnumFacing facing) {
            return cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || cap == CapabilityEnergy.ENERGY || cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || super.hasCapability(cap, facing);
        }

        @Nullable
        public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
            if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
                return (T)this.item_handler_;
            }
            if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
                return (T)this.fluid_handler_;
            }
            if (capability == CapabilityEnergy.ENERGY) {
                return (T)((Object)this);
            }
            return (T)super.getCapability(capability, facing);
        }

        public void func_73660_a() {
            if (this.field_145850_b.field_72995_K) {
                return;
            }
            if (--this.tick_timer_ > 0) {
                return;
            }
            this.tick_timer_ = 20;
            IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            if (!(state.func_177230_c() instanceof BlockDecorMineralSmelter)) {
                return;
            }
            boolean dirty = false;
            int last_phase = this.phase();
            ItemStack istack = (ItemStack)this.stacks_.get(0);
            if (istack.func_190926_b() && this.fluid_level() == 0) {
                this.progress_ = 0;
            } else if (this.energy_stored_ <= 0 || this.field_145850_b.func_175640_z(this.field_174879_c)) {
                this.progress_ = MathHelper.func_76125_a((int)(this.progress_ - cooldown_rate), (int)0, (int)100);
            } else if (this.progress_ >= 100) {
                this.progress_ = 100;
                this.energy_stored_ = MathHelper.func_76125_a((int)(this.energy_stored_ - energy_consumption * 20 / 20), (int)0, (int)32000);
            } else {
                this.energy_stored_ = MathHelper.func_76125_a((int)(this.energy_stored_ - energy_consumption * 20), (int)0, (int)32000);
                this.progress_ = MathHelper.func_76125_a((int)(this.progress_ + heatup_rate), (int)0, (int)100);
            }
            int new_phase = this.phase();
            boolean is_lava_container = this.accepts_lava_container(istack);
            if (is_lava_container || new_phase != last_phase) {
                if (is_lava_container) {
                    if (istack.func_77969_a(BUCKET_STACK)) {
                        if (!((ItemStack)this.stacks_.get(1)).func_77969_a(LAVA_BUCKET_STACK)) {
                            if (this.fluid_level() >= 900) {
                                this.stacks_.set(1, (Object)LAVA_BUCKET_STACK);
                                this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_187633_N, SoundCategory.BLOCKS, 0.2f, 1.3f);
                            } else {
                                this.stacks_.set(1, (Object)istack.func_77946_l());
                            }
                            dirty = true;
                        }
                    } else {
                        this.stacks_.set(1, (Object)istack.func_77946_l());
                    }
                } else if (new_phase > last_phase) {
                    switch (new_phase) {
                        case 3: {
                            this.fluid_level_ = 1000;
                            this.stacks_.set(1, (Object)ItemStack.field_190927_a);
                            this.stacks_.set(0, (Object)ItemStack.field_190927_a);
                            this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_187656_cX, SoundCategory.BLOCKS, 0.2f, 1.0f);
                            dirty = true;
                            break;
                        }
                        case 2: {
                            this.stacks_.set(1, (Object)MAGMA_STACK.func_77946_l());
                            this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_187643_bs, SoundCategory.BLOCKS, 0.2f, 0.8f);
                            dirty = true;
                            break;
                        }
                        case 1: {
                            this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_187643_bs, SoundCategory.BLOCKS, 0.2f, 0.8f);
                        }
                    }
                } else {
                    switch (new_phase) {
                        case 2: {
                            this.stacks_.set(0, (Object)(this.fluid_level_ >= 900 ? MAGMA_STACK.func_77946_l() : ItemStack.field_190927_a));
                            this.stacks_.set(1, (Object)((ItemStack)this.stacks_.get(0)).func_77946_l());
                            this.fluid_level_ = 0;
                            this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_187659_cY, SoundCategory.BLOCKS, 0.5f, 1.1f);
                            dirty = true;
                            break;
                        }
                        case 1: {
                            if (istack.func_77969_a(MAGMA_STACK)) {
                                this.stacks_.set(1, (Object)new ItemStack(Blocks.field_150343_Z));
                            } else {
                                this.stacks_.set(1, (Object)new ItemStack(Blocks.field_150347_e));
                            }
                            this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_187659_cY, SoundCategory.BLOCKS, 0.3f, 0.9f);
                            dirty = true;
                            break;
                        }
                        case 0: {
                            this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_187659_cY, SoundCategory.BLOCKS, 0.3f, 0.7f);
                        }
                    }
                }
            }
            if (this.force_block_update_ || (Integer)state.func_177229_b((IProperty)PHASE) != new_phase) {
                state = state.func_177226_a((IProperty)PHASE, (Comparable)Integer.valueOf(new_phase));
                this.field_145850_b.func_180501_a(this.field_174879_c, state, 19);
                this.field_145850_b.func_175685_c(this.field_174879_c, state.func_177230_c(), false);
                this.force_block_update_ = false;
            }
            if (dirty) {
                this.func_70296_d();
            }
        }

        static {
            accepted_minerals.add(Item.func_150898_a((Block)Blocks.field_150347_e));
            accepted_minerals.add(Item.func_150898_a((Block)Blocks.field_150348_b));
            accepted_minerals.add(Item.func_150898_a((Block)Blocks.field_150322_A));
            accepted_minerals.add(Item.func_150898_a((Block)Blocks.field_180397_cI));
            accepted_minerals.add(Item.func_150898_a((Block)Blocks.field_150377_bs));
            accepted_minerals.add(Item.func_150898_a((Block)Blocks.field_150341_Y));
            accepted_minerals.add(Item.func_150898_a((Block)Blocks.field_180395_cM));
            accepted_minerals.add(Item.func_150898_a((Block)Blocks.field_150371_ca));
            accepted_minerals.add(Item.func_150898_a((Block)Blocks.field_150336_V));
            accepted_minerals.add(Item.func_150898_a((Block)Blocks.field_185772_cY));
            accepted_minerals.add(Item.func_150898_a((Block)Blocks.field_150405_ch));
            accepted_minerals.add(Item.func_150898_a((Block)Blocks.field_150406_ce));
            accepted_minerals.add(Item.func_150898_a((Block)Blocks.field_150417_aV));
            accepted_lava_contrainers.add(Items.field_151133_ar);
            SIDED_INV_SLOTS = new int[]{0, 1};
        }

        private static class BFluidHandler
        implements IFluidHandler,
        IFluidTankProperties {
            private final FluidStack lava;
            private final BTileEntity te;
            private final IFluidTankProperties[] props_ = new IFluidTankProperties[]{this};

            BFluidHandler(BTileEntity te) {
                this.te = te;
                this.lava = new FluidStack(FluidRegistry.LAVA, 1);
            }

            @Nullable
            public FluidStack getContents() {
                return new FluidStack(this.lava, this.te.fluid_level());
            }

            public IFluidTankProperties[] getTankProperties() {
                return this.props_;
            }

            public int fill(FluidStack resource, boolean doFill) {
                return 0;
            }

            public int getCapacity() {
                return 1000;
            }

            public boolean canFill() {
                return false;
            }

            public boolean canDrain() {
                return true;
            }

            public boolean canFillFluidType(FluidStack fluidStack) {
                return false;
            }

            public boolean canDrainFluidType(FluidStack fluidStack) {
                return fluidStack.isFluidEqual(this.lava);
            }

            @Nullable
            public FluidStack drain(FluidStack resource, boolean doDrain) {
                if (this.te.fluid_level() <= 0 || !resource.isFluidEqual(this.lava)) {
                    return null;
                }
                FluidStack fs = this.getContents();
                if (doDrain) {
                    this.te.fluid_level_drain(fs.amount);
                }
                return fs;
            }

            @Nullable
            public FluidStack drain(int maxDrain, boolean doDrain) {
                if (this.te.fluid_level() <= 0) {
                    return null;
                }
                maxDrain = doDrain ? this.te.fluid_level_drain(maxDrain) : Math.min(maxDrain, this.te.fluid_level());
                return new FluidStack(FluidRegistry.LAVA, maxDrain);
            }
        }

        protected static class BItemHandler
        implements IItemHandler {
            private BTileEntity te;

            BItemHandler(BTileEntity te) {
                this.te = te;
            }

            public int getSlots() {
                return 2;
            }

            public int getSlotLimit(int index) {
                return this.te.func_70297_j_();
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                return this.te.func_94041_b(slot, stack);
            }

            @Nonnull
            public ItemStack insertItem(int index, @Nonnull ItemStack stack, boolean simulate) {
                ItemStack rstack = stack.func_77946_l();
                if (index != 0 || !this.te.insert(stack.func_77946_l(), simulate)) {
                    return rstack;
                }
                rstack.func_190918_g(1);
                return rstack;
            }

            @Nonnull
            public ItemStack extractItem(int index, int amount, boolean simulate) {
                return index != 1 ? ItemStack.field_190927_a : this.te.extract(simulate);
            }

            @Nonnull
            public ItemStack getStackInSlot(int index) {
                return this.te.func_70301_a(index);
            }
        }
    }
}

