/*
 * Decompiled with CFR 0.152.
 */
package wile.engineersdecor.blocks;

import java.util.HashSet;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import wile.engineersdecor.ModEngineersDecor;
import wile.engineersdecor.blocks.BlockDecorDirectedHorizontal;
import wile.engineersdecor.detail.ModAuxiliaries;

public class BlockDecorBreaker
extends BlockDecorDirectedHorizontal {
    public static final int IDLE_TICK_INTERVAL = 40;
    public static final int TICK_INTERVAL = 5;
    public static final int BOOST_FACTOR = 8;
    public static final int DEFAULT_BOOST_ENERGY = 64;
    public static final int DEFAULT_BREAKING_RELUCTANCE = 17;
    public static final int DEFAULT_MIN_BREAKING_TIME = 15;
    public static final int MAX_BREAKING_TIME = 800;
    private static int boost_energy_consumption = 64;
    private static int energy_max = 10000;
    private static int breaking_reluctance = 17;
    private static int min_breaking_time = 15;
    private static boolean requires_power = false;
    public static final PropertyBool ACTIVE = PropertyBool.func_177716_a((String)"active");

    public static void on_config(int boost_energy_per_tick, int breaking_time_per_hardness, int min_breaking_time_ticks, boolean power_required) {
        boost_energy_consumption = 5 * MathHelper.func_76125_a((int)boost_energy_per_tick, (int)16, (int)512);
        energy_max = Math.max(boost_energy_consumption * 10, 10000);
        breaking_reluctance = MathHelper.func_76125_a((int)breaking_time_per_hardness, (int)5, (int)50);
        min_breaking_time = MathHelper.func_76125_a((int)min_breaking_time_ticks, (int)10, (int)100);
        requires_power = power_required;
        ModEngineersDecor.logger.info("Config block breaker: Boost energy consumption:" + boost_energy_consumption / 5 + "rf/t, reluctance=" + breaking_reluctance + "t/hrdn, break time offset=" + min_breaking_time + "t");
    }

    public BlockDecorBreaker(@Nonnull String registryName, long config, @Nullable Material material, float hardness, float resistance, @Nullable SoundType sound, @Nonnull AxisAlignedBB unrotatedAABB) {
        super(registryName, config, material, hardness, resistance, sound, unrotatedAABB);
        this.func_149713_g(0);
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, ACTIVE});
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_176731_b((int)(meta & 7))).func_177226_a((IProperty)ACTIVE, (Comparable)Boolean.valueOf((meta & 8) != 0));
    }

    @Override
    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b() & 7 | ((Boolean)state.func_177229_b((IProperty)ACTIVE) != false ? 8 : 0);
    }

    @Override
    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return super.getStateForPlacement(world, pos, facing, hitX, hitY, hitZ, meta, placer, hand).func_177226_a((IProperty)ACTIVE, (Comparable)Boolean.valueOf(false));
    }

    @Override
    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new BTileEntity();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rnd) {
        if (state.func_177230_c() != this || !((Boolean)state.func_177229_b((IProperty)ACTIVE)).booleanValue()) {
            return;
        }
        double rv = rnd.nextDouble();
        if (rv > 0.8) {
            return;
        }
        double x = 0.5 + (double)pos.func_177958_n();
        double y = 0.5 + (double)pos.func_177956_o();
        double z = 0.5 + (double)pos.func_177952_p();
        double xc = 0.52;
        double xr = rnd.nextDouble() * 0.4 - 0.2;
        double yr = y - 0.3 + rnd.nextDouble() * 0.2;
        switch ((EnumFacing)state.func_177229_b((IProperty)FACING)) {
            case WEST: {
                world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, x - 0.52, yr, z + xr, 0.0, 0.0, 0.0, new int[0]);
                break;
            }
            case EAST: {
                world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, x + 0.52, yr, z + xr, 0.0, 0.0, 0.0, new int[0]);
                break;
            }
            case NORTH: {
                world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, x + xr, yr, z - 0.52, 0.0, 0.0, 0.0, new int[0]);
                break;
            }
            default: {
                world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, x + xr, yr, z + 0.52, 0.0, 0.0, 0.0, new int[0]);
            }
        }
    }

    @Override
    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos neighborPos) {
        if (!(world instanceof World) || world.field_72995_K) {
            return;
        }
        TileEntity te = world.func_175625_s(pos);
        if (!(te instanceof BTileEntity)) {
            return;
        }
        ((BTileEntity)te).block_updated();
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        TileEntity te = world.func_175625_s(pos);
        if (!(te instanceof BTileEntity)) {
            return true;
        }
        ((BTileEntity)te).state_message(player);
        return true;
    }

    public static class BTileEntity
    extends TileEntity
    implements ITickable,
    IEnergyStorage {
        private int tick_timer_;
        private int active_timer_;
        private int proc_time_elapsed_;
        private int time_needed_;
        private int energy_;
        private static HashSet<Block> blacklist = new HashSet();

        public void block_updated() {
            if (this.tick_timer_ > 2) {
                this.tick_timer_ = 2;
            }
        }

        public void state_message(EntityPlayer player) {
            String soc = Integer.toString(MathHelper.func_76125_a((int)(this.energy_ * 100 / energy_max), (int)0, (int)100));
            String progress = "";
            if (this.proc_time_elapsed_ > 0 && this.time_needed_ > 0 && this.active_timer_ > 0) {
                progress = " | " + Integer.toString((int)MathHelper.func_151237_a((double)((double)this.proc_time_elapsed_ / (double)this.time_needed_ * 100.0), (double)0.0, (double)100.0)) + "%%";
            }
            ModAuxiliaries.playerChatMessage(player, soc + "%%/" + energy_max + "RF" + progress);
        }

        public void readnbt(NBTTagCompound nbt) {
            this.energy_ = nbt.func_74762_e("energy");
        }

        private void writenbt(NBTTagCompound nbt) {
            nbt.func_74768_a("energy", this.energy_);
        }

        public boolean shouldRefresh(World world, BlockPos pos, IBlockState os, IBlockState ns) {
            return os.func_177230_c() != ns.func_177230_c() || !(ns.func_177230_c() instanceof BlockDecorBreaker);
        }

        public void func_145839_a(NBTTagCompound nbt) {
            super.func_145839_a(nbt);
            this.readnbt(nbt);
        }

        public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
            super.func_189515_b(nbt);
            this.writenbt(nbt);
            return nbt;
        }

        public boolean canExtract() {
            return false;
        }

        public boolean canReceive() {
            return true;
        }

        public int getMaxEnergyStored() {
            return boost_energy_consumption * 2;
        }

        public int getEnergyStored() {
            return this.energy_;
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            return 0;
        }

        public int receiveEnergy(int maxReceive, boolean simulate) {
            maxReceive = MathHelper.func_76125_a((int)maxReceive, (int)0, (int)Math.max(energy_max - this.energy_, 0));
            if (!simulate) {
                this.energy_ += maxReceive;
            }
            return maxReceive;
        }

        public boolean hasCapability(Capability<?> cap, EnumFacing facing) {
            return cap == CapabilityEnergy.ENERGY || super.hasCapability(cap, facing);
        }

        @Nullable
        public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
            if (capability == CapabilityEnergy.ENERGY) {
                return (T)((Object)this);
            }
            return (T)super.getCapability(capability, facing);
        }

        private static boolean isBreakable(IBlockState state, BlockPos pos, World world) {
            Block block = state.func_177230_c();
            if (blacklist.contains(block)) {
                return false;
            }
            if (state.func_185904_a().func_76224_d()) {
                return false;
            }
            if (block.isAir(state, (IBlockAccess)world, pos)) {
                return false;
            }
            float bh = state.func_185887_b(world, pos);
            return !(bh < 0.0f) && !(bh > 55.0f);
        }

        private static boolean breakBlock(IBlockState state, BlockPos pos, World world) {
            if (world.field_72995_K || world.restoringBlockSnapshots) {
                return false;
            }
            Block block = state.func_177230_c();
            block.func_176226_b(world, pos, state, 0);
            world.func_175698_g(pos);
            SoundType stype = state.func_177230_c().getSoundType(state, world, pos, null);
            if (stype != null) {
                world.func_184133_a(null, pos, stype.func_185841_e(), SoundCategory.BLOCKS, stype.func_185843_a() * 0.6f, stype.func_185847_b());
            }
            return true;
        }

        public void func_73660_a() {
            if (--this.tick_timer_ > 0) {
                return;
            }
            IBlockState device_state = this.field_145850_b.func_180495_p(this.field_174879_c);
            if (!(device_state.func_177230_c() instanceof BlockDecorBreaker)) {
                this.tick_timer_ = 5;
                return;
            }
            if (this.field_145850_b.field_72995_K) {
                if (!((Boolean)device_state.func_177229_b((IProperty)ACTIVE)).booleanValue()) {
                    this.tick_timer_ = 5;
                } else {
                    this.tick_timer_ = 1;
                    SoundEvent sound = SoundEvents.field_187889_gU;
                    SoundType stype = this.field_145850_b.func_180495_p(this.field_174879_c.func_177972_a((EnumFacing)device_state.func_177229_b((IProperty)BlockDecorDirectedHorizontal.FACING))).func_177230_c().func_185467_w();
                    if (stype == SoundType.field_185854_g || stype == SoundType.field_185850_c || stype == SoundType.field_185856_i) {
                        sound = SoundEvents.field_187550_ag;
                    } else if (stype == SoundType.field_185849_b || stype == SoundType.field_185855_h) {
                        sound = SoundEvents.field_187585_bY;
                    }
                    this.field_145850_b.func_184134_a((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), sound, SoundCategory.BLOCKS, 0.1f, 1.2f, false);
                }
            } else {
                boolean active;
                this.tick_timer_ = 5;
                BlockPos target_pos = this.field_174879_c.func_177972_a((EnumFacing)device_state.func_177229_b((IProperty)BlockDecorDirectedHorizontal.FACING));
                IBlockState target_state = this.field_145850_b.func_180495_p(target_pos);
                if (this.field_145850_b.func_175640_z(this.field_174879_c) || !BTileEntity.isBreakable(target_state, target_pos, this.field_145850_b)) {
                    if (((Boolean)device_state.func_177229_b((IProperty)ACTIVE)).booleanValue()) {
                        this.field_145850_b.func_180501_a(this.field_174879_c, device_state.func_177226_a((IProperty)ACTIVE, (Comparable)Boolean.valueOf(false)), 3);
                    }
                    this.proc_time_elapsed_ = 0;
                    this.tick_timer_ = 40;
                    return;
                }
                this.time_needed_ = MathHelper.func_76125_a((int)((int)(target_state.func_185887_b(this.field_145850_b, target_pos) * (float)breaking_reluctance) + min_breaking_time), (int)min_breaking_time, (int)800);
                if (this.energy_ >= boost_energy_consumption) {
                    this.energy_ -= boost_energy_consumption;
                    this.proc_time_elapsed_ += 45;
                    this.time_needed_ += min_breaking_time * 4;
                    this.active_timer_ = 2;
                } else if (!requires_power) {
                    this.proc_time_elapsed_ += 5;
                    this.active_timer_ = 1024;
                } else if (this.active_timer_ > 0) {
                    --this.active_timer_;
                }
                boolean bl = active = this.active_timer_ > 0;
                if (requires_power && !active) {
                    this.proc_time_elapsed_ = Math.max(0, this.proc_time_elapsed_ - 10);
                }
                if (this.proc_time_elapsed_ >= this.time_needed_) {
                    this.proc_time_elapsed_ = 0;
                    BTileEntity.breakBlock(target_state, target_pos, this.field_145850_b);
                    active = false;
                }
                if ((Boolean)device_state.func_177229_b((IProperty)ACTIVE) != active) {
                    this.field_145850_b.func_180501_a(this.field_174879_c, device_state.func_177226_a((IProperty)ACTIVE, (Comparable)Boolean.valueOf(active)), 3);
                }
            }
        }

        static {
            blacklist.add(Blocks.field_150350_a);
            blacklist.add(Blocks.field_150357_h);
            blacklist.add((Block)Blocks.field_150480_ab);
            blacklist.add(Blocks.field_150384_bq);
            blacklist.add(Blocks.field_185775_db);
            blacklist.add(Blocks.field_150378_br);
        }
    }
}

