/*
 * Decompiled with CFR 0.152.
 */
package zone.rong.loliasm.common.modfixes.betterwithmods;

import betterwithmods.common.BWMItems;
import betterwithmods.common.items.ItemMaterial;
import betterwithmods.module.gameplay.Gameplay;
import it.unimi.dsi.fastutil.objects.Reference2DoubleMap;
import it.unimi.dsi.fastutil.objects.Reference2DoubleOpenHashMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class BWMBlastingOilOptimization {
    private static Reference2DoubleMap<EntityItem> highestPoint;

    @SubscribeEvent
    public static void onPlayerTakeDamage(LivingHurtEvent e) {
        IItemHandler inventory;
        if (e.getSource() == null || e.getSource().field_76373_n == null || Gameplay.blacklistDamageSources.contains(e.getSource().field_76373_n)) {
            return;
        }
        EntityLivingBase living = e.getEntityLiving();
        if (living.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null) && (inventory = (IItemHandler)living.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) != null) {
            int count = 0;
            for (int i = 0; i < inventory.getSlots(); ++i) {
                ItemStack stack = inventory.getStackInSlot(i);
                if (stack.func_77973_b() != BWMItems.MATERIAL || stack.func_77960_j() != ItemMaterial.EnumMaterial.BLASTING_OIL.getMetadata()) continue;
                count += stack.func_190916_E();
                inventory.extractItem(i, stack.func_190916_E(), false);
            }
            if (count > 0) {
                living.func_70097_a(new DamageSource("blasting_oil"), Float.MAX_VALUE);
                living.func_130014_f_().func_72876_a(null, living.field_70165_t, living.field_70163_u + (double)(living.field_70131_O / 16.0f), living.field_70161_v, (float)(Math.sqrt((double)count / 5.0) / 2.5 + 1.0), true);
            }
        }
    }

    public static boolean inject$ItemMaterial$onEntityItemUpdate(EntityItem entity) {
        int count;
        ItemStack stack = entity.func_92059_d();
        if (stack.func_77960_j() != ItemMaterial.EnumMaterial.BLASTING_OIL.getMetadata()) {
            return false;
        }
        if (highestPoint == null) {
            highestPoint = new Reference2DoubleOpenHashMap();
        }
        if ((entity.func_70027_ad() || entity.field_70122_E && Math.abs(entity.field_70163_u - (Double)highestPoint.getOrDefault((Object)entity, (Object)entity.field_70163_u)) > 2.0) && (count = stack.func_190916_E()) > 0) {
            highestPoint.removeDouble((Object)entity);
            entity.func_130014_f_().func_72876_a((Entity)entity, entity.field_70165_t, entity.field_70163_u + (double)(entity.field_70131_O / 16.0f), entity.field_70161_v, (float)(Math.sqrt((double)count / 5.0) / 2.5 + 1.0), true);
            entity.func_70106_y();
            return true;
        }
        if (entity.field_70181_x > 0.0 || !highestPoint.containsKey((Object)entity)) {
            highestPoint.put((Object)entity, entity.field_70163_u);
        }
        return false;
    }
}

