/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.bogosorter.core.visitor;

import com.cleanroommc.bogosorter.BogoSorter;
import net.minecraftforge.fml.relauncher.FMLLaunchHandler;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;

public class PIMVisitor
extends ClassVisitor
implements Opcodes {
    public static final String CLASS_NAME = "net.minecraft.server.management.PlayerInteractionManager";
    public static final boolean DEOBF = FMLLaunchHandler.isDeobfuscatedEnvironment();
    public static final String METHOD_NAME = DEOBF ? "processRightClick" : "func_187250_a";
    public static final String TRY_HARVEST_BLOCK_FUNC = DEOBF ? "tryHarvestBlock" : "func_180237_b";
    public static final String PLAYER_CLASS = "net/minecraft/entity/player/EntityPlayer";
    public static final String PLAYER_MP_CLASS = "net/minecraft/entity/player/EntityPlayerMP";
    public static final String SET_HELD_ITEM_FUNC = DEOBF ? "setHeldItem" : "func_184611_a";
    public static final String ITEM_STACK_CLASS = "net/minecraft/item/ItemStack";
    public static final String EMPTY = DEOBF ? "EMPTY" : "field_190927_a";
    public static final String REFILL_HANDLER_CLASS = "com/cleanroommc/bogosorter/common/refill/RefillHandler";
    public static final String ON_DESTROY_FUNC = "onDestroyItem";
    public static final String ON_DESTROY_FUNC_DESC = "(Lnet/minecraft/entity/player/EntityPlayer;Lnet/minecraft/item/ItemStack;Lnet/minecraft/util/EnumHand;)V";
    public static final String FEF_CLASS = "net/minecraftforge/event/ForgeEventFactory";
    public static final String ON_DESTROY_ITEM_FUNC = "onPlayerDestroyItem";
    public static final String PIM_CLASS = "net/minecraft/server/management/PlayerInteractionManager";
    public static final String HAND_CLASS = "net/minecraft/util/EnumHand";

    public PIMVisitor(ClassVisitor cv) {
        super(327680, cv);
    }

    public static void visitOnDestroy(MethodVisitor mv) {
        mv.visitMethodInsn(184, REFILL_HANDLER_CLASS, ON_DESTROY_FUNC, ON_DESTROY_FUNC_DESC, false);
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor visitor = super.visitMethod(access, name, desc, signature, exceptions);
        if (METHOD_NAME.equals(name)) {
            return new TargetMethodVisitor(visitor);
        }
        if (access == 1 && TRY_HARVEST_BLOCK_FUNC.equals(name)) {
            return new TryHarvestBlockVisitor(visitor);
        }
        return visitor;
    }

    public static class TargetMethodVisitor
    extends MethodVisitor {
        private boolean inject = false;

        public TargetMethodVisitor(MethodVisitor mv) {
            super(327680, mv);
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
            super.visitMethodInsn(opcode, owner, name, desc, itf);
            if (this.inject && opcode == 182 && PIMVisitor.PLAYER_CLASS.equals(owner) && SET_HELD_ITEM_FUNC.equals(name)) {
                this.visitVarInsn(25, 1);
                this.visitVarInsn(25, 8);
                this.visitVarInsn(25, 4);
                PIMVisitor.visitOnDestroy(this);
                this.inject = false;
                BogoSorter.LOGGER.info("Applied PIM processRightClick ASM");
            }
        }

        public void visitFieldInsn(int opcode, String owner, String name, String desc) {
            super.visitFieldInsn(opcode, owner, name, desc);
            if (opcode == 178 && PIMVisitor.ITEM_STACK_CLASS.equals(owner) && EMPTY.equals(name)) {
                this.inject = true;
            }
        }
    }

    public static class TryHarvestBlockVisitor
    extends MethodVisitor {
        public TryHarvestBlockVisitor(MethodVisitor mv) {
            super(327680, mv);
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
            super.visitMethodInsn(opcode, owner, name, desc, itf);
            if (opcode == 184 && PIMVisitor.FEF_CLASS.equals(owner) && PIMVisitor.ON_DESTROY_ITEM_FUNC.equals(name)) {
                this.visitVarInsn(25, 0);
                this.visitFieldInsn(180, PIMVisitor.PIM_CLASS, DEOBF ? "player" : "field_73090_b", "Lnet/minecraft/entity/player/EntityPlayerMP;");
                this.visitVarInsn(25, 9);
                this.visitFieldInsn(178, PIMVisitor.HAND_CLASS, "MAIN_HAND", "Lnet/minecraft/util/EnumHand;");
                PIMVisitor.visitOnDestroy(this);
                BogoSorter.LOGGER.info("Applied PIM tryHarvestBlock ASM");
            }
        }
    }
}

