/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.util;

import cam72cam.immersiverailroading.util.DataBlock;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class MergedBlocks
implements DataBlock {
    Map<String, DataBlock.Value> primitives;
    Map<String, List<DataBlock.Value>> primitiveSets;
    Map<String, DataBlock> blocks;
    Map<String, List<DataBlock>> blockSets;

    public MergedBlocks(DataBlock base, DataBlock override) {
        this.primitives = new LinkedHashMap<String, DataBlock.Value>(base.getValueMap());
        this.primitiveSets = new LinkedHashMap<String, List<DataBlock.Value>>(base.getValuesMap());
        this.blocks = new LinkedHashMap<String, DataBlock>(base.getBlockMap());
        this.blockSets = new LinkedHashMap<String, List<DataBlock>>(base.getBlocksMap());
        this.primitives.putAll(override.getValueMap());
        override.getValuesMap().forEach((key, values) -> {
            if (this.primitiveSets.containsKey(key)) {
                ArrayList tmp = new ArrayList(this.primitiveSets.get(key));
                tmp.addAll(values);
                values = tmp;
            }
            this.primitiveSets.put((String)key, (List<DataBlock.Value>)values);
        });
        override.getBlockMap().forEach((key, block) -> {
            if (this.blocks.containsKey(key)) {
                block = new MergedBlocks(this.blocks.get(key), (DataBlock)block);
            }
            this.blocks.put((String)key, (DataBlock)block);
        });
        override.getBlocksMap().forEach((key, blocks) -> {
            if (this.blockSets.containsKey(key)) {
                ArrayList tmp = new ArrayList(this.blockSets.get(key));
                tmp.addAll(blocks);
                blocks = tmp;
            }
            this.blockSets.put((String)key, (List<DataBlock>)blocks);
        });
    }

    @Override
    public Map<String, DataBlock.Value> getValueMap() {
        return this.primitives;
    }

    @Override
    public Map<String, List<DataBlock.Value>> getValuesMap() {
        return this.primitiveSets;
    }

    @Override
    public Map<String, DataBlock> getBlockMap() {
        return this.blocks;
    }

    @Override
    public Map<String, List<DataBlock>> getBlocksMap() {
        return this.blockSets;
    }
}

