/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.track;

import cam72cam.immersiverailroading.track.BuilderBase;
import cam72cam.immersiverailroading.track.PosStep;
import cam72cam.immersiverailroading.util.RailInfo;
import cam72cam.mod.math.Vec3d;
import cam72cam.mod.math.Vec3i;
import java.util.List;

public interface IIterableTrack {
    public List<PosStep> getPath(double var1);

    public List<BuilderBase> getSubBuilders();

    default public double offsetFromTrack(RailInfo info, Vec3i pos, Vec3d position) {
        Vec3d relative = position.subtract(info.placementInfo.placementPosition).subtract(pos);
        relative = relative.add(0.0, -(relative.y % 1.0), 0.0);
        List<PosStep> positions = this.getPath(info.settings.gauge.scale() / 8.0);
        int left = 0;
        double leftDistance = positions.get(left).distanceToSquared(relative);
        int right = positions.size() - 1;
        double rightDistance = positions.get(right).distanceToSquared(relative);
        while (right - left > 1) {
            if (leftDistance > rightDistance) {
                left = (int)Math.ceil((float)left + (float)(right - left) / 3.0f);
                leftDistance = positions.get(left).distanceToSquared(relative);
                continue;
            }
            right = (int)Math.floor((float)right + (float)(left - right) / 3.0f);
            rightDistance = positions.get(right).distanceToSquared(relative);
        }
        double resultSquared = Math.min(rightDistance, leftDistance);
        return Math.sqrt(resultSquared);
    }
}

