/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.render.block;

import cam72cam.immersiverailroading.IRItems;
import cam72cam.immersiverailroading.library.Augment;
import cam72cam.immersiverailroading.library.Gauge;
import cam72cam.immersiverailroading.library.TrackItems;
import cam72cam.immersiverailroading.render.rail.RailRender;
import cam72cam.immersiverailroading.tile.TileRail;
import cam72cam.immersiverailroading.tile.TileRailBase;
import cam72cam.immersiverailroading.util.RailInfo;
import cam72cam.mod.MinecraftClient;
import cam72cam.mod.entity.Player;
import cam72cam.mod.item.CustomItem;
import cam72cam.mod.item.ItemStack;
import cam72cam.mod.render.StandardModel;
import util.Matrix4;

public class RailBaseModel {
    public static StandardModel getModel(TileRailBase te) {
        float height;
        ItemStack bed = te.getRenderRailBed();
        if (bed == null) {
            return null;
        }
        float tileHeight = height = te.getBedHeight();
        int snow = te.getSnowLayers();
        Augment augment = te.getAugment();
        double gauged = te.getRenderGauge();
        Gauge gauge = Gauge.from(gauged);
        StandardModel model = new StandardModel();
        if (te instanceof TileRail && ((TileRail)te).info != null) {
            model.addCustom((state, pt) -> {
                ItemStack held;
                RailInfo info = ((TileRail)te).info;
                if (info.settings.type == TrackItems.SWITCH) {
                    info = info.withSettings(b -> {
                        b.type = TrackItems.STRAIGHT;
                    });
                }
                if (info.settings.type == TrackItems.TURNTABLE && ((held = MinecraftClient.getPlayer().getHeldItem(Player.Hand.PRIMARY)).is((CustomItem)IRItems.ITEM_TRACK_BLUEPRINT) || held.is((CustomItem)IRItems.ITEM_GOLDEN_SPIKE))) {
                    info = info.with(b -> {
                        b.itemHeld = true;
                    });
                }
                RailRender.get(info).renderRailModel(state.translate(info.placementInfo.placementPosition));
            });
        }
        if (augment != null) {
            model.addColorBlock(augment.color(), new Matrix4().scale(1.0, (double)(height += 0.1f * (float)gauge.scale() * 1.25f), 1.0));
            return model;
        }
        height += 0.1f * (float)gauge.scale();
        if (snow != 0) {
            model.addSnow(snow + (int)(height * 8.0f), new Matrix4());
            return model;
        }
        if (!bed.isEmpty() && tileHeight != 1.0E-6f) {
            model.addItemBlock(bed, new Matrix4().scale(1.0, (double)height, 1.0));
            return model;
        }
        return model;
    }
}

