/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.registry;

import cam72cam.immersiverailroading.Config;
import cam72cam.immersiverailroading.entity.LocomotiveSteam;
import cam72cam.immersiverailroading.gui.overlay.GuiBuilder;
import cam72cam.immersiverailroading.library.Gauge;
import cam72cam.immersiverailroading.model.SteamLocomotiveModel;
import cam72cam.immersiverailroading.model.StockModel;
import cam72cam.immersiverailroading.registry.EntityRollingStockDefinition;
import cam72cam.immersiverailroading.registry.LocomotiveDefinition;
import cam72cam.immersiverailroading.registry.Quilling;
import cam72cam.immersiverailroading.util.DataBlock;
import cam72cam.immersiverailroading.util.FluidQuantity;
import cam72cam.mod.resource.Identifier;
import java.io.IOException;
import java.util.List;

public class LocomotiveSteamDefinition
extends LocomotiveDefinition {
    public Quilling quill;
    public EntityRollingStockDefinition.SoundDefinition whistle;
    public EntityRollingStockDefinition.SoundDefinition idle;
    public Identifier chuff;
    public Identifier pressure;
    public Identifier cylinder_drain;
    private double tankCapacity_l;
    private double maxPSI;
    private double numSlots;
    private double width;
    public boolean tender_auto_feed;
    public boolean cab_forward;

    public LocomotiveSteamDefinition(String defID, DataBlock data) throws Exception {
        super(LocomotiveSteam.class, defID, data);
    }

    @Override
    protected Identifier defaultDataLocation() {
        return new Identifier("immersiverailroading", "rolling_stock/default/steam.caml");
    }

    @Override
    public void loadData(DataBlock data) throws Exception {
        super.loadData(data);
        DataBlock properties = data.getBlock("properties");
        if (this.isCabCar()) {
            this.tankCapacity_l = 0.0;
            this.maxPSI = 0.0;
            this.numSlots = 0.0;
            this.width = 0.0;
            this.tender_auto_feed = false;
        } else {
            DataBlock firebox = data.getBlock("firebox");
            this.tankCapacity_l = (double)properties.getValue("water_capacity_l").asInteger().intValue() * this.internal_inv_scale;
            this.maxPSI = Math.ceil((double)properties.getValue("max_psi").asInteger().intValue() * this.internal_inv_scale);
            this.numSlots = Math.ceil((double)firebox.getValue("slots").asInteger().intValue() * this.internal_inv_scale);
            this.width = Math.ceil((double)firebox.getValue("width").asInteger().intValue() * this.internal_inv_scale);
            this.tender_auto_feed = properties.getValue("tender_auto_feed").asBoolean(true);
        }
        this.cab_forward = properties.getValue("cab_forward").asBoolean(false);
        DataBlock sounds = data.getBlock("sounds");
        this.whistle = EntityRollingStockDefinition.SoundDefinition.getOrDefault(sounds, "whistle");
        this.idle = EntityRollingStockDefinition.SoundDefinition.getOrDefault(sounds, "idle");
        this.chuff = sounds.getValue("chuff").asIdentifier();
        this.pressure = sounds.getValue("pressure").asIdentifier();
        this.bell = EntityRollingStockDefinition.SoundDefinition.getOrDefault(sounds, "bell");
        this.cylinder_drain = sounds.getValue("cylinder_drain").asIdentifier();
        List<DataBlock> quilling = sounds.getBlocks("quilling");
        if (quilling != null) {
            this.quill = new Quilling(quilling);
        }
        if (!(this.whistle != null || this.quill != null && this.quill.canLoad())) {
            this.quill = new Quilling(new Identifier("immersiverailroading", "sounds/steam/default/quill.ogg"));
        }
    }

    @Override
    protected StockModel<?, ?> createModel() throws Exception {
        return new SteamLocomotiveModel(this);
    }

    @Override
    public StockModel<?, ?> getModel() {
        return (SteamLocomotiveModel)super.getModel();
    }

    @Override
    protected GuiBuilder getDefaultOverlay(DataBlock data) throws IOException {
        return this.readCabCarFlag(data) ? GuiBuilder.parse(new Identifier("immersiverailroading", "gui/default/cab_car.caml")) : GuiBuilder.parse(new Identifier("immersiverailroading", "gui/default/steam.caml"));
    }

    public FluidQuantity getTankCapacity(Gauge gauge) {
        FluidQuantity cap = FluidQuantity.FromLiters((int)Math.ceil(this.tankCapacity_l * gauge.scale())).min(FluidQuantity.FromBuckets(1));
        return Config.ConfigBalance.RoundStockTankToNearestBucket ? cap.roundBuckets() : cap;
    }

    public int getMaxPSI(Gauge gauge) {
        return (int)Math.ceil(this.maxPSI * gauge.scale());
    }

    public int getInventorySize(Gauge gauge) {
        return (int)Math.ceil(this.numSlots * gauge.scale());
    }

    public int getInventoryWidth(Gauge gauge) {
        return (int)Math.max(3.0, Math.ceil(this.width * gauge.scale()));
    }
}

