/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.multiblock;

import cam72cam.immersiverailroading.Config;
import cam72cam.immersiverailroading.ConfigSound;
import cam72cam.immersiverailroading.library.GuiTypes;
import cam72cam.immersiverailroading.multiblock.Multiblock;
import cam72cam.immersiverailroading.tile.TileMultiblock;
import cam72cam.immersiverailroading.util.IRFuzzy;
import cam72cam.mod.energy.IEnergy;
import cam72cam.mod.entity.Player;
import cam72cam.mod.item.ItemStack;
import cam72cam.mod.math.Rotation;
import cam72cam.mod.math.Vec3i;
import cam72cam.mod.sound.Audio;
import cam72cam.mod.sound.SoundCategory;
import cam72cam.mod.sound.StandardSound;
import cam72cam.mod.world.World;

public class PlateRollerMultiblock
extends Multiblock {
    public static final String NAME = "PLATE_MACHINE";
    private static final Vec3i render = new Vec3i(2, 0, 0);
    private static final Vec3i crafter = new Vec3i(2, 0, 14);
    private static final Vec3i input = new Vec3i(2, 0, 0);
    private static final Vec3i output = new Vec3i(2, 0, 29);
    private static final Vec3i power = new Vec3i(1, 4, 14);

    private static Multiblock.FuzzyProvider[][][] componentGenerator() {
        Multiblock.FuzzyProvider[][][] result = new Multiblock.FuzzyProvider[30][][];
        Multiblock.FuzzyProvider[] bed = new Multiblock.FuzzyProvider[]{PlateRollerMultiblock.L_ENG(), PlateRollerMultiblock.S_SCAF(), PlateRollerMultiblock.S_SCAF(), PlateRollerMultiblock.S_SCAF(), PlateRollerMultiblock.L_ENG()};
        Multiblock.FuzzyProvider[] mid = new Multiblock.FuzzyProvider[]{PlateRollerMultiblock.L_ENG(), AIR, AIR, AIR, PlateRollerMultiblock.L_ENG()};
        Multiblock.FuzzyProvider[] top = new Multiblock.FuzzyProvider[]{PlateRollerMultiblock.H_ENG(), PlateRollerMultiblock.H_ENG(), PlateRollerMultiblock.H_ENG(), PlateRollerMultiblock.H_ENG(), PlateRollerMultiblock.H_ENG()};
        for (int i = 0; i < 30; ++i) {
            if (i >= 11 && i <= 18) {
                if (i >= 13 && i <= 16) {
                    if (i == 14) {
                        result[i] = new Multiblock.FuzzyProvider[][]{bed, mid, top, {AIR, PlateRollerMultiblock.L_ENG(), PlateRollerMultiblock.L_ENG(), PlateRollerMultiblock.L_ENG(), AIR}, {AIR, PlateRollerMultiblock.H_ENG(), AIR, AIR, AIR}};
                        continue;
                    }
                    result[i] = new Multiblock.FuzzyProvider[][]{bed, mid, top, {AIR, PlateRollerMultiblock.L_ENG(), PlateRollerMultiblock.L_ENG(), PlateRollerMultiblock.L_ENG(), AIR}};
                    continue;
                }
                result[i] = new Multiblock.FuzzyProvider[][]{bed, mid, top};
                continue;
            }
            result[i] = new Multiblock.FuzzyProvider[][]{bed};
        }
        return result;
    }

    public PlateRollerMultiblock() {
        super(NAME, PlateRollerMultiblock.componentGenerator());
    }

    @Override
    public Vec3i placementPos() {
        return new Vec3i(2, 0, 0);
    }

    @Override
    protected Multiblock.MultiblockInstance newInstance(World world, Vec3i origin, Rotation rot) {
        return new PlateRollerInstance(world, origin, rot);
    }

    public class PlateRollerInstance
    extends Multiblock.MultiblockInstance {
        public PlateRollerInstance(World world, Vec3i origin, Rotation rot) {
            super(world, origin, rot);
        }

        @Override
        public boolean onBlockActivated(Player player, Player.Hand hand, Vec3i offset) {
            if (!player.isCrouching()) {
                ItemStack held = player.getHeldItem(hand);
                if (held.isEmpty()) {
                    TileMultiblock outputTe = this.getTile(output);
                    if (outputTe == null) {
                        return false;
                    }
                    if (!outputTe.getContainer().get(0).isEmpty()) {
                        if (this.world.isServer) {
                            ItemStack outstack = outputTe.getContainer().get(0);
                            this.world.dropItem(outstack, player.getPosition());
                            outputTe.getContainer().set(0, ItemStack.EMPTY);
                        }
                        return true;
                    }
                } else if (IRFuzzy.steelBlockOrFallback().matches(held)) {
                    TileMultiblock inputTe = this.getTile(input);
                    if (inputTe == null) {
                        return false;
                    }
                    if (inputTe.getContainer().get(0).isEmpty() && this.world.isServer) {
                        ItemStack inputStack = held.copy();
                        inputStack.setCount(1);
                        inputTe.getContainer().set(0, inputStack);
                        held.shrink(1);
                        player.setHeldItem(hand, held);
                    }
                    return true;
                }
                if (this.world.isClient) {
                    Vec3i pos = this.getPos(crafter);
                    GuiTypes.PLATE_ROLLER.open(player, pos);
                }
                return true;
            }
            return false;
        }

        @Override
        public boolean isRender(Vec3i offset) {
            return render.equals((Object)offset);
        }

        @Override
        public int getInvSize(Vec3i offset) {
            return offset.equals((Object)input) || offset.equals((Object)output) ? 1 : 0;
        }

        @Override
        public void tick(Vec3i offset) {
            if (!offset.equals((Object)crafter)) {
                return;
            }
            TileMultiblock craftingTe = this.getTile(crafter);
            if (craftingTe == null) {
                return;
            }
            TileMultiblock powerTe = this.getTile(power);
            if (powerTe == null) {
                return;
            }
            TileMultiblock inputTe = this.getTile(input);
            if (inputTe == null) {
                return;
            }
            TileMultiblock outputTe = this.getTile(output);
            if (outputTe == null) {
                return;
            }
            if (!this.hasPower()) {
                return;
            }
            if (this.world.isClient) {
                if (craftingTe.getRenderTicks() % 10L == 0L && craftingTe.getCraftProgress() != 0) {
                    Audio.playSound((World)this.world, (Vec3i)craftingTe.getPos(), (StandardSound)StandardSound.BLOCK_ANVIL_PLACE, (SoundCategory)SoundCategory.BLOCKS, (float)(1.0f * ConfigSound.SoundCategories.Machines.category()), (float)0.2f);
                }
                return;
            }
            if (craftingTe.getCraftProgress() != 0) {
                IEnergy energy = powerTe.getEnergy(null);
                energy.extract(this.powerRequired(), false);
                craftingTe.setCraftProgress(Math.max(0, craftingTe.getCraftProgress() - 1));
            }
            float progress = craftingTe.getCraftProgress();
            ItemStack input = inputTe.getContainer().get(0);
            ItemStack output = outputTe.getContainer().get(0);
            if (progress == 0.0f && IRFuzzy.steelBlockOrFallback().matches(input) && output.isEmpty() && !craftingTe.getCraftItem().isEmpty()) {
                input.setCount(input.getCount() - 1);
                inputTe.getContainer().set(0, input);
                progress = 100.0f;
                craftingTe.setCraftProgress(100);
            }
            if (progress == 1.0f) {
                outputTe.getContainer().set(0, craftingTe.getCraftItem().copy());
            }
        }

        @Override
        public boolean canInsertItem(Vec3i offset, int slot, ItemStack stack) {
            return offset.equals((Object)input) && IRFuzzy.steelBlockOrFallback().matches(stack);
        }

        @Override
        public boolean isOutputSlot(Vec3i offset, int slot) {
            return offset.equals((Object)output);
        }

        @Override
        public int getSlotLimit(Vec3i offset, int slot) {
            return offset.equals((Object)input) || offset.equals((Object)output) ? 1 : 0;
        }

        @Override
        public boolean canRecievePower(Vec3i offset) {
            return offset.equals((Object)power);
        }

        public boolean hasPower() {
            TileMultiblock powerTe = this.getTile(power);
            if (powerTe == null) {
                return false;
            }
            return powerTe.getEnergy(null).getCurrent() >= this.powerRequired();
        }

        private int powerRequired() {
            return (int)Math.ceil(32.0f * Config.ConfigBalance.machinePowerFactor);
        }
    }
}

