/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.model.part;

import cam72cam.immersiverailroading.entity.EntityMoveableRollingStock;
import cam72cam.immersiverailroading.model.ModelState;
import cam72cam.immersiverailroading.model.components.ModelComponent;
import cam72cam.mod.math.Vec3d;
import java.util.function.Function;
import util.Matrix4;

public class Wheel {
    public final ModelComponent wheel;

    protected Wheel(ModelComponent wheel, ModelState state, Function<EntityMoveableRollingStock, Float> angle) {
        this.wheel = wheel;
        Vec3d wheelPos = wheel.center;
        state.push(settings -> settings.add((stock, partialTicks) -> new Matrix4().translate(wheelPos.x, wheelPos.y, wheelPos.z).rotate(Math.toRadians(angle != null ? (double)((Float)angle.apply(stock)).floatValue() : (double)this.angle(stock.distanceTraveled)), 0.0, 0.0, 1.0).translate(-wheelPos.x, -wheelPos.y, -wheelPos.z))).include(wheel);
    }

    public double diameter() {
        return this.wheel.height();
    }

    public float angle(double distance) {
        double circumference = this.diameter() * 3.1415927410125732;
        double relDist = distance % circumference;
        return (float)(360.0 * relDist / circumference);
    }
}

