/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.model;

import cam72cam.immersiverailroading.entity.EntityMoveableRollingStock;
import cam72cam.immersiverailroading.library.ModelComponentType;
import cam72cam.immersiverailroading.model.components.ModelComponent;
import cam72cam.mod.render.obj.OBJRender;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import util.Matrix4;

public class ModelState {
    private final Animator animator;
    private final GroupAnimator groupAnimator;
    private final GroupVisibility groupVisibility;
    private final Lighter lighter;
    private final List<ModelComponent> components;
    private final List<ModelState> children = new ArrayList<ModelState>();
    public static final Pattern lcgPattern = Pattern.compile("_LCG_([^_]+)");
    private static final Map<String, String> lcgCache = new HashMap<String, String>();
    private static final Map<String, Boolean> linvertCache = new HashMap<String, Boolean>();
    private static final Map<String, Boolean> interiorCache = new HashMap<String, Boolean>();
    private static final Map<String, Boolean> fullbrightCache = new HashMap<String, Boolean>();

    private ModelState(Animator animator, GroupAnimator groupAnimator, GroupVisibility groupVisibility, Lighter lighter) {
        this.components = new ArrayList<ModelComponent>();
        this.animator = animator;
        this.groupAnimator = groupAnimator;
        this.groupVisibility = groupVisibility;
        this.lighter = lighter;
    }

    public ModelState push(Consumer<Builder> fn) {
        Builder builder = new Builder(this);
        fn.accept(builder);
        ModelState created = builder.build();
        this.children.add(created);
        return created;
    }

    public Matrix4 getMatrix(EntityMoveableRollingStock stock, float partialTicks) {
        return this.animator != null ? this.animator.getMatrix(stock, partialTicks) : null;
    }

    public Matrix4 getGroupMatrix(EntityMoveableRollingStock stock, String group, float partialTicks) {
        Matrix4 groupMatrix = this.groupAnimator != null ? this.groupAnimator.getMatrix(stock, group, partialTicks) : null;
        Matrix4 baseMatrix = this.getMatrix(stock, partialTicks);
        if (groupMatrix == null) {
            return baseMatrix;
        }
        if (baseMatrix == null) {
            return groupMatrix;
        }
        return baseMatrix.copy().multiply(groupMatrix);
    }

    public void include(ModelComponent component) {
        if (component != null) {
            this.components.add(component);
        }
    }

    public void include(Collection<ModelComponent> components) {
        this.components.addAll(components);
    }

    public static ModelState construct(Consumer<Builder> settings) {
        Builder builder = new Builder();
        settings.accept(builder);
        return builder.build();
    }

    private boolean hasGroupFlag(String group, String filter) {
        for (String x : group.split("_")) {
            if (!x.equals(filter)) continue;
            return true;
        }
        return false;
    }

    public void render(OBJRender.Binding vbo, EntityMoveableRollingStock stock, List<ModelComponentType> available, float partialTicks) {
        LightState lighting;
        List<Object> groups = new ArrayList<String>();
        for (ModelComponent component : this.components) {
            if (available == null) {
                groups.addAll(component.modelIDs);
                continue;
            }
            if (!available.contains((Object)component.type)) continue;
            available.remove((Object)component.type);
            groups.addAll(component.modelIDs);
        }
        if (this.groupVisibility != null) {
            groups = groups.stream().filter(group -> {
                Boolean visible = this.groupVisibility.visible(stock, (String)group);
                return visible == null || visible != false;
            }).collect(Collectors.toList());
        }
        Matrix4 matrix = this.animator != null ? this.animator.getMatrix(stock, partialTicks) : null;
        HashMap<String, Matrix4> animatedGroups = new HashMap<String, Matrix4>();
        if (this.groupAnimator != null) {
            for (String string : groups) {
                Matrix4 m = this.groupAnimator.getMatrix(stock, string, partialTicks);
                if (m == null) continue;
                animatedGroups.put(string, m);
            }
        }
        boolean bl = (lighting = this.lighter.get(stock)).fullBright != null && lighting.fullBright != false;
        boolean hasInterior = lighting.hasInterior != null && lighting.hasInterior != false;
        HashMap<Pair, List> levels = new HashMap<Pair, List>();
        for (String string : groups) {
            Float lcgValue;
            if (!lcgCache.containsKey(string)) {
                Matcher matcher = lcgPattern.matcher(string);
                lcgCache.put(string, matcher.find() ? matcher.group(1) : null);
            }
            String lcg = lcgCache.get(string);
            boolean invertGroup = linvertCache.computeIfAbsent(string, g -> this.hasGroupFlag((String)g, "LINVERT"));
            boolean interiorGroup = interiorCache.computeIfAbsent(string, g -> this.hasGroupFlag((String)g, "INTERIOR"));
            boolean fullbrightGroup = fullbrightCache.computeIfAbsent(string, g -> this.hasGroupFlag((String)g, "FULLBRIGHT"));
            Float f = lcgValue = lcg != null ? Float.valueOf(stock.getControlPosition(lcg)) : null;
            lcgValue = lcgValue == null ? null : Float.valueOf(invertGroup ? 1.0f - lcgValue.floatValue() : lcgValue.floatValue());
            Pair key = null;
            if (lcgValue == null || lcgValue.floatValue() > 0.0f) {
                if (bl && fullbrightGroup) {
                    key = Pair.of((Object)Float.valueOf(1.0f), (Object)Float.valueOf(1.0f));
                } else if (lighting.interiorLight != null && (!hasInterior || interiorGroup)) {
                    key = lcgValue != null ? Pair.of((Object)Float.valueOf(lighting.interiorLight.floatValue() * lcgValue.floatValue()), (Object)lighting.skyLight) : Pair.of((Object)lighting.interiorLight, (Object)lighting.skyLight);
                }
            }
            levels.computeIfAbsent(key, p -> new ArrayList()).add(string);
        }
        levels.forEach((level, litGroups) -> {
            List notAnimated;
            List<String> animated = animatedGroups.isEmpty() ? Collections.emptyList() : litGroups.stream().filter(g -> animatedGroups.containsKey(g)).collect(Collectors.toList());
            List list = notAnimated = animatedGroups.isEmpty() ? litGroups : litGroups.stream().filter(g -> !animatedGroups.containsKey(g)).collect(Collectors.toList());
            if (!notAnimated.isEmpty()) {
                vbo.draw(notAnimated, state -> {
                    if (matrix != null) {
                        state.model_view().multiply(matrix);
                    }
                    if (level != null) {
                        state.lightmap(((Float)level.getKey()).floatValue(), ((Float)level.getValue()).floatValue());
                    }
                });
            }
            if (!animated.isEmpty()) {
                animated.forEach(group -> vbo.draw(Collections.singletonList(group), state -> {
                    if (matrix != null) {
                        state.model_view().multiply(matrix);
                    }
                    state.model_view().multiply((Matrix4)animatedGroups.get(group));
                    if (level != null) {
                        state.lightmap(((Float)level.getKey()).floatValue(), ((Float)level.getValue()).floatValue());
                    }
                }));
            }
        });
        for (ModelState modelState : this.children) {
            modelState.render(vbo, stock, available, partialTicks);
        }
    }

    public static class Builder {
        public static Consumer<Builder> FULLBRIGHT = builder -> builder.add((EntityMoveableRollingStock stock) -> LightState.FULLBRIGHT);
        private Animator animator;
        private GroupAnimator groupAnimator;
        private GroupVisibility groupVisibility;
        private Lighter lighter;

        private Builder() {
            this.animator = null;
            this.groupAnimator = null;
            this.groupVisibility = null;
            this.lighter = null;
        }

        private Builder(ModelState parent) {
            this.animator = parent.animator;
            this.groupAnimator = parent.groupAnimator;
            this.groupVisibility = parent.groupVisibility;
            this.lighter = parent.lighter;
        }

        public Builder add(Animator animator) {
            this.animator = this.animator != null ? this.animator.merge(animator) : animator;
            return this;
        }

        public Builder add(GroupAnimator groupAnimator) {
            this.groupAnimator = this.groupAnimator != null ? this.groupAnimator.merge(groupAnimator) : groupAnimator;
            return this;
        }

        public Builder add(GroupVisibility groupVisibility) {
            this.groupVisibility = this.groupVisibility != null ? this.groupVisibility.merge(groupVisibility) : groupVisibility;
            return this;
        }

        public Builder add(Lighter lighter) {
            this.lighter = this.lighter != null ? this.lighter.merge(lighter) : lighter;
            return this;
        }

        private ModelState build() {
            return new ModelState(this.animator, this.groupAnimator, this.groupVisibility, this.lighter);
        }
    }

    public static class LightState {
        public static final LightState FULLBRIGHT = new LightState(null, null, true, null);
        private final Float interiorLight;
        private final Float skyLight;
        private final Boolean fullBright;
        private final Boolean hasInterior;

        public LightState(Float interiorLight, Float skyLight, Boolean fullBright, Boolean hasInterior) {
            this.interiorLight = interiorLight;
            this.skyLight = skyLight;
            this.fullBright = fullBright;
            this.hasInterior = hasInterior;
        }

        public LightState merge(LightState other) {
            return new LightState(other.interiorLight != null ? other.interiorLight : this.interiorLight, other.skyLight != null ? other.skyLight : this.skyLight, other.fullBright != null ? other.fullBright : this.fullBright, other.hasInterior != null ? other.hasInterior : this.hasInterior);
        }
    }

    @FunctionalInterface
    public static interface Lighter {
        public LightState get(EntityMoveableRollingStock var1);

        default public Lighter merge(Lighter lighter) {
            return stock -> this.get(stock).merge(lighter.get(stock));
        }
    }

    @FunctionalInterface
    public static interface GroupVisibility {
        public Boolean visible(EntityMoveableRollingStock var1, String var2);

        default public GroupVisibility merge(GroupVisibility other) {
            return (stock, group) -> {
                Boolean ourVisible = this.visible(stock, group);
                Boolean otherVisible = other.visible(stock, group);
                if (ourVisible == null) {
                    return otherVisible;
                }
                if (otherVisible == null) {
                    return ourVisible;
                }
                return ourVisible != false && otherVisible != false;
            };
        }
    }

    @FunctionalInterface
    public static interface GroupAnimator {
        public Matrix4 getMatrix(EntityMoveableRollingStock var1, String var2, float var3);

        default public GroupAnimator merge(GroupAnimator other) {
            return (stock, g, partialTicks) -> {
                Matrix4 ourMatrix = this.getMatrix(stock, g, partialTicks);
                Matrix4 newMatrix = other.getMatrix(stock, g, partialTicks);
                if (ourMatrix == null) {
                    return newMatrix;
                }
                if (newMatrix == null) {
                    return ourMatrix;
                }
                return ourMatrix.copy().multiply(newMatrix);
            };
        }
    }

    @FunctionalInterface
    public static interface Animator {
        public Matrix4 getMatrix(EntityMoveableRollingStock var1, float var2);

        default public Animator merge(Animator other) {
            return (stock, partialTicks) -> {
                Matrix4 ourMatrix = this.getMatrix(stock, partialTicks);
                Matrix4 newMatrix = other.getMatrix(stock, partialTicks);
                if (ourMatrix == null) {
                    return newMatrix;
                }
                if (newMatrix == null) {
                    return ourMatrix;
                }
                return ourMatrix.copy().multiply(newMatrix);
            };
        }
    }
}

