/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.gui.overlay;

import cam72cam.immersiverailroading.ConfigGraphics;
import cam72cam.immersiverailroading.entity.EntityMoveableRollingStock;
import cam72cam.immersiverailroading.entity.EntityRollingStock;
import cam72cam.immersiverailroading.entity.Freight;
import cam72cam.immersiverailroading.entity.FreightTank;
import cam72cam.immersiverailroading.entity.Locomotive;
import cam72cam.immersiverailroading.entity.LocomotiveDiesel;
import cam72cam.immersiverailroading.entity.LocomotiveSteam;
import cam72cam.immersiverailroading.util.Speed;
import java.util.Locale;

public enum Stat {
    SPEED,
    MAX_SPEED,
    UNITS_SPEED,
    LIQUID,
    MAX_LIQUID,
    UNITS_LIQUID,
    BOILER_PRESSURE,
    MAX_BOILER_PRESSURE,
    UNITS_BOILER_PRESSURE,
    TEMPERATURE,
    MAX_TEMPERATURE,
    UNITS_TEMPERATURE,
    BRAKE_PRESSURE,
    MAX_BRAKE_PRESSURE,
    UNITS_BRAKE_PRESSURE,
    CARGO_FILL,
    MAX_CARGO_FILL,
    UNITS_CARGO_FILL;


    public String getValue(EntityRollingStock stock) {
        Float temp = null;
        switch (this) {
            case SPEED: {
                if (stock instanceof EntityMoveableRollingStock) {
                    Speed speed = ((EntityMoveableRollingStock)stock).getCurrentSpeed();
                    switch (ConfigGraphics.speedUnit) {
                        case mph: {
                            return String.format("%.2f", Math.abs(speed.imperial()));
                        }
                        case ms: {
                            return String.format("%.2f", Math.abs(speed.metersPerSecond()));
                        }
                        case kmh: {
                            return String.format("%.2f", Math.abs(speed.metric()));
                        }
                    }
                }
                return "";
            }
            case MAX_SPEED: {
                if (stock instanceof Locomotive) {
                    Speed speed = ((Locomotive)stock).getDefinition().getMaxSpeed(stock.gauge);
                    switch (ConfigGraphics.speedUnit) {
                        case mph: {
                            return String.format("%.0f", Math.abs(speed.imperial()));
                        }
                        case ms: {
                            return String.format("%.0f", Math.abs(speed.metersPerSecond()));
                        }
                        case kmh: {
                            return String.format("%.0f", Math.abs(speed.metric()));
                        }
                    }
                }
                return "";
            }
            case UNITS_SPEED: {
                return ConfigGraphics.speedUnit.toUnitString();
            }
            case LIQUID: {
                return stock instanceof FreightTank ? String.format("%.1f", Float.valueOf((float)((FreightTank)stock).getLiquidAmount() / 1000.0f)) : "";
            }
            case MAX_LIQUID: {
                return stock instanceof FreightTank ? String.format("%.1f", Float.valueOf((float)((FreightTank)stock).getTankCapacity().MilliBuckets() / 1000.0f)) : "";
            }
            case UNITS_LIQUID: {
                return "B";
            }
            case BOILER_PRESSURE: {
                return stock instanceof LocomotiveSteam ? String.format("%.1f", Float.valueOf(ConfigGraphics.pressureUnit.convertFromPSI(((LocomotiveSteam)stock).getBoilerPressure()))) : "";
            }
            case MAX_BOILER_PRESSURE: {
                return stock instanceof LocomotiveSteam ? String.format("%.1f", Float.valueOf(ConfigGraphics.pressureUnit.convertFromPSI(((LocomotiveSteam)stock).getDefinition().getMaxPSI(stock.gauge)))) : "";
            }
            case UNITS_BOILER_PRESSURE: {
                return ConfigGraphics.pressureUnit.toUnitString();
            }
            case TEMPERATURE: {
                if (stock instanceof LocomotiveSteam) {
                    temp = Float.valueOf(((LocomotiveSteam)stock).getBoilerTemperature());
                }
                if (stock instanceof LocomotiveDiesel) {
                    temp = Float.valueOf(((LocomotiveDiesel)stock).getEngineTemperature());
                }
                return temp != null ? String.format("%.1f", Float.valueOf(ConfigGraphics.temperatureUnit.convertFromCelcius(temp.floatValue()))) : "";
            }
            case MAX_TEMPERATURE: {
                if (stock instanceof LocomotiveSteam) {
                    temp = Float.valueOf(100.0f);
                }
                if (stock instanceof LocomotiveDiesel) {
                    temp = Float.valueOf(150.0f);
                }
                return temp != null ? String.format("%.1f", Float.valueOf(ConfigGraphics.temperatureUnit.convertFromCelcius(temp.floatValue()))) : "";
            }
            case UNITS_TEMPERATURE: {
                return ConfigGraphics.temperatureUnit.toUnitString();
            }
            case BRAKE_PRESSURE: {
                if (stock instanceof EntityMoveableRollingStock) {
                    return String.format("%s", (int)(((EntityMoveableRollingStock)stock).getBrakePressure() * 100.0f));
                }
                return "";
            }
            case MAX_BRAKE_PRESSURE: {
                return "100";
            }
            case UNITS_BRAKE_PRESSURE: {
                return "%";
            }
            case CARGO_FILL: {
                if (stock instanceof Freight) {
                    return String.format("%s", ((Freight)stock).getPercentCargoFull());
                }
                return "";
            }
            case MAX_CARGO_FILL: {
                return "100";
            }
            case UNITS_CARGO_FILL: {
                return "%";
            }
        }
        return "";
    }

    public String toString() {
        return "stat." + this.name().toLowerCase(Locale.ROOT);
    }
}

