/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.entity.physics;

import cam72cam.immersiverailroading.Config;
import cam72cam.immersiverailroading.entity.EntityCoupleableRollingStock;
import cam72cam.immersiverailroading.entity.Locomotive;
import cam72cam.immersiverailroading.entity.Tender;
import cam72cam.immersiverailroading.entity.physics.Consist;
import cam72cam.immersiverailroading.entity.physics.chrono.ServerChronoState;
import cam72cam.immersiverailroading.library.Gauge;
import cam72cam.immersiverailroading.library.PhysicalMaterials;
import cam72cam.immersiverailroading.library.TrackItems;
import cam72cam.immersiverailroading.physics.MovementTrack;
import cam72cam.immersiverailroading.thirdparty.trackapi.ITrack;
import cam72cam.immersiverailroading.tile.TileRailBase;
import cam72cam.immersiverailroading.util.BlockUtil;
import cam72cam.immersiverailroading.util.Speed;
import cam72cam.immersiverailroading.util.VecUtil;
import cam72cam.mod.entity.boundingbox.IBoundingBox;
import cam72cam.mod.math.Vec3d;
import cam72cam.mod.math.Vec3i;
import cam72cam.mod.util.DegreeFuncs;
import cam72cam.mod.util.FastMath;
import cam72cam.mod.world.World;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Function;

public class SimulationState {
    public int tickID;
    public Vec3d position;
    public double velocity;
    public float yaw;
    public float pitch;
    public IBoundingBox bounds;
    public float yawFront;
    public float yawRear;
    public Vec3d couplerPositionFront;
    public Vec3d couplerPositionRear;
    public UUID interactingFront;
    public UUID interactingRear;
    public float brakePressure;
    public Vec3d recalculatedAt;
    public List<Vec3i> collidingBlocks;
    public List<Vec3i> trackToUpdate;
    public List<Vec3i> interferingBlocks;
    public float interferingResistance;
    public List<Vec3i> blocksToBreak;
    public double directResistance;
    public Configuration config;
    public boolean dirty = true;
    public boolean atRest = true;
    public double collided;
    public boolean sliding;
    public boolean frontPushing;
    public boolean frontPulling;
    public boolean rearPushing;
    public boolean rearPulling;
    public Consist consist;
    public float slackFrontPercent;
    public float slackRearPercent;

    public SimulationState(EntityCoupleableRollingStock stock) {
        this.tickID = ServerChronoState.getState(stock.getWorld()).getServerTickID();
        this.position = stock.getPosition();
        this.velocity = stock.getVelocity().length() * (double)(DegreeFuncs.delta((float)VecUtil.toWrongYaw(stock.getVelocity()), (float)stock.getRotationYaw()) < 90.0f ? 1 : -1);
        this.yaw = stock.getRotationYaw();
        this.pitch = stock.getRotationPitch();
        this.interactingFront = stock.getCoupledUUID(EntityCoupleableRollingStock.CouplerType.FRONT);
        this.interactingRear = stock.getCoupledUUID(EntityCoupleableRollingStock.CouplerType.BACK);
        this.brakePressure = stock.getBrakePressure();
        this.config = new Configuration(stock);
        this.bounds = this.config.bounds.apply(this);
        this.yawFront = stock.getFrontYaw();
        this.yawRear = stock.getRearYaw();
        this.recalculatedAt = this.position;
        this.calculateCouplerPositions();
        this.calculateBlockCollisions(Collections.emptyList());
        this.blocksToBreak = Collections.emptyList();
        this.consist = stock.consist;
        this.dirty = stock.newlyPlaced;
    }

    private SimulationState(SimulationState prev) {
        this.tickID = prev.tickID + 1;
        this.position = prev.position;
        this.velocity = prev.velocity;
        this.yaw = prev.yaw;
        this.pitch = prev.pitch;
        this.interactingFront = prev.interactingFront;
        this.interactingRear = prev.interactingRear;
        this.brakePressure = prev.brakePressure;
        this.config = prev.config;
        this.bounds = prev.bounds;
        this.yawFront = prev.yawFront;
        this.yawRear = prev.yawRear;
        this.couplerPositionFront = prev.couplerPositionFront;
        this.couplerPositionRear = prev.couplerPositionRear;
        this.recalculatedAt = prev.recalculatedAt;
        this.collidingBlocks = prev.collidingBlocks;
        this.trackToUpdate = prev.trackToUpdate;
        this.interferingBlocks = prev.interferingBlocks;
        this.interferingResistance = prev.interferingResistance;
        this.blocksToBreak = Collections.emptyList();
        this.directResistance = prev.directResistance;
        this.slackFrontPercent = prev.slackFrontPercent;
        this.slackRearPercent = prev.slackRearPercent;
        this.consist = prev.consist;
    }

    public void calculateCouplerPositions() {
        Vec3d bogeyFront = VecUtil.fromWrongYawPitch(this.config.offsetFront, this.yaw, this.pitch);
        Vec3d bogeyRear = VecUtil.fromWrongYawPitch(this.config.offsetRear, this.yaw, this.pitch);
        Vec3d positionFront = this.couplerPositionFront = this.position.add(bogeyFront);
        Vec3d positionRear = this.couplerPositionRear = this.position.add(bogeyRear);
        ITrack trackFront = MovementTrack.findTrack(this.config.world, positionFront, this.yaw, this.config.gauge.value());
        ITrack trackRear = MovementTrack.findTrack(this.config.world, positionRear, this.yaw, this.config.gauge.value());
        if (trackFront != null && trackRear != null) {
            Vec3d couplerVecFront = VecUtil.fromWrongYaw(this.config.couplerDistanceFront - (double)this.config.offsetFront, this.yawFront);
            Vec3d couplerVecRear = VecUtil.fromWrongYaw(this.config.couplerDistanceRear - (double)this.config.offsetRear, this.yawRear);
            this.couplerPositionFront = trackFront.getNextPosition(positionFront, couplerVecFront);
            this.couplerPositionRear = trackRear.getNextPosition(positionRear, couplerVecRear);
        }
        if (Objects.equals(this.couplerPositionFront, positionFront)) {
            this.couplerPositionFront = this.position.add(VecUtil.fromWrongYaw(this.config.couplerDistanceFront, this.yaw));
        }
        if (Objects.equals(this.couplerPositionRear, positionRear)) {
            this.couplerPositionRear = this.position.add(VecUtil.fromWrongYaw(this.config.couplerDistanceRear, this.yaw));
        }
    }

    public void calculateBlockCollisions(List<Vec3i> blocksAlreadyBroken) {
        this.collidingBlocks = this.config.world.blocksInBounds(this.bounds);
        this.trackToUpdate = new ArrayList<Vec3i>();
        this.interferingBlocks = new ArrayList<Vec3i>();
        this.interferingResistance = 0.0f;
        for (Vec3i bp : this.collidingBlocks) {
            if (blocksAlreadyBroken.contains(bp)) continue;
            if (BlockUtil.isIRRail(this.config.world, bp)) {
                this.trackToUpdate.add(bp);
                continue;
            }
            if (!Config.ConfigDamage.TrainsBreakBlocks || BlockUtil.isIRRail(this.config.world, bp.up()) || !((double)bp.y >= this.position.y - this.position.y % 1.0)) continue;
            this.interferingBlocks.add(bp);
            this.interferingResistance += this.config.world.getBlockHardness(bp);
        }
    }

    public SimulationState next() {
        SimulationState next = new SimulationState(this);
        next.dirty = false;
        return next;
    }

    public SimulationState next(double distance, List<Vec3i> blocksAlreadyBroken) {
        SimulationState next = new SimulationState(this);
        next.moveAlongTrack(distance);
        if (this.position.equals((Object)next.position)) {
            next.velocity = 0.0;
        } else {
            next.calculateCouplerPositions();
            next.bounds = next.config.bounds.apply(next);
            this.blocksToBreak = this.interferingBlocks;
            blocksAlreadyBroken.addAll(this.blocksToBreak);
            double minDist = Math.max(0.5, Math.abs(this.velocity * 4.0));
            if (next.recalculatedAt.distanceToSquared(next.position) > minDist * minDist) {
                next.calculateBlockCollisions(blocksAlreadyBroken);
                next.recalculatedAt = next.position;
                next.directResistance = (Double)this.config.directResistanceNewtons.apply(this.trackToUpdate);
            } else {
                next.interferingBlocks = Collections.emptyList();
                next.interferingResistance = 0.0f;
            }
        }
        return next;
    }

    public void update(EntityCoupleableRollingStock stock) {
        Configuration oldConfig = this.config;
        this.config = new Configuration(stock);
        this.dirty = this.dirty || !this.config.equals(oldConfig);
    }

    private void moveAlongTrack(double distance) {
        boolean isReversed;
        Vec3d positionFront = VecUtil.fromWrongYawPitch(this.config.offsetFront, this.yaw, this.pitch).add(this.position);
        Vec3d positionRear = VecUtil.fromWrongYawPitch(this.config.offsetRear, this.yaw, this.pitch).add(this.position);
        ITrack trackFront = MovementTrack.findTrack(this.config.world, positionFront, this.yawFront, this.config.gauge.value());
        ITrack trackRear = MovementTrack.findTrack(this.config.world, positionRear, this.yawRear, this.config.gauge.value());
        if (trackFront == null || trackRear == null) {
            return;
        }
        boolean isTurnTable = false;
        if (Math.abs(distance) < 1.0E-4) {
            TileRailBase frontBase = trackFront instanceof TileRailBase ? (TileRailBase)trackFront : null;
            TileRailBase rearBase = trackRear instanceof TileRailBase ? (TileRailBase)trackRear : null;
            isTurnTable = frontBase != null && frontBase.getParentTile() != null && frontBase.getParentTile().info.settings.type == TrackItems.TURNTABLE;
            boolean bl = isTurnTable = isTurnTable || rearBase != null && rearBase.getParentTile() != null && rearBase.getParentTile().info.settings.type == TrackItems.TURNTABLE;
            if (!isTurnTable) {
                return;
            }
        }
        boolean bl = isReversed = distance < 0.0;
        if (isReversed) {
            distance = -distance;
            this.yawFront += 180.0f;
            this.yawRear += 180.0f;
        }
        Vec3d nextFront = trackFront.getNextPosition(positionFront, VecUtil.fromWrongYaw(distance, this.yawFront));
        Vec3d nextRear = trackRear.getNextPosition(positionRear, VecUtil.fromWrongYaw(distance, this.yawRear));
        if (!nextFront.equals((Object)positionFront) && !nextRear.equals((Object)positionRear)) {
            this.yawFront = VecUtil.toWrongYaw(nextFront.subtract(positionFront));
            this.yawRear = VecUtil.toWrongYaw(nextRear.subtract(positionRear));
            Vec3d deltaCenter = nextFront.subtract(this.position).scale((double)this.config.offsetRear).subtract(nextRear.subtract(this.position).scale((double)this.config.offsetFront)).scale((double)(-1.0f / (this.config.offsetFront - this.config.offsetRear)));
            Vec3d bogeyDelta = nextFront.subtract(nextRear);
            this.yaw = VecUtil.toWrongYaw(bogeyDelta);
            this.pitch = (float)Math.toDegrees(FastMath.atan2((double)bogeyDelta.y, (double)nextRear.distanceTo(nextFront)));
            this.position = this.position.add(deltaCenter);
        }
        if (isReversed) {
            this.yawFront += 180.0f;
            this.yawRear += 180.0f;
        }
        if (isTurnTable) {
            this.yawFront = this.yaw;
            this.yawRear = this.yaw;
        }
        if (DegreeFuncs.delta((float)this.yawFront, (float)this.yaw) > 90.0f || DegreeFuncs.delta((float)this.yawFront, (float)this.yawRear) > 90.0f) {
            this.yawFront = this.yaw;
            this.yawRear = this.yaw;
        }
    }

    public double forcesNewtons() {
        double gradeForceNewtons = this.config.massKg * -9.8 * Math.sin(Math.toRadians(this.pitch)) * Config.ConfigBalance.slopeMultiplier;
        return this.config.tractiveEffortNewtons(Speed.fromMinecraft(this.velocity)) + gradeForceNewtons;
    }

    public boolean atRest() {
        return this.velocity == 0.0 && Math.abs(this.forcesNewtons()) < this.frictionNewtons();
    }

    public double frictionNewtons() {
        double rollingResistanceNewtons = this.config.rollingResistanceCoefficient * (this.config.massKg * 9.8);
        double startingFriction = this.velocity == 0.0 ? 0.001 * this.config.massKg * 9.8 : 0.0;
        double blockResistanceNewtons = this.interferingResistance * 1000.0f * (float)Config.ConfigDamage.blockHardness;
        double brakeAdhesionNewtons = this.config.designAdhesionNewtons * Math.min(1.0, Math.max((double)this.brakePressure, this.config.independentBrakePosition));
        this.sliding = false;
        if (brakeAdhesionNewtons > this.config.maximumAdhesionNewtons && Math.abs(this.velocity) > 0.01) {
            double kineticFriction = PhysicalMaterials.STEEL.kineticFriction(PhysicalMaterials.STEEL);
            brakeAdhesionNewtons = this.config.massKg * kineticFriction;
            this.sliding = true;
        }
        return rollingResistanceNewtons + blockResistanceNewtons + (brakeAdhesionNewtons *= Config.ConfigBalance.brakeMultiplier) + this.directResistance + startingFriction;
    }

    public static class Configuration {
        public UUID id;
        public Gauge gauge;
        public World world;
        public double width;
        public double length;
        public double height;
        public Function<SimulationState, IBoundingBox> bounds;
        public float offsetFront;
        public float offsetRear;
        public boolean couplerEngagedFront;
        public boolean couplerEngagedRear;
        public double couplerDistanceFront;
        public double couplerDistanceRear;
        public double couplerSlackFront;
        public double couplerSlackRear;
        public double massKg;
        public double maximumAdhesionNewtons;
        public double designAdhesionNewtons;
        public double rollingResistanceCoefficient;
        private final Function<List<Vec3i>, Double> directResistanceNewtons;
        private double tractiveEffortFactors;
        private Function<Speed, Double> tractiveEffortNewtons;
        public Double desiredBrakePressure;
        public double independentBrakePosition;
        public boolean hasPressureBrake;

        public Configuration(EntityCoupleableRollingStock stock) {
            double designMassKg;
            this.id = stock.getUUID();
            this.gauge = stock.gauge;
            this.world = stock.getWorld();
            this.width = stock.getDefinition().getWidth(this.gauge);
            this.length = stock.getDefinition().getLength(this.gauge);
            this.height = stock.getDefinition().getHeight(this.gauge);
            double pitchOffset = Math.abs(Math.sin(Math.toRadians(stock.getRotationPitch())) * this.length);
            this.bounds = s -> stock.getDefinition().getBounds(s.yaw, this.gauge).offset(s.position.add(0.0, -(s.position.y % 1.0) - pitchOffset, 0.0)).contract(new Vec3d(0.0, 0.0, 0.5 * this.gauge.scale()));
            this.offsetFront = stock.getDefinition().getBogeyFront(this.gauge);
            this.offsetRear = stock.getDefinition().getBogeyRear(this.gauge);
            this.couplerEngagedFront = stock.isCouplerEngaged(EntityCoupleableRollingStock.CouplerType.FRONT);
            this.couplerEngagedRear = stock.isCouplerEngaged(EntityCoupleableRollingStock.CouplerType.BACK);
            this.couplerDistanceFront = stock.getDefinition().getCouplerPosition(EntityCoupleableRollingStock.CouplerType.FRONT, this.gauge);
            this.couplerDistanceRear = -stock.getDefinition().getCouplerPosition(EntityCoupleableRollingStock.CouplerType.BACK, this.gauge);
            this.couplerSlackFront = stock.getDefinition().getCouplerSlack(EntityCoupleableRollingStock.CouplerType.FRONT, this.gauge);
            this.couplerSlackRear = stock.getDefinition().getCouplerSlack(EntityCoupleableRollingStock.CouplerType.BACK, this.gauge);
            this.massKg = stock.getWeight();
            double d = designMassKg = !Config.ConfigBalance.FuelRequired && (stock instanceof Locomotive || stock instanceof Tender) ? this.massKg : stock.getMaxWeight();
            if (stock instanceof Locomotive) {
                Locomotive locomotive = (Locomotive)stock;
                this.tractiveEffortNewtons = locomotive::getTractiveEffortNewtons;
                this.tractiveEffortFactors = locomotive.getThrottle() + locomotive.getReverser() * 10.0f;
                this.desiredBrakePressure = locomotive.getTrainBrake();
            } else {
                this.tractiveEffortNewtons = speed -> 0.0;
                this.tractiveEffortFactors = 0.0;
                this.desiredBrakePressure = null;
            }
            double staticFriction = PhysicalMaterials.STEEL.staticFriction(PhysicalMaterials.STEEL);
            this.maximumAdhesionNewtons = this.massKg * staticFriction * 9.8 * stock.getBrakeAdhesionEfficiency();
            this.designAdhesionNewtons = designMassKg * staticFriction * 9.8 * stock.getBrakeSystemEfficiency();
            this.independentBrakePosition = stock.getIndependentBrake();
            this.directResistanceNewtons = stock::getDirectFrictionNewtons;
            this.hasPressureBrake = stock.getDefinition().hasPressureBrake();
            this.rollingResistanceCoefficient = stock.getDefinition().rollingResistanceCoefficient;
        }

        public boolean equals(Object o) {
            if (o instanceof Configuration) {
                Configuration other = (Configuration)o;
                return this.couplerEngagedFront == other.couplerEngagedFront && this.couplerEngagedRear == other.couplerEngagedRear && Math.abs(this.tractiveEffortFactors - other.tractiveEffortFactors) < 0.01 && Math.abs(this.massKg - other.massKg) / this.massKg < 0.01 && (this.desiredBrakePressure == null || Math.abs(this.desiredBrakePressure - other.desiredBrakePressure) < 0.001) && Math.abs(this.independentBrakePosition - other.independentBrakePosition) < 0.01;
            }
            return false;
        }

        public double tractiveEffortNewtons(Speed speed) {
            return this.tractiveEffortNewtons.apply(speed);
        }
    }
}

